/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import data.Tables;
import doom.DoomMain;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import m.fixed_t;
import rr.PlaneDrawer;
import rr.RendererState;
import rr.SceneRenderer;
import rr.drawfuns.ColVars;
import rr.parallel.MaskedWorker;
import rr.parallel.RWI;
import rr.parallel.RenderSegExecutor;
import rr.parallel.RenderSegInstruction;
import rr.parallel.RenderWallExecutor;
import utils.C2JUtils;

public abstract class AbstractParallelRenderer<T, V>
extends RendererState<T, V>
implements RWI.Init<T, V> {
    protected final int NUMWALLTHREADS;
    protected final int NUMMASKEDTHREADS;
    protected final int NUMFLOORTHREADS;
    protected Executor tp;
    protected Runnable[] vpw;
    protected MaskedWorker<T, V>[] maskedworkers;
    protected CyclicBarrier drawsegsbarrier;
    protected CyclicBarrier visplanebarrier;
    protected CyclicBarrier maskedbarrier;
    protected static final boolean DEBUG = false;
    RWI.Get<T, V> RWIs;

    public AbstractParallelRenderer(DoomMain<T, V> DM, int wallthread, int floorthreads, int nummaskedthreads) {
        super(DM);
        this.NUMWALLTHREADS = wallthread;
        this.NUMFLOORTHREADS = floorthreads;
        this.NUMMASKEDTHREADS = nummaskedthreads;
        this.drawsegsbarrier = new CyclicBarrier(this.NUMWALLTHREADS + 1);
        this.visplanebarrier = new CyclicBarrier(this.NUMFLOORTHREADS + 1);
        this.maskedbarrier = new CyclicBarrier(this.NUMMASKEDTHREADS + 1);
        this.tp = Executors.newCachedThreadPool();
    }

    public AbstractParallelRenderer(DoomMain<T, V> DM, int wallthread, int floorthreads) {
        super(DM);
        this.NUMWALLTHREADS = wallthread;
        this.NUMFLOORTHREADS = floorthreads;
        this.NUMMASKEDTHREADS = 1;
        this.drawsegsbarrier = new CyclicBarrier(this.NUMWALLTHREADS + 1);
        this.visplanebarrier = new CyclicBarrier(this.NUMFLOORTHREADS + 1);
        this.maskedbarrier = new CyclicBarrier(this.NUMMASKEDTHREADS + 1);
        this.tp = Executors.newCachedThreadPool();
    }

    @Override
    public void Init() {
        super.Init();
        this.InitParallelStuff();
    }

    protected abstract void InitParallelStuff();

    @Override
    public RenderWallExecutor<T, V>[] InitRWIExecutors(int num, ColVars<T, V>[] RWI2) {
        return null;
    }

    protected final class ParallelPlanes2<T, V>
    extends PlaneDrawer<T, V> {
        protected ParallelPlanes2(DoomMain<T, V> DOOM, SceneRenderer<T, V> R) {
            super(DOOM, R);
        }

        @Override
        public void DrawPlanes() {
            for (int i = 0; i < AbstractParallelRenderer.this.NUMFLOORTHREADS; ++i) {
                AbstractParallelRenderer.this.tp.execute(AbstractParallelRenderer.this.vpw[i]);
            }
        }
    }

    protected final class ParallelSegs2<T, V>
    extends RendererState.SegDrawer {
        RenderSegInstruction<V>[] RSI;
        int RSIcount;
        RenderSegExecutor<byte[], V>[] RSIExec;
        final AbstractParallelRenderer<T, V> APR;

        ParallelSegs2(AbstractParallelRenderer<T, V> APR) {
            super(AbstractParallelRenderer.this, APR);
            this.RSIcount = 0;
            this.APR = APR;
        }

        @Override
        protected void RenderSegLoop() {
            int texturecolumn = 0;
            this.GenerateRSI();
            while (this.rw_x < this.rw_stopx) {
                int yh;
                int bottom;
                int top;
                int yl = this.topfrac + 4096 - 1 >> 12;
                if (yl < this.ceilingclip[this.rw_x] + 1) {
                    yl = this.ceilingclip[this.rw_x] + 1;
                }
                if (this.markceiling) {
                    top = this.ceilingclip[this.rw_x] + 1;
                    bottom = yl - 1;
                    if (bottom >= this.floorclip[this.rw_x]) {
                        bottom = this.floorclip[this.rw_x] - 1;
                    }
                    if (top <= bottom) {
                        this.vp_vars.visplanes[this.vp_vars.ceilingplane].setTop(this.rw_x, (char)top);
                        this.vp_vars.visplanes[this.vp_vars.ceilingplane].setBottom(this.rw_x, (char)bottom);
                    }
                }
                if ((yh = this.bottomfrac >> 12) >= this.floorclip[this.rw_x]) {
                    yh = this.floorclip[this.rw_x] - 1;
                }
                if (this.markfloor) {
                    top = yh + 1;
                    bottom = this.floorclip[this.rw_x] - 1;
                    if (top <= this.ceilingclip[this.rw_x]) {
                        top = this.ceilingclip[this.rw_x] + 1;
                    }
                    if (top <= bottom) {
                        this.vp_vars.visplanes[this.vp_vars.floorplane].setTop(this.rw_x, (char)top);
                        this.vp_vars.visplanes[this.vp_vars.floorplane].setBottom(this.rw_x, (char)bottom);
                    }
                }
                if (this.segtextured) {
                    int angle = Tables.toBAMIndex(this.rw_centerangle + (long)((int)this.APR.view.xtoviewangle[this.rw_x]));
                    texturecolumn = this.rw_offset - fixed_t.FixedMul(Tables.finetangent[angle], this.rw_distance);
                    texturecolumn >>= 16;
                }
                if (this.midtexture != 0) {
                    ((AbstractParallelRenderer)this.APR).dcvars.dc_source = ((AbstractParallelRenderer)this.APR).TexMan.GetCachedColumn(this.midtexture, texturecolumn);
                    this.ceilingclip[this.rw_x] = (short)this.APR.view.height;
                    this.floorclip[this.rw_x] = -1;
                } else {
                    int mid;
                    if (this.toptexture != 0) {
                        mid = this.pixhigh >> 12;
                        this.pixhigh += this.pixhighstep;
                        if (mid >= this.floorclip[this.rw_x]) {
                            mid = this.floorclip[this.rw_x] - 1;
                        }
                        if (mid >= yl) {
                            ((AbstractParallelRenderer)this.APR).dcvars.dc_source = ((AbstractParallelRenderer)this.APR).TexMan.GetCachedColumn(this.toptexture, texturecolumn);
                            this.ceilingclip[this.rw_x] = (short)mid;
                        } else {
                            this.ceilingclip[this.rw_x] = (short)(yl - 1);
                        }
                    } else if (this.markceiling) {
                        this.ceilingclip[this.rw_x] = (short)(yl - 1);
                    }
                    if (this.bottomtexture != 0) {
                        mid = this.pixlow + 4096 - 1 >> 12;
                        this.pixlow += this.pixlowstep;
                        if (mid <= this.ceilingclip[this.rw_x]) {
                            mid = this.ceilingclip[this.rw_x] + 1;
                        }
                        if (mid <= yh) {
                            ((AbstractParallelRenderer)this.APR).dcvars.dc_source = ((AbstractParallelRenderer)this.APR).TexMan.GetCachedColumn(this.bottomtexture, texturecolumn);
                            this.floorclip[this.rw_x] = (short)mid;
                        } else {
                            this.floorclip[this.rw_x] = (short)(yh + 1);
                        }
                    } else if (this.markfloor) {
                        this.floorclip[this.rw_x] = (short)(yh + 1);
                    }
                    if (this.maskedtexture) {
                        this.seg_vars.maskedtexturecol[this.seg_vars.pmaskedtexturecol + this.rw_x] = (short)texturecolumn;
                    }
                }
                this.rw_scale += this.rw_scalestep;
                this.topfrac += this.topstep;
                this.bottomfrac += this.bottomstep;
                ++this.rw_x;
            }
        }

        void GenerateRSI() {
            if (this.RSIcount >= this.RSI.length) {
                this.ResizeRSIBuffer();
            }
            RenderSegInstruction<V> rsi = this.RSI[this.RSIcount];
            rsi.centery = this.APR.view.centery;
            rsi.bottomfrac = this.bottomfrac;
            rsi.bottomstep = this.bottomstep;
            rsi.bottomtexture = this.bottomtexture;
            rsi.markceiling = this.markceiling;
            rsi.markfloor = this.markfloor;
            rsi.midtexture = this.midtexture;
            rsi.pixhigh = this.pixhigh;
            rsi.pixhighstep = this.pixhighstep;
            rsi.pixlow = this.pixlow;
            rsi.pixlowstep = this.pixlowstep;
            rsi.rw_bottomtexturemid = this.rw_bottomtexturemid;
            rsi.rw_centerangle = this.rw_centerangle;
            rsi.rw_distance = this.rw_distance;
            rsi.rw_midtexturemid = this.rw_midtexturemid;
            rsi.rw_offset = this.rw_offset;
            rsi.rw_scale = this.rw_scale;
            rsi.rw_scalestep = this.rw_scalestep;
            rsi.rw_stopx = this.rw_stopx;
            rsi.rw_toptexturemid = this.rw_toptexturemid;
            rsi.rw_x = this.rw_x;
            rsi.segtextured = this.segtextured;
            rsi.topfrac = this.topfrac;
            rsi.topstep = this.topstep;
            rsi.toptexture = this.toptexture;
            rsi.walllights = this.APR.colormaps.walllights;
            rsi.viewheight = this.APR.view.height;
            ++this.RSIcount;
        }

        @Override
        protected void CompleteColumn() {
        }

        void RenderRSIPipeline() {
            for (int i = 0; i < this.APR.NUMWALLTHREADS; ++i) {
                this.RSIExec[i].setRSIEnd(this.RSIcount);
                this.APR.tp.execute(this.RSIExec[i]);
            }
            this.RSIcount = 0;
        }

        void ResizeRSIBuffer() {
            RenderSegInstruction fake = new RenderSegInstruction();
            this.RSI = C2JUtils.resize(fake, this.RSI, this.RSI.length * 2);
            for (int i = 0; i < this.APR.NUMWALLTHREADS; ++i) {
                this.RSIExec[i].updateRSI(this.RSI);
            }
            System.out.println("RWI Buffer resized. Actual capacity " + this.RSI.length);
        }
    }

    protected final class ParallelPlanes<T, V>
    extends PlaneDrawer<T, V> {
        protected ParallelPlanes(DoomMain<T, V> DOOM, SceneRenderer<T, V> R) {
            super(DOOM, R);
        }

        @Override
        public void DrawPlanes() {
            for (int i = 0; i < AbstractParallelRenderer.this.NUMFLOORTHREADS; ++i) {
                AbstractParallelRenderer.this.tp.execute(AbstractParallelRenderer.this.vpw[i]);
            }
        }
    }

    protected final class ParallelSegs
    extends RendererState.SegDrawer
    implements RWI.Get<T, V> {
        RenderWallExecutor<T, V>[] RWIExec;
        ColVars<T, V>[] RWI;
        int RWIcount;

        ParallelSegs(SceneRenderer<?, ?> R) {
            super(AbstractParallelRenderer.this, R);
            this.RWIcount = 0;
            ColVars fake = new ColVars();
            this.RWI = C2JUtils.createArrayOfObjects(fake, 3 * ((AbstractParallelRenderer)AbstractParallelRenderer.this).DOOM.vs.getScreenWidth());
        }

        @Override
        protected void CompleteColumn() {
            if (this.RWIcount >= this.RWI.length) {
                this.ResizeRWIBuffer();
            }
            this.RWI[this.RWIcount].copyFrom(AbstractParallelRenderer.this.dcvars);
            ++this.RWIcount;
        }

        @Override
        public void CompleteRendering() {
            for (int i = 0; i < AbstractParallelRenderer.this.NUMWALLTHREADS; ++i) {
                this.RWIExec[i].setRange(i * this.RWIcount / AbstractParallelRenderer.this.NUMWALLTHREADS, (i + 1) * this.RWIcount / AbstractParallelRenderer.this.NUMWALLTHREADS);
                AbstractParallelRenderer.this.tp.execute(this.RWIExec[i]);
            }
            this.RWIcount = 0;
        }

        void ResizeRWIBuffer() {
            ColVars fake = new ColVars();
            this.RWI = C2JUtils.resize(fake, this.RWI, this.RWI.length * 2);
            for (int i = 0; i < AbstractParallelRenderer.this.NUMWALLTHREADS; ++i) {
                this.RWIExec[i].updateRWI(this.RWI);
            }
        }

        @Override
        public ColVars<T, V>[] getRWI() {
            return this.RWI;
        }

        @Override
        public void setExecutors(RenderWallExecutor<T, V>[] RWIExec) {
            this.RWIExec = RWIExec;
        }

        @Override
        public void sync() {
            try {
                AbstractParallelRenderer.this.drawsegsbarrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                e.printStackTrace();
            }
        }
    }
}

