/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import rr.AbstractThings;
import rr.IDetailAware;
import rr.SceneRenderer;
import rr.drawfuns.ColVars;
import rr.parallel.RenderMaskedExecutor;
import utils.C2JUtils;
import v.scale.VideoScale;
import v.tables.BlurryTable;

public abstract class ParallelThings<T, V>
extends AbstractThings<T, V> {
    protected ColVars<T, V>[] RMI;
    protected int RMIcount = 0;
    protected RenderMaskedExecutor<T, V>[] RMIExec;
    protected final int NUMMASKEDTHREADS;
    protected final CyclicBarrier maskedbarrier;
    protected final Executor tp;
    int flags;

    public ParallelThings(VideoScale vs, SceneRenderer<T, V> R, Executor tp, int numthreads) {
        super(vs, R);
        this.tp = tp;
        this.NUMMASKEDTHREADS = numthreads;
        this.maskedbarrier = new CyclicBarrier(this.NUMMASKEDTHREADS + 1);
    }

    @Override
    public void DrawMasked() {
        super.DrawMasked();
        this.RenderRMIPipeline();
        try {
            this.maskedbarrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void completeColumn() {
        if (this.view.detailshift == 1) {
            this.flags = 8;
        }
        if (this.RMIcount >= this.RMI.length) {
            this.ResizeRMIBuffer();
        }
        this.RMI[this.RMIcount].copyFrom(this.maskedcvars, this.colfunc.getFlags());
        ++this.RMIcount;
    }

    protected void RenderRMIPipeline() {
        for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
            this.RMIExec[i].setRange(i * this.vs.getScreenWidth() / this.NUMMASKEDTHREADS, (i + 1) * this.vs.getScreenWidth() / this.NUMMASKEDTHREADS);
            this.RMIExec[i].setRMIEnd(this.RMIcount);
            this.tp.execute(this.RMIExec[i]);
        }
        this.RMIcount = 0;
    }

    protected void ResizeRMIBuffer() {
        ColVars fake = new ColVars();
        ColVars<T, V>[] tmp = C2JUtils.createArrayOfObjects(fake, this.RMI.length * 2);
        System.arraycopy(this.RMI, 0, tmp, 0, this.RMI.length);
        this.RMI = tmp;
        for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
            this.RMIExec[i].updateRMI(this.RMI);
        }
        System.err.println("RMI Buffer resized. Actual capacity " + this.RMI.length);
    }

    protected abstract void InitRMISubsystem(int[] var1, int[] var2, V var3, CyclicBarrier var4, BlurryTable var5, List<IDetailAware> var6);

    public static class TrueColor
    extends ParallelThings<byte[], int[]> {
        public TrueColor(VideoScale vs, SceneRenderer<byte[], int[]> R, Executor tp, int numthreads) {
            super(vs, R, tp, numthreads);
        }

        @Override
        protected void InitRMISubsystem(int[] columnofs, int[] ylookup, int[] screen, CyclicBarrier maskedbarrier, BlurryTable BLURRY_MAP, List<IDetailAware> detailaware) {
            for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
                this.RMIExec[i] = new RenderMaskedExecutor.TrueColor(this.vs.getScreenWidth(), this.vs.getScreenHeight(), columnofs, ylookup, screen, this.RMI, maskedbarrier, this.I, BLURRY_MAP);
                detailaware.add(this.RMIExec[i]);
            }
        }
    }

    public static class HiColor
    extends ParallelThings<byte[], short[]> {
        public HiColor(VideoScale vs, SceneRenderer<byte[], short[]> R, Executor tp, int numthreads) {
            super(vs, R, tp, numthreads);
        }

        @Override
        protected void InitRMISubsystem(int[] columnofs, int[] ylookup, short[] screen, CyclicBarrier maskedbarrier, BlurryTable BLURRY_MAP, List<IDetailAware> detailaware) {
            for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
                this.RMIExec[i] = new RenderMaskedExecutor.HiColor(this.vs.getScreenWidth(), this.vs.getScreenHeight(), columnofs, ylookup, screen, this.RMI, maskedbarrier, this.I, BLURRY_MAP);
                detailaware.add(this.RMIExec[i]);
            }
        }
    }

    public static class Indexed
    extends ParallelThings<byte[], byte[]> {
        public Indexed(VideoScale vs, SceneRenderer<byte[], byte[]> R, Executor tp, int numthreads) {
            super(vs, R, tp, numthreads);
        }

        @Override
        protected void InitRMISubsystem(int[] columnofs, int[] ylookup, byte[] screen, CyclicBarrier maskedbarrier, BlurryTable BLURRY_MAP, List<IDetailAware> detailaware) {
            for (int i = 0; i < this.NUMMASKEDTHREADS; ++i) {
                this.RMIExec[i] = new RenderMaskedExecutor.Indexed(this.vs.getScreenWidth(), this.vs.getScreenHeight(), columnofs, ylookup, screen, this.RMI, maskedbarrier, this.I, BLURRY_MAP);
                detailaware.add(this.RMIExec[i]);
            }
        }
    }
}

