/*
 * Decompiled with CFR 0.152.
 */
package rr.parallel;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import rr.IDetailAware;
import rr.drawfuns.ColVars;
import rr.drawfuns.DoomColumnFunction;
import rr.drawfuns.R_DrawColumnBoomOpt;
import rr.drawfuns.R_DrawColumnBoomOptLow;

public class RenderWallExecutor<T, V>
implements Runnable,
IDetailAware {
    protected CyclicBarrier barrier;
    protected ColVars<T, V>[] RWI;
    protected int start;
    protected int end;
    protected DoomColumnFunction<T, V> colfunchi;
    protected DoomColumnFunction<T, V> colfunclow;
    protected DoomColumnFunction<T, V> colfunc;
    protected final int SCREENWIDTH;
    protected final int SCREENHEIGHT;

    public RenderWallExecutor(int SCREENWIDTH, int SCREENHEIGHT, int[] columnofs, int[] ylookup, V screen, ColVars<T, V>[] RWI2, CyclicBarrier barrier) {
        this.RWI = RWI2;
        this.barrier = barrier;
        this.SCREENWIDTH = SCREENWIDTH;
        this.SCREENHEIGHT = SCREENHEIGHT;
    }

    public void setRange(int start, int end) {
        this.end = end;
        this.start = start;
    }

    @Override
    public void setDetail(int detailshift) {
        this.colfunc = detailshift == 0 ? this.colfunchi : this.colfunclow;
    }

    @Override
    public void run() {
        for (int i = this.start; i < this.end; ++i) {
            this.colfunc.invoke(this.RWI[i]);
        }
        try {
            this.barrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
        }
    }

    public void updateRWI(ColVars<T, V>[] RWI2) {
        this.RWI = RWI2;
    }

    public static final class TrueColor
    extends RenderWallExecutor<byte[], int[]> {
        public TrueColor(int SCREENWIDTH, int SCREENHEIGHT, int[] columnofs, int[] ylookup, int[] screen, ColVars<byte[], int[]>[] RWI2, CyclicBarrier barrier) {
            super(SCREENWIDTH, SCREENHEIGHT, columnofs, ylookup, screen, RWI2, barrier);
            this.colfunc = this.colfunchi = new R_DrawColumnBoomOpt.TrueColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, null);
            this.colfunclow = new R_DrawColumnBoomOptLow.TrueColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, null);
        }
    }

    public static final class Indexed
    extends RenderWallExecutor<byte[], byte[]> {
        public Indexed(int SCREENWIDTH, int SCREENHEIGHT, int[] columnofs, int[] ylookup, byte[] screen, ColVars<byte[], byte[]>[] RWI2, CyclicBarrier barrier) {
            super(SCREENWIDTH, SCREENHEIGHT, columnofs, ylookup, screen, RWI2, barrier);
            this.colfunc = this.colfunchi = new R_DrawColumnBoomOpt.Indexed(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, null);
            this.colfunclow = new R_DrawColumnBoomOptLow.Indexed(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, null);
        }
    }

    public static final class HiColor
    extends RenderWallExecutor<byte[], short[]> {
        public HiColor(int SCREENWIDTH, int SCREENHEIGHT, int[] columnofs, int[] ylookup, short[] screen, ColVars<byte[], short[]>[] RWI2, CyclicBarrier barrier) {
            super(SCREENWIDTH, SCREENHEIGHT, columnofs, ylookup, screen, RWI2, barrier);
            this.colfunc = this.colfunchi = new R_DrawColumnBoomOpt.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, null);
            this.colfunclow = new R_DrawColumnBoomOptLow.HiColor(SCREENWIDTH, SCREENHEIGHT, ylookup, columnofs, null, screen, null);
        }
    }
}

