/*
 * Decompiled with CFR 0.152.
 */
package rr;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import m.IRandom;
import mochadoom.Loggers;
import p.Resettable;
import p.ThinkerList;
import p.mobj_t;
import rr.SectorAction;
import rr.line_t;
import s.degenmobj_t;
import utils.C2JUtils;
import w.DoomIO;
import w.IPackableDoomObject;
import w.IReadableDoomObject;

public class sector_t
implements IReadableDoomObject,
IPackableDoomObject,
Resettable {
    public ThinkerList TL;
    public IRandom RND;
    public int floorheight;
    public int ceilingheight;
    public short floorpic;
    public short ceilingpic;
    public short lightlevel;
    public short special;
    public short tag;
    public int soundtraversed;
    public mobj_t soundtarget;
    public int[] blockbox = new int[4];
    public degenmobj_t soundorg;
    public int validcount;
    public mobj_t thinglist;
    public SectorAction specialdata;
    public int linecount;
    public line_t[] lines;
    public int id = -1;
    public int nexttag;
    public int firsttag;

    public String toString() {
        String str = String.format("Sector: %d %x %x %d %d %d %d %d", this.id, this.floorheight, this.ceilingheight, this.floorpic, this.ceilingpic, this.lightlevel, this.special, this.tag);
        return str;
    }

    public int FindLowestFloorSurrounding() {
        int floor = this.floorheight;
        for (int i = 0; i < this.linecount; ++i) {
            line_t check = this.lines[i];
            sector_t other = check.getNextSector(this);
            if (other == null || other.floorheight >= floor) continue;
            floor = other.floorheight;
        }
        return floor;
    }

    public int FindHighestFloorSurrounding() {
        int floor = -32768000;
        for (int i = 0; i < this.linecount; ++i) {
            line_t check = this.lines[i];
            sector_t other = check.getNextSector(this);
            if (other == null || other.floorheight <= floor) continue;
            floor = other.floorheight;
        }
        return floor;
    }

    public int FindNextHighestFloor(int currentheight) {
        int i;
        int height = currentheight;
        int[] heightlist = new int[20];
        int h = 0;
        for (i = 0; i < this.linecount; ++i) {
            line_t check = this.lines[i];
            sector_t other = check.getNextSector(this);
            if (other == null) continue;
            if (other.floorheight > height) {
                heightlist[h++] = other.floorheight;
            }
            if (h < 20) continue;
            Loggers.getLogger(sector_t.class.getName()).log(Level.WARNING, "Sector with more than 20 adjoining sectors\n");
            break;
        }
        if (h == 0) {
            return currentheight;
        }
        int min = heightlist[0];
        for (i = 1; i < h; ++i) {
            if (heightlist[i] >= min) continue;
            min = heightlist[i];
        }
        return min;
    }

    public int FindLowestCeilingSurrounding() {
        int height = Integer.MAX_VALUE;
        for (int i = 0; i < this.linecount; ++i) {
            line_t check = this.lines[i];
            sector_t other = check.getNextSector(this);
            if (other == null || other.ceilingheight >= height) continue;
            height = other.ceilingheight;
        }
        return height;
    }

    public int FindHighestCeilingSurrounding() {
        int height = 0;
        for (int i = 0; i < this.linecount; ++i) {
            line_t check = this.lines[i];
            sector_t other = check.getNextSector(this);
            if (other == null || other.ceilingheight <= height) continue;
            height = other.ceilingheight;
        }
        return height;
    }

    @Override
    public void read(DataInputStream f) throws IOException {
        this.floorheight = DoomIO.readLEShort(f) << 16;
        this.ceilingheight = DoomIO.readLEShort(f) << 16;
        this.floorpic = DoomIO.readLEShort(f);
        this.ceilingpic = DoomIO.readLEShort(f);
        this.lightlevel = DoomIO.readLEShort(f);
        this.special = DoomIO.readLEShort(f);
        this.tag = DoomIO.readLEShort(f);
    }

    @Override
    public void pack(ByteBuffer b) {
        b.putShort((short)(this.floorheight >> 16));
        b.putShort((short)(this.ceilingheight >> 16));
        b.putShort(this.floorpic);
        b.putShort(this.ceilingpic);
        b.putShort(this.lightlevel);
        b.putShort(this.special);
        b.putShort(this.tag);
    }

    @Override
    public void reset() {
        this.floorheight = 0;
        this.ceilingheight = 0;
        this.floorpic = 0;
        this.ceilingpic = 0;
        this.lightlevel = 0;
        this.special = 0;
        this.tag = 0;
        this.soundtraversed = 0;
        this.soundtarget = null;
        C2JUtils.memset(this.blockbox, 0, this.blockbox.length);
        this.soundorg = null;
        this.validcount = 0;
        this.thinglist = null;
        this.specialdata = null;
        this.linecount = 0;
        this.lines = null;
        this.id = -1;
    }
}

