/*
 * Decompiled with CFR 0.152.
 */
package s;

import data.Tables;
import data.musicinfo_t;
import data.sfxinfo_t;
import data.sounds;
import doom.DoomMain;
import m.fixed_t;
import p.mobj_t;
import rr.RendererState;
import s.IDoomSound;
import s.IMusic;
import s.ISoundDriver;
import s.ISoundOrigin;

public class AbstractDoomAudio
implements IDoomSound {
    protected final DoomMain<?, ?> DS;
    protected final IMusic IMUS;
    protected final ISoundDriver ISND;
    protected final int numChannels;
    protected static final boolean D = false;
    protected final IDoomSound.channel_t[] channels;
    protected int snd_SfxVolume = 15;
    protected int snd_MusicVolume = 15;
    protected boolean mus_paused;
    protected musicinfo_t mus_playing;
    protected int nextcleanup;
    private vps_t vps = new vps_t();

    public AbstractDoomAudio(DoomMain<?, ?> DS, int numChannels) {
        this.DS = DS;
        this.numChannels = numChannels;
        this.channels = new IDoomSound.channel_t[numChannels];
        this.IMUS = DS.music;
        this.ISND = DS.soundDriver;
    }

    @Override
    public void Init(int sfxVolume, int musicVolume) {
        int i;
        System.err.printf("S_Init: default sfx volume %d\n", sfxVolume);
        this.snd_SfxVolume = sfxVolume;
        this.snd_MusicVolume = musicVolume;
        this.ISND.SetChannels(this.numChannels);
        this.SetSfxVolume(sfxVolume);
        this.IMUS.SetMusicVolume(musicVolume);
        for (i = 0; i < this.numChannels; ++i) {
            this.channels[i] = new IDoomSound.channel_t();
        }
        this.mus_paused = false;
        for (i = 1; i < sounds.S_sfx.length; ++i) {
            sounds.S_sfx[i].usefulness = -1;
            sounds.S_sfx[i].lumpnum = -1;
        }
    }

    @Override
    public void Start() {
        int mnum;
        for (int cnum = 0; cnum < this.numChannels; ++cnum) {
            if (this.channels[cnum].sfxinfo == null) continue;
            this.StopChannel(cnum);
        }
        this.mus_paused = false;
        if (this.DS.isCommercial()) {
            mnum = sounds.musicenum_t.mus_runnin.ordinal() + this.DS.gamemap - 1;
        } else {
            sounds.musicenum_t[] spmus = new sounds.musicenum_t[]{sounds.musicenum_t.mus_e3m4, sounds.musicenum_t.mus_e3m2, sounds.musicenum_t.mus_e3m3, sounds.musicenum_t.mus_e1m5, sounds.musicenum_t.mus_e2m7, sounds.musicenum_t.mus_e2m4, sounds.musicenum_t.mus_e2m6, sounds.musicenum_t.mus_e2m5, sounds.musicenum_t.mus_e1m9};
            mnum = this.DS.gameepisode < 4 ? sounds.musicenum_t.mus_e1m1.ordinal() + (this.DS.gameepisode - 1) * 9 + this.DS.gamemap - 1 : spmus[this.DS.gamemap - 1].ordinal();
        }
        this.ChangeMusic(mnum, true);
        this.nextcleanup = 15;
    }

    @Override
    public void StartSoundAtVolume(ISoundOrigin origin_p, int sfx_id, int volume) {
        int priority;
        int pitch;
        int sep = 0;
        ISoundOrigin origin = origin_p;
        if (sfx_id < 1 || sfx_id > NUMSFX) {
            Exception e = new Exception();
            e.printStackTrace();
            this.DS.doomSystem.Error("Bad sfx #: %d", sfx_id);
        }
        sfxinfo_t sfx = sounds.S_sfx[sfx_id];
        if (sfx.link != null) {
            pitch = sfx.pitch;
            priority = sfx.priority;
            if ((volume += sfx.volume) < 1) {
                return;
            }
            if (volume > this.snd_SfxVolume) {
                volume = this.snd_SfxVolume;
            }
        } else {
            pitch = 128;
            priority = 64;
        }
        if (origin != null && origin != this.DS.players[this.DS.consoleplayer].mo) {
            this.vps.volume = volume;
            this.vps.pitch = pitch;
            this.vps.sep = sep;
            boolean rc = this.AdjustSoundParams(this.DS.players[this.DS.consoleplayer].mo, origin, this.vps);
            volume = this.vps.volume;
            pitch = this.vps.pitch;
            sep = this.vps.sep;
            if (origin.getX() == this.DS.players[this.DS.consoleplayer].mo.x && origin.getY() == this.DS.players[this.DS.consoleplayer].mo.y) {
                sep = 128;
            }
            if (!rc) {
                return;
            }
        } else {
            sep = 128;
        }
        if (sfx_id >= sounds.sfxenum_t.sfx_sawup.ordinal() && sfx_id <= sounds.sfxenum_t.sfx_sawhit.ordinal()) {
            if ((pitch += 8 - (this.DS.random.M_Random() & 0xF)) < 0) {
                pitch = 0;
            } else if (pitch > 255) {
                pitch = 255;
            }
        } else if (sfx_id != sounds.sfxenum_t.sfx_itemup.ordinal() && sfx_id != sounds.sfxenum_t.sfx_tink.ordinal()) {
            if ((pitch += 16 - (this.DS.random.M_Random() & 0x1F)) < 0) {
                pitch = 0;
            } else if (pitch > 255) {
                pitch = 255;
            }
        }
        this.StopSound(origin);
        int cnum = this.getChannel(origin, sfx);
        if (cnum < 0) {
            return;
        }
        if (sfx.lumpnum < 0) {
            sfx.lumpnum = this.ISND.GetSfxLumpNum(sfx);
        }
        if (sfx.usefulness++ < 0) {
            sfx.usefulness = 1;
        }
        this.channels[cnum].handle = this.ISND.StartSound(sfx_id, volume, sep, pitch, priority);
    }

    @Override
    public void StartSound(ISoundOrigin origin, sounds.sfxenum_t sfx_id) {
        if (sfx_id != null && sfx_id.ordinal() > 0) {
            this.StartSound(origin, sfx_id.ordinal());
        }
    }

    @Override
    public void StartSound(ISoundOrigin origin, int sfx_id) {
        this.StartSoundAtVolume(origin, sfx_id, this.snd_SfxVolume);
    }

    @Override
    public void StopSound(ISoundOrigin origin) {
        for (int cnum = 0; cnum < this.numChannels; ++cnum) {
            if (this.channels[cnum].sfxinfo == null || this.channels[cnum].origin != origin) continue;
            this.StopChannel(cnum);
            break;
        }
    }

    @Override
    public void PauseSound() {
        if (this.mus_playing != null && !this.mus_paused) {
            this.IMUS.PauseSong(this.mus_playing.handle);
            this.mus_paused = true;
        }
    }

    @Override
    public void ResumeSound() {
        if (this.mus_playing != null && this.mus_paused) {
            this.IMUS.ResumeSong(this.mus_playing.handle);
            this.mus_paused = false;
        }
    }

    @Override
    public void UpdateSounds(mobj_t listener) {
        for (int cnum = 0; cnum < this.numChannels; ++cnum) {
            IDoomSound.channel_t c = this.channels[cnum];
            sfxinfo_t sfx = c.sfxinfo;
            if (c.sfxinfo == null) continue;
            if (this.ISND.SoundIsPlaying(c.handle)) {
                this.vps.volume = this.snd_SfxVolume;
                this.vps.pitch = 128;
                this.vps.sep = 128;
                sfx = c.sfxinfo;
                if (sfx.link != null) {
                    this.vps.pitch = sfx.pitch;
                    this.vps.volume += sfx.volume;
                    if (this.vps.volume < 1) {
                        this.StopChannel(cnum);
                        continue;
                    }
                    if (this.vps.volume > this.snd_SfxVolume) {
                        this.vps.volume = this.snd_SfxVolume;
                    }
                }
                if (c.origin == null || listener == c.origin) continue;
                boolean audible = this.AdjustSoundParams(listener, c.origin, this.vps);
                if (!audible) {
                    this.StopChannel(cnum);
                    continue;
                }
                this.ISND.UpdateSoundParams(c.handle, this.vps.volume, this.vps.sep, this.vps.pitch);
                continue;
            }
            this.StopChannel(cnum);
        }
    }

    @Override
    public void SetMusicVolume(int volume) {
        if (volume < 0 || volume > 127) {
            this.DS.doomSystem.Error("Attempt to set music volume at %d", volume);
        }
        this.IMUS.SetMusicVolume(volume);
        this.snd_MusicVolume = volume;
    }

    @Override
    public void SetSfxVolume(int volume) {
        if (volume < 0 || volume > 127) {
            this.DS.doomSystem.Error("Attempt to set sfx volume at %d", volume);
        }
        this.snd_SfxVolume = volume;
    }

    @Override
    public void StartMusic(int m_id) {
        this.ChangeMusic(m_id, false);
    }

    @Override
    public void StartMusic(sounds.musicenum_t m_id) {
        this.ChangeMusic(m_id.ordinal(), false);
    }

    @Override
    public void ChangeMusic(sounds.musicenum_t musicnum, boolean looping) {
        this.ChangeMusic(musicnum.ordinal(), false);
    }

    @Override
    public void ChangeMusic(int musicnum, boolean looping) {
        musicinfo_t music = null;
        if (musicnum <= sounds.musicenum_t.mus_None.ordinal() || musicnum >= sounds.musicenum_t.NUMMUSIC.ordinal()) {
            this.DS.doomSystem.Error("Bad music number %d", musicnum);
        } else {
            music = sounds.S_music[musicnum];
        }
        if (this.mus_playing == music) {
            return;
        }
        this.StopMusic();
        if (music.lumpnum == 0) {
            String namebuf = String.format("d_%s", music.name);
            music.lumpnum = this.DS.wadLoader.GetNumForName(namebuf, false);
        }
        if (music.lumpnum > 0) {
            music.data = this.DS.wadLoader.CacheLumpNumAsRawBytes(music.lumpnum, 3);
            music.handle = this.IMUS.RegisterSong(music.data);
            this.IMUS.PlaySong(music.handle, looping);
            this.SetMusicVolume(this.snd_MusicVolume);
            this.mus_playing = music;
        }
    }

    @Override
    public void StopMusic() {
        if (this.mus_playing != null) {
            if (this.mus_paused) {
                this.IMUS.ResumeSong(this.mus_playing.handle);
            }
            this.IMUS.StopSong(this.mus_playing.handle);
            this.IMUS.UnRegisterSong(this.mus_playing.handle);
            this.mus_playing.data = null;
            this.mus_playing = null;
        }
    }

    protected void StopChannel(int cnum) {
        IDoomSound.channel_t c = this.channels[cnum];
        if (c.sfxinfo != null) {
            if (this.ISND.SoundIsPlaying(c.handle)) {
                this.ISND.StopSound(c.handle);
            }
            for (int i = 0; i < this.numChannels && (cnum == i || c.sfxinfo != this.channels[i].sfxinfo); ++i) {
            }
            --c.sfxinfo.usefulness;
            c.sfxinfo = null;
        }
    }

    protected boolean AdjustSoundParams(mobj_t listener, ISoundOrigin source, vps_t vps) {
        int ady;
        int adx;
        int approx_dist = adx + ady - (((adx = Math.abs(listener.x - source.getX())) < (ady = Math.abs(listener.y - source.getY())) ? adx : ady) >> 1);
        if (this.DS.gamemap != 8 && approx_dist > 0x4B00000) {
            return false;
        }
        long angle = RendererState.PointToAngle(listener.x, listener.y, source.getX(), source.getY());
        angle = angle > listener.angle ? (angle -= listener.angle) : (angle += 0xFFFFFFFFL - listener.angle & 0xFFFFFFFFL);
        angle &= 0xFFFFFFFFL;
        vps.sep = 128 - (fixed_t.FixedMul(0x600000, Tables.finesine[(int)(angle >>= 19)]) >> 16);
        if (approx_dist < 0xA00000) {
            vps.volume = this.snd_SfxVolume;
        } else if (this.DS.gamemap == 8) {
            if (approx_dist > 0x4B00000) {
                approx_dist = 0x4B00000;
            }
            vps.volume = 15 + (this.snd_SfxVolume - 15) * (0x4B00000 - approx_dist >> 16) / 1040;
        } else {
            vps.volume = this.snd_SfxVolume * (0x4B00000 - approx_dist >> 16) / 1040;
        }
        return vps.volume > 0;
    }

    protected int getChannel(ISoundOrigin origin, sfxinfo_t sfxinfo) {
        int cnum;
        for (cnum = 0; cnum < this.numChannels && this.channels[cnum].sfxinfo != null; ++cnum) {
            if (origin == null || this.channels[cnum].origin != origin) continue;
            this.StopChannel(cnum);
            break;
        }
        if (cnum == this.numChannels) {
            for (cnum = 0; cnum < this.numChannels && this.channels[cnum].sfxinfo.priority < sfxinfo.priority; ++cnum) {
            }
            if (cnum == this.numChannels) {
                return -1;
            }
            this.StopChannel(cnum);
        }
        IDoomSound.channel_t c = this.channels[cnum];
        c.sfxinfo = sfxinfo;
        c.origin = origin;
        return cnum;
    }

    protected class vps_t {
        int volume;
        int pitch;
        int sep;
        int priority;

        protected vps_t() {
        }
    }
}

