/*
 * Decompiled with CFR 0.152.
 */
package s;

import data.sfxinfo_t;
import data.sounds;
import doom.DoomMain;
import s.DMXSound;
import s.DSP;
import s.ISoundDriver;

public abstract class AbstractSoundDriver
implements ISoundDriver {
    protected static final boolean D = false;
    protected final DoomMain<?, ?> DM;
    protected byte[] mixbuffer;
    protected final int numChannels;
    protected final int[] lengths = new int[NUMSFX];
    protected final int[] channelhandles;
    protected final int[] channelids;
    protected final int[] steptable = new int[256];
    protected final int[][] vol_lookup = new int[128][256];
    protected final int[] channelstart;
    protected short handlenums = 0;

    public AbstractSoundDriver(DoomMain<?, ?> DM, int numChannels) {
        this.DM = DM;
        this.numChannels = numChannels;
        this.channelids = new int[numChannels];
        this.channelhandles = new int[numChannels];
        this.channelstart = new int[numChannels];
    }

    protected final void generateVolumeLUT() {
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 256; ++j) {
                this.vol_lookup[i][j] = i * (j - 128) * 256 / 127;
            }
        }
    }

    protected void generateStepTable(int steptablemid) {
        for (int i = -128; i < 128; ++i) {
            this.steptable[steptablemid + i] = (int)(Math.pow(2.0, (double)i / 64.0) * 65536.0);
        }
    }

    protected byte[] getsfx(String sfxname, int[] len, int index) {
        String name = String.format("ds%s", sfxname).toUpperCase();
        int sfxlump = this.DM.wadLoader.CheckNumForName(name) == -1 ? this.DM.wadLoader.GetNumForName("dspistol") : this.DM.wadLoader.GetNumForName(name);
        DMXSound dmx = this.DM.wadLoader.CacheLumpNum(sfxlump, 0, DMXSound.class);
        if (dmx.speed == 11025) {
            dmx.data = DSP.crudeResample(dmx.data, 2);
            dmx.datasize = dmx.data.length;
        }
        byte[] sfx = dmx.data;
        int paddedsize = (dmx.datasize + 1049) / 1050 * 1050;
        byte[] paddedsfx = new byte[paddedsize];
        System.arraycopy(sfx, 0, paddedsfx, 0, dmx.datasize);
        for (int i = dmx.datasize; i < paddedsize; ++i) {
            paddedsfx[i] = 127;
        }
        this.DM.wadLoader.UnlockLumpNum(sfxlump);
        len[index] = paddedsize;
        return paddedsfx;
    }

    protected final byte[] getsfx16(String sfxname, int[] len, int index) {
        String name = String.format("ds%s", sfxname).toUpperCase();
        int sfxlump = this.DM.wadLoader.CheckNumForName(name) == -1 ? this.DM.wadLoader.GetNumForName("dspistol") : this.DM.wadLoader.GetNumForName(name);
        int size = this.DM.wadLoader.LumpLength(sfxlump);
        byte[] sfx = this.DM.wadLoader.CacheLumpNumAsRawBytes(sfxlump, 0);
        int paddedsize = (size - 8) * 2 * 2;
        byte[] paddedsfx = new byte[paddedsize];
        int sample = 0;
        for (int i = 8; i < size; ++i) {
            short sam = (short)((0xFF & sfx[i] - 128) << 8);
            paddedsfx[sample++] = (byte)(0xFF & sam >> 8);
            paddedsfx[sample++] = (byte)(0xFF & sam);
            paddedsfx[sample++] = (byte)(0xFF & sam >> 8);
            paddedsfx[sample++] = (byte)(0xFF & sam);
        }
        this.DM.wadLoader.UnlockLumpNum(sfxlump);
        len[index] = paddedsize;
        return paddedsfx;
    }

    @Override
    public int StartSound(int id, int vol, int sep, int pitch, int priority) {
        if (id < 1 || id > sounds.S_sfx.length - 1) {
            return -2;
        }
        int handle = this.addsfx(id, vol, this.steptable[pitch], sep);
        return handle;
    }

    protected abstract int addsfx(int var1, int var2, int var3, int var4);

    @Override
    public final int GetSfxLumpNum(sfxinfo_t sfx) {
        int lump;
        String namebuf = String.format("ds%s", sfx.name).toUpperCase();
        if (namebuf.equals("DSNONE")) {
            return -1;
        }
        try {
            lump = this.DM.wadLoader.GetNumForName(namebuf);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return lump;
    }

    protected final void initMixBuffer() {
        for (int i = 0; i < 4200; i += 4) {
            this.mixbuffer[i] = (byte)(((int)(32767.0 * Math.sin(4.71238898038469 * (double)i / 4200.0)) & 0xFF00) >>> 8);
            this.mixbuffer[i + 1] = (byte)((int)(32767.0 * Math.sin(4.71238898038469 * (double)i / 4200.0)) & 0xFF);
            this.mixbuffer[i + 2] = (byte)(((int)(32767.0 * Math.sin(4.71238898038469 * (double)i / 4200.0)) & 0xFF00) >>> 8);
            this.mixbuffer[i + 3] = (byte)((int)(32767.0 * Math.sin(4.71238898038469 * (double)i / 4200.0)) & 0xFF);
        }
    }

    protected final void initSound8() {
        for (int i = 1; i < NUMSFX; ++i) {
            sounds.S_sfx[i].data = sounds.S_sfx[i].link == null ? this.getsfx(sounds.S_sfx[i].name, this.lengths, i) : sounds.S_sfx[i].link.data;
        }
    }

    protected final void initSound16() {
        for (int i = 1; i < NUMSFX; ++i) {
            sounds.S_sfx[i].data = sounds.S_sfx[i].link == null ? this.getsfx16(sounds.S_sfx[i].name, this.lengths, i) : sounds.S_sfx[i].link.data;
        }
    }
}

