/*
 * Decompiled with CFR 0.152.
 */
package s;

import data.sounds;
import doom.DoomMain;
import java.util.Collection;
import java.util.HashMap;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import s.AbstractSoundDriver;
import s.DoomSound;

public class ClipSFXModule
extends AbstractSoundDriver {
    HashMap<Integer, Clip> cachedSounds = new HashMap();
    Clip[] channels;
    public final float[] linear2db;
    protected short handlenums = 0;
    StringBuilder sb = new StringBuilder();

    public ClipSFXModule(DoomMain<?, ?> DM, int numChannels) {
        super(DM, numChannels);
        this.linear2db = this.computeLinear2DB();
    }

    private float[] computeLinear2DB() {
        float[] tmp = new float[128];
        for (int i = 0; i < 128; ++i) {
            float linear = (float)(20.0 * Math.log10((float)i / 128.0f));
            if ((double)linear < -36.0) {
                linear = -36.0f;
            }
            tmp[i] = linear;
        }
        return tmp;
    }

    @Override
    public boolean InitSound() {
        System.err.println("I_InitSound: ");
        this.initSound16();
        System.err.print(" pre-cached all sound data\n");
        System.err.print("I_InitSound: sound module ready\n");
        return true;
    }

    protected byte[] getsfx(String sfxname, int index) {
        String name = String.format("ds%s", sfxname).toUpperCase();
        int sfxlump = this.DM.wadLoader.CheckNumForName(name) == -1 ? this.DM.wadLoader.GetNumForName("dspistol") : this.DM.wadLoader.GetNumForName(name);
        int size = this.DM.wadLoader.LumpLength(sfxlump);
        byte[] sfx = this.DM.wadLoader.CacheLumpNumAsRawBytes(sfxlump, 0);
        int paddedsize = (size - 8) * 2 * 2;
        byte[] paddedsfx = new byte[paddedsize];
        int sample = 0;
        for (int i = 8; i < size; ++i) {
            short sam = (short)((0xFF & sfx[i] - 128) << 8);
            paddedsfx[sample++] = (byte)(0xFF & sam >> 8);
            paddedsfx[sample++] = (byte)(0xFF & sam);
            paddedsfx[sample++] = (byte)(0xFF & sam >> 8);
            paddedsfx[sample++] = (byte)(0xFF & sam);
        }
        this.DM.wadLoader.UnlockLumpNum(sfxlump);
        return paddedsfx;
    }

    @Override
    public void UpdateSound() {
    }

    @Override
    public void SubmitSound() {
    }

    @Override
    public void ShutdownSound() {
        int i;
        boolean done = false;
        while (!done) {
            for (i = 0; !(i >= this.numChannels || this.channels[i] != null && this.channels[i].isActive()); ++i) {
            }
            if (i != this.numChannels) continue;
            done = true;
        }
        for (i = 0; i < this.numChannels; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].close();
        }
        Collection<Clip> clips = this.cachedSounds.values();
        for (Clip c : clips) {
            c.close();
        }
    }

    @Override
    public void SetChannels(int numChannels) {
        this.channels = new Clip[numChannels];
    }

    private final void getClipForChannel(int c, int sfxid) {
        Clip clip = this.cachedSounds.get(sfxid);
        boolean exists = false;
        if (clip != null) {
            exists = true;
            if (!clip.isActive()) {
                this.channels[c] = clip;
                return;
            }
        }
        DataLine.Info info2 = new DataLine.Info(Clip.class, DoomSound.DEFAULT_SAMPLES_FORMAT);
        try {
            clip = (Clip)AudioSystem.getLine(info2);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        try {
            clip.open(DoomSound.DEFAULT_SAMPLES_FORMAT, sounds.S_sfx[sfxid].data, 0, sounds.S_sfx[sfxid].data.length);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
        if (!exists) {
            this.cachedSounds.put(sfxid, clip);
        }
        this.channels[c] = clip;
    }

    @Override
    protected int addsfx(int sfxid, int volume, int pitch, int seperation) {
        int i;
        int rc = -1;
        int oldest = this.DM.gametic;
        int oldestnum = 0;
        if (sfxid == sounds.sfxenum_t.sfx_sawup.ordinal() || sfxid == sounds.sfxenum_t.sfx_sawidl.ordinal() || sfxid == sounds.sfxenum_t.sfx_sawful.ordinal() || sfxid == sounds.sfxenum_t.sfx_sawhit.ordinal() || sfxid == sounds.sfxenum_t.sfx_stnmov.ordinal() || sfxid == sounds.sfxenum_t.sfx_pistol.ordinal()) {
            for (i = 0; i < this.numChannels; ++i) {
                if (this.channels[i] == null || !this.channels[i].isRunning() || this.channelids[i] != sfxid) continue;
                this.channels[i].stop();
                break;
            }
        }
        for (i = 0; i < this.numChannels && this.channels[i] != null; ++i) {
            if (this.channelstart[i] >= oldest) continue;
            oldestnum = i;
            oldest = this.channelstart[i];
        }
        int slot = i == this.numChannels ? oldestnum : i;
        this.getClipForChannel(slot, sfxid);
        if (this.handlenums == 0) {
            this.handlenums = (short)100;
        }
        short s = this.handlenums;
        this.handlenums = (short)(s - 1);
        rc = s;
        this.channelhandles[slot] = s;
        this.channelstart[slot] = this.DM.gametic;
        this.channelids[slot] = sfxid;
        this.setVolume(slot, volume);
        this.setPanning(slot, seperation);
        this.channels[slot].setFramePosition(0);
        this.channels[slot].start();
        return rc;
    }

    public void setVolume(int chan, int volume) {
        Clip c = this.channels[chan];
        if (c.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl vc = (FloatControl)c.getControl(FloatControl.Type.MASTER_GAIN);
            float vol = this.linear2db[volume];
            vc.setValue(vol);
        } else if (c.isControlSupported(FloatControl.Type.VOLUME)) {
            FloatControl vc = (FloatControl)c.getControl(FloatControl.Type.VOLUME);
            float vol = vc.getMinimum() + (vc.getMaximum() - vc.getMinimum()) * (float)volume / 127.0f;
            vc.setValue(vol);
        }
    }

    public void setPanning(int chan, int sep) {
        Clip c = this.channels[chan];
        if (c.isControlSupported(FloatControl.Type.PAN)) {
            FloatControl bc = (FloatControl)c.getControl(FloatControl.Type.PAN);
            float pan = bc.getMinimum() + (bc.getMaximum() - bc.getMinimum()) * (float)sep / 256.0f;
            bc.setValue(pan);
        }
    }

    @Override
    public void StopSound(int handle) {
        int hnd = this.getChannelFromHandle(handle);
        if (hnd >= 0) {
            this.channels[hnd].stop();
            this.channels[hnd] = null;
        }
    }

    @Override
    public boolean SoundIsPlaying(int handle) {
        return this.getChannelFromHandle(handle) != -2;
    }

    @Override
    public void UpdateSoundParams(int handle, int vol, int sep, int pitch) {
        int i = this.getChannelFromHandle(handle);
        if (i != -2) {
            this.setVolume(i, vol);
            this.setPanning(i, sep);
        }
    }

    private int getChannelFromHandle(int handle) {
        for (int i = 0; i < this.numChannels; ++i) {
            if (this.channelhandles[i] != handle) continue;
            return i;
        }
        return -2;
    }

    public String channelStatus() {
        this.sb.setLength(0);
        for (int i = 0; i < this.numChannels; ++i) {
            if (this.channels[i] != null && this.channels[i].isActive()) {
                this.sb.append(i);
                continue;
            }
            this.sb.append('-');
        }
        return this.sb.toString();
    }
}

