/*
 * Decompiled with CFR 0.152.
 */
package s;

import data.sfxinfo_t;
import data.sounds;
import doom.CVarManager;
import doom.CommandVariable;
import doom.DoomMain;
import s.ClassicDoomSoundDriver;
import s.ClipSFXModule;
import s.DavidSFXModule;
import s.DummySFX;
import s.SpeakerDoomSoundDriver;
import s.SuperDoomSoundDriver;

public interface ISoundDriver {
    public static final int VOLUME_STEPS = 128;
    public static final int PANNING_STEPS = 256;
    public static final int IDLE_HANDLE = -1;
    public static final int BUSY_HANDLE = -2;
    public static final int NUM_CHANNELS = 8;
    public static final int BUFMUL = 4;
    public static final int SAMPLERATE = 22050;
    public static final int SOUND_INTERVAL = 500;
    public static final int SND_FRAME_RATE = 21;
    public static final int SAMPLECOUNT = 1050;
    public static final int MIXBUFFERSIZE = 4200;
    public static final int SAMPLESIZE = 16;
    public static final int NUMSFX = sounds.sfxenum_t.NUMSFX.ordinal();
    public static final int MAXHANDLES = 100;
    public static final int BUFFER_CHUNKS = 5;
    public static final int AUDIOLINE_BUFFER = 42000;
    public static final int SOUND_PERIOD = 47;

    public static ISoundDriver chooseModule(DoomMain<?, ?> DM, CVarManager CVM) {
        ISoundDriver driver = CVM.bool(CommandVariable.NOSFX) || CVM.bool(CommandVariable.NOSOUND) ? new DummySFX() : (CVM.bool(CommandVariable.AUDIOLINES) ? new DavidSFXModule(DM, DM.numChannels) : (CVM.bool(CommandVariable.SPEAKERSOUND) ? new SpeakerDoomSoundDriver(DM, DM.numChannels) : (CVM.bool(CommandVariable.CLIPSOUND) ? new ClipSFXModule(DM, DM.numChannels) : (CVM.bool(CommandVariable.CLASSICSOUND) ? new ClassicDoomSoundDriver(DM, DM.numChannels) : new SuperDoomSoundDriver(DM, DM.numChannels)))));
        if (!driver.InitSound()) {
            System.err.println("S_InitSound: failed. Reverting to dummy...\n");
            return new DummySFX();
        }
        return driver;
    }

    public boolean InitSound();

    public void UpdateSound();

    public void SubmitSound();

    public void ShutdownSound();

    public void SetChannels(int var1);

    public int GetSfxLumpNum(sfxinfo_t var1);

    public int StartSound(int var1, int var2, int var3, int var4, int var5);

    public void StopSound(int var1);

    public boolean SoundIsPlaying(int var1);

    public void UpdateSoundParams(int var1, int var2, int var3, int var4);
}

