/*
 * Decompiled with CFR 0.152.
 */
package s;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import m.Swap;

public class MusReader {
    public static Sequence getSequence(InputStream is) throws IOException, InvalidMidiDataException {
        EventGroup eg;
        DataInputStream dis = new DataInputStream(is);
        dis.skip(6L);
        int rus = dis.readUnsignedShort();
        short scoreStart = Swap.SHORT((char)rus);
        dis.skip(scoreStart - 8);
        Sequence sequence = new Sequence(30.0f, 14, 1);
        Track track = sequence.getTracks()[0];
        int[] chanVelocity = new int[16];
        Arrays.fill(chanVelocity, 100);
        long tick = 0L;
        while ((eg = MusReader.nextEventGroup(dis, chanVelocity)) != null) {
            tick = eg.appendTo(track, tick);
        }
        MetaMessage endOfSequence = new MetaMessage();
        endOfSequence.setMessage(47, new byte[]{0}, 1);
        track.add(new MidiEvent(endOfSequence, tick));
        return sequence;
    }

    private static EventGroup nextEventGroup(InputStream is, int[] channelVelocity) throws IOException {
        boolean last;
        EventGroup result = new EventGroup();
        do {
            int b;
            if ((b = is.read()) < 0) {
                return result.emptyToNull();
            }
            int descriptor = b & 0xFF;
            last = (descriptor & 0x80) != 0;
            int eventType = descriptor >> 4 & 7;
            int chanIndex = descriptor & 0xF;
            int midiChan = chanIndex < 9 ? chanIndex : (chanIndex < 15 ? chanIndex + 1 : 9);
            block0 : switch (eventType) {
                case 0: {
                    int note = is.read() & 0xFF;
                    if ((note & 0x80) != 0) {
                        throw new IllegalArgumentException("Invalid note byte");
                    }
                    result.noteOff(midiChan, note);
                    break;
                }
                case 1: {
                    int velocity;
                    boolean hasVelocity;
                    int note = is.read() & 0xFF;
                    boolean bl = hasVelocity = (note & 0x80) != 0;
                    if (hasVelocity) {
                        velocity = is.read() & 0xFF;
                        if ((velocity & 0x80) != 0) {
                            throw new IllegalArgumentException("Invalid velocity byte");
                        }
                        channelVelocity[midiChan] = velocity;
                    } else {
                        velocity = channelVelocity[midiChan];
                    }
                    result.noteOn(midiChan, note & 0x7F, velocity);
                    break;
                }
                case 2: {
                    int wheelVal = is.read() & 0xFF;
                    result.pitchBend(midiChan, wheelVal);
                    break;
                }
                case 3: {
                    int sysEvt = is.read() & 0xFF;
                    switch (sysEvt) {
                        case 10: {
                            result.allSoundsOff(midiChan);
                            break block0;
                        }
                        case 11: {
                            result.allNotesOff(midiChan);
                            break block0;
                        }
                        case 14: {
                            result.resetAllControllers(midiChan);
                            break block0;
                        }
                    }
                    String msg = String.format("Invalid system event (%d)", sysEvt);
                    throw new IllegalArgumentException(msg);
                }
                case 4: {
                    int cNum = is.read() & 0xFF;
                    if ((cNum & 0x80) != 0) {
                        throw new IllegalArgumentException("Invalid controller number ");
                    }
                    int cVal = is.read() & 0xFF;
                    if (cNum == 3 && 133 <= cVal && cVal <= 135) {
                        cVal = 127;
                    }
                    if ((cVal & 0x80) != 0) {
                        String msg = String.format("Invalid controller value (%d; cNum=%d)", cVal, cNum);
                        throw new IllegalArgumentException(msg);
                    }
                    switch (cNum) {
                        case 0: {
                            result.patchChange(midiChan, cVal);
                            break block0;
                        }
                        case 1: {
                            break block0;
                        }
                        case 2: {
                            result.vibratoChange(midiChan, cVal);
                            break block0;
                        }
                        case 3: {
                            result.volume(midiChan, cVal);
                            break block0;
                        }
                        case 4: {
                            result.pan(midiChan, cVal);
                            break block0;
                        }
                        case 5: {
                            result.expression(midiChan, cVal);
                            break block0;
                        }
                        case 6: {
                            result.reverbDepth(midiChan, cVal);
                            break block0;
                        }
                        case 7: {
                            result.chorusDepth(midiChan, cVal);
                            break block0;
                        }
                        case 8: {
                            result.sustain(midiChan, cVal);
                            break block0;
                        }
                    }
                    throw new AssertionError((Object)("Unknown controller number: " + cNum + "(value: " + cVal + ")"));
                }
                case 6: {
                    return result.emptyToNull();
                }
                default: {
                    String msg = String.format("Unknown event type: %d", eventType);
                    throw new IllegalArgumentException(msg);
                }
            }
        } while (!last);
        int qTics = MusReader.readVLV(is);
        result.addDelay(qTics);
        return result;
    }

    private static int readVLV(InputStream is) throws IOException {
        boolean last;
        int result = 0;
        do {
            int digit;
            last = ((digit = is.read() & 0xFF) & 0x80) == 0;
            result <<= 7;
            result |= digit & 0x7F;
        } while (!last);
        return result;
    }

    private static class EventGroup {
        private static final int CHM_ALL_NOTES_OFF = 123;
        private static final int CHM_ALL_SOUND_OFF = 120;
        private static final int CTRL_CHORUS_DEPTH = 93;
        private static final int CTRL_EXPRESSION_POT = 11;
        private static final int CTRL_PAN = 10;
        private static final int CTRL_SUSTAIN = 64;
        private static final int CHM_RESET_ALL = 121;
        private static final int CTRL_REVERB_DEPTH = 91;
        private static final int CTRL_MODULATION_POT = 1;
        private static final int CTRL_VOLUME = 7;
        private long delay;
        private final List<MidiMessage> messages = new ArrayList<MidiMessage>();

        EventGroup() {
        }

        void addDelay(long ticks) {
            this.delay += ticks;
        }

        void allNotesOff(int midiChan) {
            this.addControlChange(midiChan, 123, 0);
        }

        void allSoundsOff(int midiChan) {
            this.addControlChange(midiChan, 120, 0);
        }

        long appendTo(Track track, long tick) {
            for (MidiMessage msg : this.messages) {
                track.add(new MidiEvent(msg, tick));
            }
            return tick + this.delay * 3L;
        }

        void chorusDepth(int midiChan, int depth) {
            this.addControlChange(midiChan, 93, depth);
        }

        EventGroup emptyToNull() {
            if (this.messages.isEmpty()) {
                return null;
            }
            return this;
        }

        void expression(int midiChan, int expr) {
            this.addControlChange(midiChan, 11, expr);
        }

        void noteOn(int midiChan, int note, int velocity) {
            this.addShortMessage(midiChan, 144, note, velocity);
        }

        void noteOff(int midiChan, int note) {
            this.addShortMessage(midiChan, 128, note, 0);
        }

        void pan(int midiChan, int pan) {
            this.addControlChange(midiChan, 10, pan);
        }

        void patchChange(int midiChan, int patchId) {
            this.addShortMessage(midiChan, 192, patchId, 0);
        }

        void pitchBend(int midiChan, int wheelVal) {
            int pb14 = wheelVal * 64;
            this.addShortMessage(midiChan, 224, pb14 % 128, pb14 / 128);
        }

        void resetAllControllers(int midiChan) {
            this.addControlChange(midiChan, 121, 0);
        }

        void reverbDepth(int midiChan, int depth) {
            this.addControlChange(midiChan, 91, depth);
        }

        void sustain(int midiChan, int on) {
            this.addControlChange(midiChan, 64, on);
        }

        void vibratoChange(int midiChan, int depth) {
            this.addControlChange(midiChan, 1, depth);
        }

        void volume(int midiChan, int vol) {
            this.addControlChange(midiChan, 7, vol);
        }

        private void addControlChange(int midiChan, int ctrlId, int ctrlVal) {
            this.addShortMessage(midiChan, 176, ctrlId, ctrlVal);
        }

        private void addShortMessage(int midiChan, int cmd, int data1, int data2) {
            try {
                ShortMessage msg = new ShortMessage();
                msg.setMessage(cmd, midiChan, data1, data2);
                this.messages.add(msg);
            }
            catch (InvalidMidiDataException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

