/*
 * Decompiled with CFR 0.152.
 */
package s;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Hashtable;
import w.CacheableDoomObject;

public class SpeakerSound
implements CacheableDoomObject {
    public short header;
    public short length;
    public byte[] data;
    public static int[] timer_values = new int[]{0, 6818, 6628, 6449, 6279, 6087, 5906, 5736, 5575, 5423, 5279, 5120, 4971, 4830, 4697, 4554, 4435, 4307, 4186, 4058, 3950, 3836, 3728, 3615, 3519, 3418, 3323, 3224, 3131, 3043, 2960, 2875, 2794, 2711, 2633, 2560, 2485, 2415, 2348, 2281, 2213, 2153, 2089, 2032, 1975, 1918, 1864, 1810, 1757, 1709, 1659, 1612, 1565, 1521, 1478, 1435, 1395, 1355, 1316, 1280, 1242, 1207, 1173, 1140, 1107, 1075, 1045, 1015, 986, 959, 931, 905, 879, 854, 829, 806, 783, 760, 739, 718, 697, 677, 658, 640, 621, 604, 586, 570, 553, 538, 522, 507, 493, 479, 465, 452};
    public static final double INTERCEPT = 8.827321453;
    public static final double SLOPE = -0.028890647;
    public static final int CIA_8543_FREQ = 1193182;
    public static float[] f = new float[256];
    private static Hashtable<Integer, byte[]> phonemes;

    public byte[] toRawSample() {
        byte[] chunk = new byte[this.length * 11025 / 140];
        int counter = 0;
        for (int i = 0; i < this.length; ++i) {
            byte[] tmp = SpeakerSound.getPhoneme(this.data[i]);
            System.arraycopy(tmp, 0, chunk, counter, tmp.length);
            counter += tmp.length;
        }
        return chunk;
    }

    public static byte[] getPhoneme(int phoneme) {
        if (!phonemes.containsKey(phoneme)) {
            int samples = 78;
            byte[] tmp = new byte[samples];
            float frequency = f[phoneme];
            for (int i = 0; i < samples; ++i) {
                tmp[i] = (byte)(127.0 + 127.0 * Math.signum(Math.sin((double)frequency * Math.PI * 2.0 * (double)((float)i / 11025.0f))));
            }
            phonemes.put(phoneme, tmp);
        }
        return phonemes.get(phoneme);
    }

    @Override
    public void unpack(ByteBuffer buf) throws IOException {
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.header = buf.getShort();
        this.length = buf.getShort();
        this.data = new byte[this.length];
        buf.get(this.data);
    }

    static {
        SpeakerSound.f[0] = 0.0f;
        for (int x = 1; x < f.length; ++x) {
            SpeakerSound.f[x] = (float)(1193182.0 / Math.exp(8.827321453 + -0.028890647 * (double)(x - 1)));
        }
        phonemes = new Hashtable();
    }
}

