/*
 * Decompiled with CFR 0.152.
 */
package s;

import data.sounds;
import doom.DoomMain;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import pooling.AudioChunkPool;
import s.AbstractSoundDriver;
import s.AudioChunk;

public class SuperDoomSoundDriver
extends AbstractSoundDriver {
    protected final Semaphore produce;
    protected final Semaphore consume;
    protected final Semaphore update_mixer;
    protected int chunk = 0;
    protected SourceDataLine line = null;
    protected HashMap<Integer, byte[]> cachedSounds = new HashMap();
    protected final Timer MIXTIMER;
    protected volatile boolean[] channels;
    protected volatile boolean mixed = false;
    protected PlaybackServer SOUNDSRV;
    protected final MixServer MIXSRV;
    protected Thread MIXTHREAD;
    protected Thread SOUNDTHREAD;
    private int silence = 0;
    protected StringBuilder sb = new StringBuilder();
    protected final AudioChunk SILENT_CHUNK = new AudioChunk();
    protected final AudioChunkPool audiochunkpool = new AudioChunkPool();

    public SuperDoomSoundDriver(DoomMain<?, ?> DM, int numChannels) {
        super(DM, numChannels);
        this.channels = new boolean[numChannels];
        this.produce = new Semaphore(1);
        this.consume = new Semaphore(1);
        this.update_mixer = new Semaphore(1);
        this.produce.drainPermits();
        this.update_mixer.drainPermits();
        this.MIXSRV = new MixServer(numChannels);
        this.MIXTIMER = new Timer(true);
        this.MIXTIMER.schedule((TimerTask)new SoundTimer(), 0L, 47L);
    }

    @Override
    public void UpdateSound() {
    }

    @Override
    public void SetChannels(int numChannels) {
        int steptablemid = 128;
        for (int i = 0; i < this.numChannels; ++i) {
            this.channels[i] = false;
        }
        this.generateStepTable(steptablemid);
        this.generateVolumeLUT();
    }

    @Override
    public boolean InitSound() {
        System.err.print("I_InitSound: ");
        AudioFormat format = new AudioFormat(22050.0f, 16, 2, true, true);
        DataLine.Info info2 = new DataLine.Info(SourceDataLine.class, format);
        if (AudioSystem.isLineSupported(info2)) {
            try {
                this.line = AudioSystem.getSourceDataLine(format);
                this.line.open(format, 42000);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.print("Could not play signed 16 data\n");
                return false;
            }
        }
        if (this.line == null) {
            System.err.print("could not configure audio device\n");
            return false;
        }
        System.err.print("configured audio device\n");
        this.line.start();
        this.SOUNDSRV = new PlaybackServer(this.line);
        this.SOUNDTHREAD = new Thread(this.SOUNDSRV);
        this.SOUNDTHREAD.setDaemon(true);
        this.SOUNDTHREAD.start();
        this.MIXTHREAD = new Thread(this.MIXSRV);
        this.MIXTHREAD.setDaemon(true);
        this.MIXTHREAD.start();
        System.err.print("I_InitSound: ");
        super.initSound8();
        System.err.print("pre-cached all sound data\n");
        System.err.print("I_InitSound: sound module ready\n");
        return true;
    }

    @Override
    protected int addsfx(int sfxid, int volume, int step, int seperation) {
        int rightvol;
        MixMessage m;
        int i;
        int rc = -1;
        int oldest = this.DM.gametic;
        int oldestnum = 0;
        int broken = -1;
        if (sfxid == sounds.sfxenum_t.sfx_sawup.ordinal() || sfxid == sounds.sfxenum_t.sfx_sawidl.ordinal() || sfxid == sounds.sfxenum_t.sfx_sawful.ordinal() || sfxid == sounds.sfxenum_t.sfx_sawhit.ordinal() || sfxid == sounds.sfxenum_t.sfx_stnmov.ordinal() || sfxid == sounds.sfxenum_t.sfx_pistol.ordinal()) {
            for (i = 0; i < this.numChannels; ++i) {
                if (!this.channels[i] || this.channelids[i] != sfxid) continue;
                m = new MixMessage();
                m.stop = true;
                broken = i;
                break;
            }
        }
        if (broken >= 0) {
            i = broken;
            oldestnum = broken;
        } else {
            for (i = 0; i < this.numChannels && this.channels[i]; ++i) {
                if (this.channelstart[i] >= oldest) continue;
                oldestnum = i;
            }
        }
        oldest = this.channelstart[oldestnum];
        int slot = i == this.numChannels ? oldestnum : i;
        m = new MixMessage();
        this.channels[slot] = true;
        m.channel = slot;
        m.data = sounds.S_sfx[sfxid].data;
        m.pointer = 0;
        m.end = this.lengths[sfxid];
        if (this.handlenums == 0) {
            this.handlenums = (short)100;
        }
        short s = this.handlenums;
        this.handlenums = (short)(s - 1);
        rc = s;
        this.channelhandles[slot] = s;
        m.step = step;
        m.remainder = 0;
        this.channelstart[slot] = this.DM.gametic;
        int leftvol = volume - (volume * ++seperation * seperation >> 16);
        if ((rightvol = volume - (volume * (seperation -= 257) * seperation >> 16)) < 0 || rightvol > 127) {
            this.DM.doomSystem.Error("rightvol out of bounds");
        }
        if (leftvol < 0 || leftvol > 127) {
            this.DM.doomSystem.Error("leftvol out of bounds");
        }
        m.leftvol_lookup = this.vol_lookup[leftvol];
        m.rightvol_lookup = this.vol_lookup[rightvol];
        this.channelids[slot] = sfxid;
        this.MIXSRV.submitMixMessage(m);
        return rc;
    }

    @Override
    public void ShutdownSound() {
        boolean done;
        this.produce.release();
        this.update_mixer.release();
        int i = 0;
        do {
            done = true;
            for (i = 0; i < this.numChannels; ++i) {
                done &= !this.channels[i];
            }
        } while (!done);
        this.line.flush();
        this.SOUNDSRV.terminate = true;
        this.MIXSRV.terminate = true;
        this.produce.release();
        this.update_mixer.release();
        try {
            this.SOUNDTHREAD.join();
            this.MIXTHREAD.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.err.printf("3\n", new Object[0]);
        this.line.close();
        System.err.printf("4\n", new Object[0]);
    }

    @Override
    public boolean SoundIsPlaying(int handle) {
        int c = this.getChannelFromHandle(handle);
        return c != -2 && this.channels[c];
    }

    protected int getChannelFromHandle(int handle) {
        for (int i = 0; i < this.numChannels; ++i) {
            if (this.channelhandles[i] != handle) continue;
            return i;
        }
        return -2;
    }

    @Override
    public void StopSound(int handle) {
        int hnd = this.getChannelFromHandle(handle);
        if (hnd >= 0) {
            this.channels[hnd] = false;
            this.channelhandles[hnd] = -1;
            MixMessage m = new MixMessage();
            m.channel = hnd;
            m.stop = true;
            this.MIXSRV.submitMixMessage(m);
        }
    }

    @Override
    public void SubmitSound() {
    }

    @Override
    public void UpdateSoundParams(int handle, int vol, int sep, int pitch) {
        int rightvol;
        int chan = this.getChannelFromHandle(handle);
        int leftvol = vol - (vol * sep * sep >> 16);
        if ((rightvol = vol - (vol * (sep -= 257) * sep >> 16)) < 0 || rightvol > 127) {
            this.DM.doomSystem.Error("rightvol out of bounds");
        }
        if (leftvol < 0 || leftvol > 127) {
            this.DM.doomSystem.Error("leftvol out of bounds");
        }
        MixMessage m = new MixMessage();
        m.update = true;
        m.channel = chan;
        m.leftvol_lookup = this.vol_lookup[leftvol];
        m.rightvol_lookup = this.vol_lookup[rightvol];
        m.step = this.steptable[pitch];
        m.end = this.lengths[this.channelids[chan]];
        this.MIXSRV.submitMixMessage(m);
    }

    public String channelStatus() {
        this.sb.setLength(0);
        for (int i = 0; i < this.numChannels; ++i) {
            if (this.MIXSRV.channelIsPlaying(i)) {
                this.sb.append(i);
                continue;
            }
            this.sb.append('-');
        }
        return this.sb.toString();
    }

    protected class SoundTimer
    extends TimerTask {
        protected SoundTimer() {
        }

        @Override
        public void run() {
            SuperDoomSoundDriver.this.update_mixer.release();
        }
    }

    protected class MixServer
    implements Runnable {
        private final ArrayBlockingQueue<MixMessage> mixmessages;
        protected int[] p_channels;
        protected int[] channelsend;
        private final byte[][] channels;
        protected final int[] channelstep;
        protected final int[] channelstepremainder;
        protected final int[][] channelrightvol_lookup;
        protected final int[][] channelleftvol_lookup;
        private volatile boolean update = false;
        public boolean terminate = false;
        private AudioChunk gunk;

        public MixServer(int numChannels) {
            this.mixmessages = new ArrayBlockingQueue(35 * numChannels);
            this.p_channels = new int[numChannels];
            this.channels = new byte[numChannels][];
            this.channelstepremainder = new int[numChannels];
            this.channelsend = new int[numChannels];
            this.channelstep = new int[numChannels];
            this.channelleftvol_lookup = new int[numChannels][];
            this.channelrightvol_lookup = new int[numChannels][];
        }

        public void submitMixMessage(MixMessage m) {
            try {
                this.mixmessages.add(m);
            }
            catch (IllegalStateException e) {
                this.mixmessages.clear();
                this.mixmessages.add(m);
            }
        }

        @Override
        public void run() {
            int sample = 0;
            int step = 4;
            int leftend = 4200;
            while (!this.terminate) {
                int leftout = 0;
                int rightout = 2;
                try {
                    SuperDoomSoundDriver.this.update_mixer.acquire();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int messages = this.mixmessages.size();
                if (messages > 0) {
                    this.drainAndApply(messages);
                }
                SuperDoomSoundDriver.this.mixed = this.activeChannels();
                if (SuperDoomSoundDriver.this.mixed) {
                    this.gunk = (AudioChunk)SuperDoomSoundDriver.this.audiochunkpool.checkOut();
                    this.gunk.free = false;
                    SuperDoomSoundDriver.this.mixbuffer = this.gunk.buffer;
                    while (leftout < 4200) {
                        int dl = 0;
                        int dr = 0;
                        for (int chan = 0; chan < SuperDoomSoundDriver.this.numChannels; ++chan) {
                            if (this.channels[chan] == null) continue;
                            int channel_pointer = this.p_channels[chan];
                            sample = 0xFF & this.channels[chan][channel_pointer];
                            dl += this.channelleftvol_lookup[chan][sample];
                            dr += this.channelrightvol_lookup[chan][sample];
                            int n = chan;
                            this.channelstepremainder[n] = this.channelstepremainder[n] + this.channelstep[chan];
                            int n2 = chan;
                            this.channelstepremainder[n2] = this.channelstepremainder[n2] & 0xFFFF;
                            if ((channel_pointer += this.channelstepremainder[chan] >> 16) >= this.channelsend[chan]) {
                                this.channels[chan] = null;
                                SuperDoomSoundDriver.this.channels[chan] = false;
                                channel_pointer = 0;
                            }
                            this.p_channels[chan] = channel_pointer;
                        }
                        if (dl > Short.MAX_VALUE) {
                            dl = Short.MAX_VALUE;
                        } else if (dl < Short.MIN_VALUE) {
                            dl = Short.MIN_VALUE;
                        }
                        SuperDoomSoundDriver.this.mixbuffer[leftout] = (byte)((dl & 0xFF00) >>> 8);
                        SuperDoomSoundDriver.this.mixbuffer[leftout + 1] = (byte)(dl & 0xFF);
                        if (dr > Short.MAX_VALUE) {
                            dr = Short.MAX_VALUE;
                        } else if (dr < Short.MIN_VALUE) {
                            dr = Short.MIN_VALUE;
                        }
                        SuperDoomSoundDriver.this.mixbuffer[rightout] = (byte)((dr & 0xFF00) >>> 8);
                        SuperDoomSoundDriver.this.mixbuffer[rightout + 1] = (byte)(dr & 0xFF);
                        leftout += 4;
                        rightout += 4;
                    }
                }
                this.submitSound();
            }
        }

        private final void submitSound() {
            if (SuperDoomSoundDriver.this.mixed) {
                SuperDoomSoundDriver.this.silence = 0;
                SuperDoomSoundDriver.this.SOUNDSRV.addChunk(this.gunk);
                ++SuperDoomSoundDriver.this.chunk;
                if (SuperDoomSoundDriver.this.consume.tryAcquire()) {
                    SuperDoomSoundDriver.this.produce.release();
                }
            } else {
                SuperDoomSoundDriver.this.silence++;
                if (SuperDoomSoundDriver.this.silence > 5) {
                    SuperDoomSoundDriver.this.line.flush();
                    SuperDoomSoundDriver.this.silence = 0;
                }
            }
        }

        private void drainAndApply(int messages) {
            for (int i = 0; i < messages; ++i) {
                MixMessage m = (MixMessage)this.mixmessages.remove();
                if (m.stop) {
                    this.stopChannel(m.channel);
                    continue;
                }
                if (m.update) {
                    this.updateChannel(m);
                    continue;
                }
                this.insertChannel(m);
            }
        }

        private final void stopChannel(int channel) {
            this.channels[channel] = null;
            this.p_channels[channel] = 0;
        }

        private final void updateChannel(MixMessage m) {
            this.channelleftvol_lookup[m.channel] = m.leftvol_lookup;
            this.channelrightvol_lookup[m.channel] = m.rightvol_lookup;
            this.channelstep[m.channel] = m.step;
            this.channelsend[m.channel] = m.end;
        }

        private final void insertChannel(MixMessage m) {
            int ch = m.channel;
            this.channels[ch] = m.data;
            this.p_channels[ch] = m.pointer;
            this.channelsend[ch] = m.end;
            this.channelstepremainder[ch] = m.remainder;
            this.channelleftvol_lookup[ch] = m.leftvol_lookup;
            this.channelrightvol_lookup[ch] = m.rightvol_lookup;
            this.channelstep[ch] = m.step;
        }

        private final boolean activeChannels() {
            for (int chan = 0; chan < SuperDoomSoundDriver.this.numChannels; ++chan) {
                if (this.channels[chan] == null) continue;
                return true;
            }
            return false;
        }

        public final boolean channelIsPlaying(int num) {
            return this.channels[num] != null;
        }
    }

    protected class MixMessage {
        public boolean stop;
        public boolean update;
        public int remainder;
        public int end;
        public int channel;
        public byte[] data;
        public int step;
        public int stepremainder;
        public int[] leftvol_lookup;
        public int[] rightvol_lookup;
        public int pointer;

        protected MixMessage() {
        }
    }

    protected class PlaybackServer
    implements Runnable {
        public boolean terminate = false;
        private SourceDataLine auline;
        private ArrayBlockingQueue<AudioChunk> audiochunks = new ArrayBlockingQueue(10);
        public volatile int currstate = 0;

        public PlaybackServer(SourceDataLine line) {
            this.auline = line;
        }

        public void addChunk(AudioChunk chunk) {
            this.audiochunks.offer(chunk);
        }

        @Override
        public void run() {
            while (!this.terminate) {
                try {
                    SuperDoomSoundDriver.this.produce.acquire();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                int chunks = 0;
                int atMost = Math.min(5, this.audiochunks.size());
                while (atMost-- > 0) {
                    AudioChunk chunk = null;
                    try {
                        chunk = this.audiochunks.take();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.auline.write(chunk.buffer, 0, 4200);
                    ++chunks;
                    chunk.free = true;
                    SuperDoomSoundDriver.this.audiochunkpool.checkIn(chunk);
                }
                SuperDoomSoundDriver.this.consume.release();
            }
        }
    }
}

