/*
 * Decompiled with CFR 0.152.
 */
package savegame;

import defines.skill_t;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import savegame.IDoomSaveGameHeader;
import utils.C2JUtils;
import w.CacheableDoomObject;
import w.DoomBuffer;
import w.DoomIO;
import w.IReadableDoomObject;
import w.IWritableDoomObject;

public class VanillaDSGHeader
implements IDoomSaveGameHeader,
IReadableDoomObject,
IWritableDoomObject,
CacheableDoomObject {
    public String name;
    public String vcheck;
    public skill_t gameskill;
    public int gameepisode;
    public int gamemap;
    public boolean[] playeringame = new boolean[4];
    public int leveltime;
    public boolean wrongversion;
    public boolean properend;

    @Override
    public void unpack(ByteBuffer buf) throws IOException {
        this.name = DoomBuffer.getNullTerminatedString(buf, 24);
        this.vcheck = DoomBuffer.getNullTerminatedString(buf, 16);
        String vcheckb = "version 109";
        this.wrongversion = !vcheckb.equalsIgnoreCase(this.vcheck);
        if (this.wrongversion) {
            return;
        }
        this.gameskill = skill_t.values()[buf.get()];
        this.gameepisode = buf.get();
        this.gamemap = buf.get();
        for (int i = 0; i < 4; ++i) {
            this.playeringame[i] = buf.get() != 0;
        }
        int a = C2JUtils.toUnsignedByte(buf.get());
        int b = C2JUtils.toUnsignedByte(buf.get());
        int c = C2JUtils.toUnsignedByte(buf.get());
        this.leveltime = a << 16 | b << 8 | c;
        buf.mark();
        buf.position(buf.limit() - 1);
        this.properend = buf.get() == 29;
        buf.reset();
    }

    @Override
    public void write(DataOutputStream f) throws IOException {
        DoomIO.writeString(f, this.name, 24);
        DoomIO.writeString(f, this.vcheck, 16);
        f.writeByte(this.gameskill.ordinal());
        f.writeByte(this.gameepisode);
        f.writeByte(this.gamemap);
        for (int i = 0; i < 4; ++i) {
            f.writeBoolean(this.playeringame[i]);
        }
        byte a = (byte)(0xFF & this.leveltime >> 16);
        byte b = (byte)(0xFF & this.leveltime >> 8);
        byte c = (byte)(0xFF & this.leveltime);
        f.writeByte(a);
        f.writeByte(b);
        f.writeByte(c);
    }

    @Override
    public void read(DataInputStream f) throws IOException {
        this.name = DoomIO.readNullTerminatedString(f, 24);
        this.vcheck = DoomIO.readNullTerminatedString(f, 16);
        this.gameskill = skill_t.values()[f.readUnsignedByte()];
        this.gameepisode = f.readByte();
        this.gamemap = f.readByte();
        for (int i = 0; i < 4; ++i) {
            this.playeringame[i] = f.readBoolean();
        }
        int a = f.readUnsignedByte();
        int b = f.readUnsignedByte();
        int c = f.readUnsignedByte();
        this.leveltime = a << 16 | b << 8 | c;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getVersion() {
        return this.vcheck;
    }

    @Override
    public void setVersion(String vcheck) {
        this.vcheck = vcheck;
    }

    @Override
    public skill_t getGameskill() {
        return this.gameskill;
    }

    @Override
    public void setGameskill(skill_t gameskill) {
        this.gameskill = gameskill;
    }

    @Override
    public int getGameepisode() {
        return this.gameepisode;
    }

    @Override
    public void setGameepisode(int gameepisode) {
        this.gameepisode = gameepisode;
    }

    @Override
    public int getGamemap() {
        return this.gamemap;
    }

    @Override
    public void setGamemap(int gamemap) {
        this.gamemap = gamemap;
    }

    @Override
    public boolean[] getPlayeringame() {
        return this.playeringame;
    }

    @Override
    public void setPlayeringame(boolean[] playeringame) {
        this.playeringame = playeringame;
    }

    @Override
    public int getLeveltime() {
        return this.leveltime;
    }

    @Override
    public void setLeveltime(int leveltime) {
        this.leveltime = leveltime;
    }

    @Override
    public boolean isWrongversion() {
        return this.wrongversion;
    }

    @Override
    public void setWrongversion(boolean wrongversion) {
        this.wrongversion = wrongversion;
    }

    @Override
    public boolean isProperend() {
        return this.properend;
    }
}

