/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import p.Resettable;

public final class C2JUtils {
    public static char[] strcpy(char[] s1, char[] s2) {
        System.arraycopy(s2, 0, s1, 0, Math.min(s1.length, s2.length));
        return s1;
    }

    public static char[] strcpy(char[] s1, char[] s2, int off, int len) {
        for (int i = 0; i < len; ++i) {
            s1[i] = s2[i + off];
        }
        return s1;
    }

    public static char[] strcpy(char[] s1, char[] s2, int off) {
        for (int i = 0; i < Math.min(s1.length, s2.length - off); ++i) {
            s1[i] = s2[i + off];
        }
        return s1;
    }

    public static char[] strcpy(char[] s1, String s2) {
        for (int i = 0; i < Math.min(s1.length, s2.length()); ++i) {
            s1[i] = s2.charAt(i);
        }
        return s1;
    }

    public static byte[] toByteArray(String str) {
        byte[] retour = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            retour[i] = (byte)(str.charAt(i) & 0xFF);
        }
        return retour;
    }

    public static int indexOf(Object[] array, Object key) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != key) continue;
            return i;
        }
        return -1;
    }

    public static boolean strcmp(char[] s1, char[] s2) {
        boolean match = true;
        for (int i = 0; i < Math.min(s1.length, s2.length); ++i) {
            if (s1[i] == s2[i]) continue;
            match = false;
            break;
        }
        return match;
    }

    public static boolean strcmp(char[] s1, String s2) {
        return C2JUtils.strcmp(s1, s2.toCharArray());
    }

    public static int strlen(char[] s1) {
        if (s1 == null) {
            return 0;
        }
        int len = 0;
        while (s1[len++] > '\u0000' && len < s1.length) {
        }
        return len - 1;
    }

    public static String nullTerminatedString(char[] s) {
        if (s == null) {
            return "";
        }
        int len = 0;
        while (s[len++] > '\u0000' && len < s.length) {
        }
        return new String(s, 0, len - 1);
    }

    public static <T> void initArrayOfObjects(T[] os, Class<T> c) {
        try {
            for (int i = 0; i < os.length; ++i) {
                os[i] = c.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            System.err.println("Failure to allocate " + os.length + " objects of class" + c.getName() + "!");
            System.exit(-1);
        }
    }

    @Deprecated
    public static <T> void initArrayOfObjects(T[] os) {
        Class<?> c = os.getClass().getComponentType();
        try {
            for (int i = 0; i < os.length; ++i) {
                os[i] = c.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            System.err.println("Failure to allocate " + os.length + " objects of class " + c.getName() + "!");
            System.exit(-1);
        }
    }

    @Deprecated
    public static <T> T[] createArrayOfObjects(Class<T> c, int num) {
        T[] os = C2JUtils.getNewArray(c, num);
        try {
            for (int i = 0; i < os.length; ++i) {
                os[i] = c.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            System.err.println("Failure to instantiate " + os.length + " objects of class " + c.getName() + "!");
            System.exit(-1);
        }
        return os;
    }

    public static <T> T[] createArrayOfObjects(T instance, int num) {
        Class<?> c = instance.getClass();
        ?[] os = C2JUtils.getNewArray(c, num);
        try {
            for (int i = 0; i < os.length; ++i) {
                os[i] = c.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            System.err.println("Failure to instantiate " + os.length + " objects of class " + c.getName() + "!");
            System.exit(-1);
        }
        return os;
    }

    public static <T> void initArrayOfObjects(T[] os, int startpos, int endpos) {
        Class<?> c = os.getClass().getComponentType();
        try {
            for (int i = startpos; i < endpos; ++i) {
                os[i] = c.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            System.err.println("Failure to allocate " + os.length + " objects of class " + c.getName() + "!");
            System.exit(-1);
        }
    }

    public static int toUnsignedByte(byte b) {
        return 0xFF & b;
    }

    public static void memset(boolean[] array, boolean value, int len) {
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void memset(byte[] array, byte value, int len) {
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void memset(char[] array, char value, int len) {
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void memset(int[] array, int value, int len) {
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void memset(short[] array, short value, int len) {
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static long unsigned(int num) {
        return 0xFFFFFFFFL & (long)num;
    }

    public static char unsigned(short num) {
        return (char)num;
    }

    public static void memcpy(Object dest, Object src, int length) {
        System.arraycopy(src, 0, dest, 0, length);
    }

    public static boolean testReadAccess(String URI2) {
        InputStream in;
        if (URI2 == null) {
            return false;
        }
        if (URI2.length() == 0) {
            return false;
        }
        try {
            in = new FileInputStream(URI2);
        }
        catch (FileNotFoundException e) {
            URL u;
            try {
                u = new URL(URI2);
            }
            catch (MalformedURLException e1) {
                return false;
            }
            try {
                in = u.openConnection().getInputStream();
            }
            catch (IOException e1) {
                return false;
            }
        }
        if (in != null) {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return true;
    }

    public static boolean testWriteAccess(String URI2) {
        OutputStream out;
        if (URI2 == null) {
            return false;
        }
        if (URI2.length() == 0) {
            return false;
        }
        try {
            out = new FileOutputStream(URI2);
        }
        catch (FileNotFoundException e) {
            URL u;
            try {
                u = new URL(URI2);
            }
            catch (MalformedURLException e1) {
                return false;
            }
            try {
                out = u.openConnection().getOutputStream();
            }
            catch (IOException e1) {
                return false;
            }
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return true;
    }

    public static boolean flags(int flags, int arg) {
        return (flags & arg) != 0;
    }

    public static boolean flags(long flags, long arg) {
        return (flags & arg) != 0L;
    }

    public static int eval(boolean expr) {
        return expr ? 1 : 0;
    }

    public static boolean eval(Object expr) {
        return expr != null;
    }

    public static boolean eval(int expr) {
        return expr != 0;
    }

    public static boolean eval(long expr) {
        return expr != 0L;
    }

    public static void resetAll(Resettable[] r) {
        for (Resettable r1 : r) {
            r1.reset();
        }
    }

    public static String unquote(String s, char c) {
        int firstq = s.indexOf(c);
        int lastq = s.lastIndexOf(c);
        if (C2JUtils.isQuoted(s, c)) {
            return s.substring(firstq + 1, lastq);
        }
        return null;
    }

    public static boolean isQuoted(String s, char c) {
        int q1 = s.indexOf(c);
        int q2 = s.lastIndexOf(c);
        if (q1 != -1 && q2 != -1 && q1 < q2) {
            char c2;
            char c1 = s.charAt(q1);
            return c1 == (c2 = s.charAt(q2));
        }
        return false;
    }

    public static String unquoteIfQuoted(String s, char c) {
        String tmp = C2JUtils.unquote(s, c);
        if (tmp != null) {
            return tmp;
        }
        return s;
    }

    public static int pointer(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static boolean checkForExtension(String filename, String ext) {
        int pos;
        String separator;
        int lastSeparatorIndex;
        if ((filename == null || filename.isEmpty()) && (ext == null || ext.isEmpty())) {
            return true;
        }
        if (filename == null) {
            filename = "";
        }
        if ((lastSeparatorIndex = filename.lastIndexOf(separator = System.getProperty("file.separator"))) != -1) {
            filename = filename.substring(lastSeparatorIndex + 1);
        }
        if ((pos = filename.lastIndexOf(46)) >= 0 && pos <= filename.length() - 2) {
            if (ext == null || ext.isEmpty()) {
                return false;
            }
            String realext = filename.substring(pos + 1);
            return realext.compareToIgnoreCase(ext) == 0;
        }
        return ext == null || ext.isEmpty();
    }

    public static String removeExtension(String s) {
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = s.lastIndexOf(separator);
        String filename = lastSeparatorIndex == -1 ? s : s.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(46);
        if (extensionIndex == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    public static String extractFileBase(String path, int limit, boolean whole) {
        if (path == null) {
            return path;
        }
        int src = path.length() - 1;
        String separator = System.getProperty("file.separator");
        src = path.lastIndexOf(separator) + 1;
        if (src < 0) {
            src = 0;
        }
        int len = path.lastIndexOf(46);
        len = whole || len < 0 ? path.length() - src : (len -= src);
        if (limit > 0) {
            len = Math.min(limit, len);
        }
        return path.substring(src, src + len);
    }

    public static long filelength(File handle) {
        try {
            return handle.length();
        }
        catch (Exception e) {
            System.err.println("Error fstating");
            return -1L;
        }
    }

    public static <T> T[] resize(T[] oldarray, int newsize) {
        if (oldarray[0] != null) {
            return C2JUtils.resize(oldarray[0], oldarray, newsize);
        }
        try {
            Object cls = oldarray.getClass().getComponentType().newInstance();
            return C2JUtils.resize(cls, oldarray, newsize);
        }
        catch (IllegalAccessException | InstantiationException e) {
            System.err.println("Cannot autodetect type in resizeArray.\n");
            return null;
        }
    }

    public static <T> T[] resize(T instance, T[] oldarray, int newsize) {
        if (newsize <= oldarray.length) {
            return oldarray;
        }
        T[] tmp = Arrays.copyOf(oldarray, newsize);
        C2JUtils.initArrayOfObjects(tmp, oldarray.length, tmp.length);
        System.out.printf("Old array of type %s resized. New capacity: %d\n", instance.getClass(), newsize);
        return tmp;
    }

    public static <T> T[] resizeNoAutoInit(T[] oldarray, int newsize) {
        T[] tmp = Arrays.copyOf(oldarray, newsize);
        System.out.printf("Old array of type %s resized without auto-init. New capacity: %d\n", tmp.getClass().getComponentType(), newsize);
        return tmp;
    }

    public static <T> T[] getNewArray(T instance, int size) {
        Class<?> c = instance.getClass();
        try {
            return (Object[])Array.newInstance(c, size);
        }
        catch (NegativeArraySizeException e) {
            e.printStackTrace();
            System.err.println("Failure to allocate " + size + " objects of class " + c.getName() + "!");
            System.exit(-1);
            return null;
        }
    }

    public static final <T> T[] getNewArray(int size, T instance) {
        Class<?> c = instance.getClass();
        return C2JUtils.getNewArray(c, size);
    }

    public static final <T> T[] getNewArray(Class<T> c, int size) {
        try {
            return (Object[])Array.newInstance(c, size);
        }
        catch (NegativeArraySizeException e) {
            e.printStackTrace();
            System.err.println("Failure to allocate " + size + " objects of class " + c.getName() + "!");
            System.exit(-1);
            return null;
        }
    }

    public static int guessResourceType(String URI2) {
        InputStream in;
        int result = 0;
        if (URI2 == null || URI2.length() == 0) {
            return -1;
        }
        try {
            in = new FileInputStream(new File(URI2));
            result |= 1;
        }
        catch (FileNotFoundException e) {
            URL u;
            try {
                u = new URL(URI2);
            }
            catch (MalformedURLException e1) {
                return -1;
            }
            try {
                in = u.openConnection().getInputStream();
                result |= 2;
            }
            catch (IOException e1) {
                return -1;
            }
        }
        if (C2JUtils.checkForExtension(URI2, "zip")) {
            result |= 4;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private C2JUtils() {
    }
}

