/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OrderedExecutor<K> {
    private final Executor executor;
    private final Map<K, Task> tasks;

    public OrderedExecutor(Executor executor) {
        this.executor = executor;
        this.tasks = new HashMap<K, Task>();
    }

    public synchronized void submit(K key, Runnable runnable) {
        Task task = this.tasks.get(key);
        if (task == null) {
            task = new Task();
            this.tasks.put(key, task);
        }
        task.add(runnable);
    }

    private class Task
    implements Runnable {
        private final Lock lock = new ReentrantLock();
        private final Queue<Runnable> queue = new LinkedList<Runnable>();

        Task() {
        }

        public void add(Runnable runnable) {
            boolean runTask;
            this.lock.lock();
            try {
                runTask = this.queue.isEmpty();
                this.queue.offer(runnable);
            }
            finally {
                this.lock.unlock();
            }
            if (runTask) {
                OrderedExecutor.this.executor.execute(this);
            }
        }

        @Override
        public void run() {
            Runnable runnable;
            this.lock.lock();
            try {
                runnable = this.queue.peek();
            }
            finally {
                this.lock.unlock();
            }
            try {
                runnable.run();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.lock.lock();
            try {
                this.queue.poll();
                if (!this.queue.isEmpty()) {
                    OrderedExecutor.this.executor.execute(this);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

