/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Optional;
import utils.QuoteType;

public enum ParseString {


    public static Object parseString(String stringSource) {
        Character test;
        Optional<QuoteType> qt = QuoteType.getQuoteType(stringSource);
        boolean quoted = qt.isPresent();
        if (quoted) {
            stringSource = qt.get().unQuote(stringSource);
        }
        if (quoted && stringSource.length() == 1 && (test = Character.valueOf(stringSource.charAt(0))).charValue() >= '\u0000' && test.charValue() < '\u00ff') {
            return test;
        }
        Optional<Object> ret = ParseString.checkInt(stringSource);
        if (!(ret.isPresent() || (ret = ParseString.checkDouble(stringSource)).isPresent() || (ret = ParseString.checkBoolean(stringSource)).isPresent())) {
            return stringSource;
        }
        return ret.get();
    }

    public static Optional<Object> checkInt(String stringSource) {
        try {
            long longRet = Long.parseLong(stringSource);
            return longRet < Integer.MAX_VALUE ? Optional.of((int)longRet) : Optional.of(longRet);
        }
        catch (NumberFormatException longRet) {
            try {
                long longRet2 = Long.decode(stringSource);
                return longRet2 < Integer.MAX_VALUE ? Optional.of((int)longRet2) : Optional.of(longRet2);
            }
            catch (NumberFormatException numberFormatException) {
                return Optional.empty();
            }
        }
    }

    public static Optional<Double> checkDouble(String stringSource) {
        try {
            return Optional.of(Double.parseDouble(stringSource));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    public static Optional<Boolean> checkBoolean(String stringSource) {
        try {
            return Optional.of(Boolean.parseBoolean(stringSource));
        }
        catch (NumberFormatException numberFormatException) {
            if ("false".compareToIgnoreCase(stringSource) == 0) {
                return Optional.of(Boolean.FALSE);
            }
            return Optional.empty();
        }
    }
}

