/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public enum Throwers {


    @SafeVarargs
    public static <T> Callable<T> callable(ThrowingCallable<T> r, Class<? extends Throwable> ... cl) throws Throwed {
        return () -> {
            try {
                return r.call();
            }
            catch (Throwable e) {
                if (Throwers.classifyMatching(e, cl)) {
                    throw Throwers.doThrow(e);
                }
                throw Throwers.doThrowE(e);
            }
        };
    }

    @SafeVarargs
    public static Runnable runnable(ThrowingRunnable r, Class<? extends Throwable> ... cl) throws Throwed {
        return () -> {
            try {
                r.run();
            }
            catch (Throwable e) {
                if (Throwers.classifyMatching(e, cl)) {
                    throw Throwers.doThrow(e);
                }
                throw Throwers.doThrowE(e);
            }
        };
    }

    @SafeVarargs
    public static <T> Consumer<T> consumer(ThrowingConsumer<T> c, Class<? extends Throwable> ... cl) throws Throwed {
        return t -> {
            try {
                c.accept(t);
            }
            catch (Throwable e) {
                if (Throwers.classifyMatching(e, cl)) {
                    throw Throwers.doThrow(e);
                }
                throw Throwers.doThrowE(e);
            }
        };
    }

    @SafeVarargs
    public static <T1, T2> BiConsumer<T1, T2> biConsumer(ThrowingBiConsumer<T1, T2> c, Class<? extends Throwable> ... cl) throws Throwed {
        return (t1, t2) -> {
            try {
                c.accept(t1, t2);
            }
            catch (Throwable e) {
                if (Throwers.classifyMatching(e, cl)) {
                    throw Throwers.doThrow(e);
                }
                throw Throwers.doThrowE(e);
            }
        };
    }

    @SafeVarargs
    public static <T> Predicate<T> predicate(ThrowingPredicate<T> p, Class<? extends Throwable> ... cl) throws Throwed {
        return t -> {
            try {
                return p.test(t);
            }
            catch (Throwable e) {
                if (Throwers.classifyMatching(e, cl)) {
                    throw Throwers.doThrow(e);
                }
                throw Throwers.doThrowE(e);
            }
        };
    }

    @SafeVarargs
    public static <T1, T2> BiPredicate<T1, T2> biPredicate(ThrowingBiPredicate<T1, T2> p, Class<? extends Throwable> ... cl) throws Throwed {
        return (t1, t2) -> {
            try {
                return p.test(t1, t2);
            }
            catch (Throwable e) {
                if (Throwers.classifyMatching(e, cl)) {
                    throw Throwers.doThrow(e);
                }
                throw Throwers.doThrowE(e);
            }
        };
    }

    @SafeVarargs
    public static <T, R> Function<T, R> function(ThrowingFunction<T, R> f, Class<? extends Throwable> ... cl) throws Throwed {
        return t -> {
            try {
                return f.apply(t);
            }
            catch (Throwable e) {
                if (Throwers.classifyMatching(e, cl)) {
                    throw Throwers.doThrow(e);
                }
                throw Throwers.doThrowE(e);
            }
        };
    }

    @SafeVarargs
    public static <T1, T2, R> BiFunction<T1, T2, R> biFunction(ThrowingBiFunction<T1, T2, R> f, Class<? extends Throwable> ... cl) throws Throwed {
        return (t1, t2) -> {
            try {
                return f.apply(t1, t2);
            }
            catch (Throwable e) {
                if (Throwers.classifyMatching(e, cl)) {
                    throw Throwers.doThrow(e);
                }
                throw Throwers.doThrowE(e);
            }
        };
    }

    @SafeVarargs
    public static <T> Supplier<T> supplier(ThrowingSupplier<T> s, Class<? extends Throwable> ... cl) throws Throwed {
        return () -> {
            try {
                return s.get();
            }
            catch (Throwable e) {
                if (Throwers.classifyMatching(e, cl)) {
                    throw Throwers.doThrow(e);
                }
                throw Throwers.doThrowE(e);
            }
        };
    }

    public static RuntimeException doThrow(Throwable e) throws Throwed {
        throw new Throwed(e);
    }

    private static <E extends Throwable> RuntimeException doThrowE(Throwable e) throws E {
        throw e;
    }

    @SafeVarargs
    private static boolean classifyMatching(Throwable ex, Class<? extends Throwable> ... options) {
        for (Class<? extends Throwable> o : options) {
            if (!o.isInstance(ex)) continue;
            return true;
        }
        return false;
    }

    public static interface ThrowingSupplier<T> {
        public T get() throws Throwable;
    }

    public static interface ThrowingBiFunction<T1, T2, R> {
        public R apply(T1 var1, T2 var2) throws Throwable;
    }

    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }

    public static interface ThrowingBiPredicate<T1, T2> {
        public boolean test(T1 var1, T2 var2) throws Throwable;
    }

    public static interface ThrowingPredicate<T> {
        public boolean test(T var1) throws Throwable;
    }

    public static interface ThrowingBiConsumer<T1, T2> {
        public void accept(T1 var1, T2 var2) throws Throwable;
    }

    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Throwable;
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }

    public static interface ThrowingCallable<T> {
        public T call() throws Throwable;
    }

    public static class Throwed
    extends RuntimeException {
        private static final long serialVersionUID = 5802686109960804684L;
        public final Throwable t;

        private Throwed(Throwable t) {
            super(null, null, true, false);
            this.t = t;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this.t.fillInStackTrace();
        }

        @Override
        public synchronized Throwable getCause() {
            return this.t.getCause();
        }

        @Override
        public String getLocalizedMessage() {
            return this.t.getLocalizedMessage();
        }

        @Override
        public String getMessage() {
            return this.t.getMessage();
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.t.getStackTrace();
        }

        @Override
        public void setStackTrace(StackTraceElement[] stackTrace) {
            this.t.setStackTrace(stackTrace);
        }

        @Override
        public synchronized Throwable initCause(Throwable cause) {
            return this.t.initCause(cause);
        }

        @Override
        public void printStackTrace() {
            this.t.printStackTrace();
        }

        @Override
        public void printStackTrace(PrintStream s) {
            this.t.printStackTrace(s);
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            this.t.printStackTrace(s);
        }

        @Override
        public String toString() {
            return this.t.toString();
        }
    }
}

