/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import mochadoom.Loggers;

public class TraitFactory {
    private static final Logger LOGGER = Loggers.getLogger(TraitFactory.class.getName());

    public static <T extends Trait> SharedContext build(T traitUser, KeyChain usedChain) throws IllegalArgumentException, IllegalAccessException {
        return TraitFactory.build(traitUser, usedChain.currentCapacity);
    }

    public static <T extends Trait> SharedContext build(T traitUser, int idCapacity) throws IllegalArgumentException, IllegalAccessException {
        FactoryContext c = new FactoryContext(idCapacity);
        TraitFactory.repeatRecursive(traitUser.getClass().getInterfaces(), c);
        return c;
    }

    private static void repeatRecursive(Class<?>[] traitUserInteraces, FactoryContext c) throws IllegalAccessException, SecurityException, IllegalArgumentException {
        for (Class<?> cls : traitUserInteraces) {
            Field[] declaredFields;
            for (Field f : declaredFields = cls.getDeclaredFields()) {
                Class<?> fieldClass;
                int modifiers = f.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || (fieldClass = f.getType()) != ContextKey.class) continue;
                ContextKey key = (ContextKey)ContextKey.class.cast(f.get(null));
                c.put(key, key.contextConstructor);
                LOGGER.fine(() -> String.format("%s for %s", c.get(key).getClass(), f.getDeclaringClass()));
            }
            TraitFactory.repeatRecursive(cls.getInterfaces(), c);
        }
    }

    private static Type[] getParameterizedTypes(Object object) {
        Type superclassType = object.getClass().getGenericSuperclass();
        if (!ParameterizedType.class.isAssignableFrom(superclassType.getClass())) {
            return null;
        }
        return ((ParameterizedType)superclassType).getActualTypeArguments();
    }

    private TraitFactory() {
    }

    private static class SharedContextException
    extends RuntimeException {
        private static final long serialVersionUID = 5356800492346200764L;

        SharedContextException(ContextKey<?> key, Class<? extends Trait> topLevel) {
            super(String.format("Trait context %s is not initialized when used by %s oris dereferencing a null pointer when required to do not", key, topLevel));
        }
    }

    public static interface InsertConveyor {
        public void put(ContextKey<?> var1, Supplier<?> var2);

        default public void putObj(ContextKey<?> key, Object context) {
            this.put(key, () -> context);
        }
    }

    static final class FactoryContext
    implements InsertConveyor,
    SharedContext {
        private HashMap<ContextKey<?>, Object> traitMap;
        private ContextKey<?>[] keys;
        private Object[] contexts;
        private boolean hasMap = false;

        private FactoryContext(int idCapacity) {
            this.keys = new ContextKey[idCapacity];
            this.contexts = new Object[idCapacity];
        }

        @Override
        public void put(ContextKey<?> key, Supplier<?> context) {
            if (!this.hasMap) {
                if (key.preferredId >= 0 && key.preferredId < this.keys.length) {
                    if (this.keys[key.preferredId] == key) {
                        LOGGER.finer(() -> "Already found, skipping: " + key);
                        return;
                    }
                    if (this.keys[key.preferredId] == null) {
                        this.keys[key.preferredId] = key;
                        this.contexts[key.preferredId] = context.get();
                        return;
                    }
                }
                this.hasMap = true;
                for (int i = 0; i < this.keys.length; ++i) {
                    this.traitMap.put(this.keys[i], this.contexts[i]);
                }
                this.keys = null;
                this.contexts = null;
            }
            this.traitMap.put(key, context.get());
        }

        @Override
        public <T> T get(ContextKey<T> key) {
            if (this.hasMap) {
                return (T)this.traitMap.get(key);
            }
            if (key.preferredId >= 0 && key.preferredId < this.keys.length) {
                return (T)this.contexts[key.preferredId];
            }
            return null;
        }
    }

    public static interface SharedContext {
        public <T> T get(ContextKey<T> var1);
    }

    public static final class KeyChain {
        int currentCapacity;

        public <T> ContextKey<T> newKey(Class<? extends Trait> traitClass, Supplier<T> contextConstructor) {
            return new ContextKey<T>(traitClass, this.currentCapacity++, contextConstructor);
        }
    }

    public static final class ContextKey<T> {
        final Class<? extends Trait> traitClass;
        final int preferredId;
        final Supplier<T> contextConstructor;

        public ContextKey(Class<? extends Trait> traitClass, int preferredId, Supplier<T> contextConstructor) {
            this.traitClass = traitClass;
            this.preferredId = preferredId;
            this.contextConstructor = contextConstructor;
        }

        public String toString() {
            return String.format("context in the Trait %s (preferred id: %d)", this.traitClass, this.preferredId);
        }
    }

    public static interface Trait {
        public SharedContext getContext();

        default public <T> T contextGet(ContextKey<T> key, T defaultValue) {
            T got = this.getContext().get(key);
            return got == null ? defaultValue : got;
        }

        default public <T> T contextRequire(ContextKey<T> key) {
            T got = this.getContext().get(key);
            if (got == null) {
                throw this.defaultException(key).get();
            }
            return got;
        }

        default public <T, E extends Throwable> T contextRequire(ContextKey<T> key, Supplier<E> exceptionSupplier) throws E {
            T got = this.getContext().get(key);
            if (got == null) {
                throw (Throwable)exceptionSupplier.get();
            }
            return got;
        }

        default public <T> boolean contextTest(ContextKey<T> key, Predicate<T> predicate) {
            T got = this.getContext().get(key);
            return got == null ? false : predicate.test(got);
        }

        default public <T> void contextWith(ContextKey<T> key, Consumer<T> consumer) {
            T got = this.getContext().get(key);
            if (got != null) {
                consumer.accept(got);
            }
        }

        default public <T, R> R contextMap(ContextKey<T> key, Function<T, R> mapper, R defaultValue) {
            T got = this.getContext().get(key);
            if (got != null) {
                return mapper.apply(got);
            }
            return defaultValue;
        }

        default public Supplier<? extends RuntimeException> defaultException(ContextKey<?> key) {
            return () -> new SharedContextException(key, this.getClass());
        }
    }
}

