/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import java.awt.Rectangle;
import java.lang.reflect.Array;
import v.graphics.Horizontal;
import v.graphics.Palettes;
import v.graphics.Points;
import v.graphics.Relocation;
import v.scale.VideoScale;

public interface Blocks<V, E extends Enum<E>>
extends Points<V, E>,
Palettes {
    public V convertPalettedBlock(byte ... var1);

    default public void TileScreen(E dstScreen, V block, Rectangle blockArea) {
        int screenHeight = this.getScreenHeight();
        int screenWidth = this.getScreenWidth();
        for (int y = 0; y < screenHeight; y += blockArea.height) {
            for (int x = 0; x < screenWidth; x += blockArea.width) {
                int destination = this.point(x, y, screenWidth);
                this.DrawBlock(dstScreen, block, blockArea, destination);
            }
        }
    }

    default public void TileScreenArea(E dstScreen, Rectangle screenArea, V block, Rectangle blockArea) {
        int screenWidth = this.getScreenWidth();
        int fiilLimitX = screenArea.x + screenArea.width;
        int fiilLimitY = screenArea.y + screenArea.height;
        for (int y = screenArea.y; y < fiilLimitY; y += blockArea.height) {
            for (int x = screenArea.x; x < fiilLimitX; x += blockArea.width) {
                int destination = this.point(x, y, screenWidth);
                this.DrawBlock(dstScreen, block, blockArea, destination);
            }
        }
    }

    default public void DrawBlock(E dstScreen, V block, Rectangle sourceArea, int destinationPoint) {
        Object screen = this.getScreen(dstScreen);
        int bufferLength = Array.getLength(screen);
        int screenWidth = this.getScreenWidth();
        Relocation rel = new Relocation(this.point(sourceArea.x, sourceArea.y), destinationPoint, sourceArea.width);
        int h = sourceArea.height;
        while (h > 0) {
            if (rel.destination + rel.length >= bufferLength) {
                return;
            }
            this.screenCopy(block, screen, rel);
            --h;
            rel.source += sourceArea.width;
            rel.destination += screenWidth;
        }
    }

    default public V ScaleBlock(V block, VideoScale vs, int width, int height) {
        return this.ScaleBlock(block, width, height, vs.getScalingX(), vs.getScalingY());
    }

    default public V ScaleBlock(V block, int width, int height, int dupX, int dupY) {
        int newWidth = width * dupX;
        int newHeight = height * dupY;
        Object newBlock = Array.newInstance(block.getClass().getComponentType(), newWidth * newHeight);
        Horizontal row = new Horizontal(0, dupX);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int pointDestination;
                int pointSource = this.point(i, j, width);
                row.start = pointDestination = this.point(i * dupX, j * dupY, newWidth);
                this.screenSet(block, pointSource, newBlock, row);
                this.RepeatRow(newBlock, row, dupY - 1, newWidth);
            }
        }
        return (V)newBlock;
    }

    default public void RepeatRow(V screen, Horizontal row, int times) {
        this.RepeatRow(screen, row, times, this.getScreenWidth());
    }

    default public void RepeatRow(V block, Horizontal row, int times, int blockWidth) {
        if (times > 0) {
            Relocation rel = row.relocate(blockWidth);
            while (times > 0) {
                this.screenCopy(block, block, rel);
                --times;
                rel.shift(blockWidth);
            }
        }
    }
}

