/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.function.IntConsumer;
import java.util.logging.Level;
import java.util.stream.IntStream;
import m.Settings;
import mochadoom.Engine;
import mochadoom.Loggers;
import rr.column_t;
import rr.patch_t;
import v.graphics.Blocks;
import v.graphics.Horizontal;

public interface Columns<V, E extends Enum<E>>
extends Blocks<V, E> {
    default public void DrawColumn(V screen, column_t col, Horizontal row, V data, int scrWidth, int dupy) {
        int fullRowShift = scrWidth * dupy;
        int delta = 0;
        for (int j = 0; j < col.posts && col.postdeltas[j] != 255; ++j) {
            int n = -delta;
            delta = col.postdeltas[j];
            row.shift(this.point(0, (n + delta) * dupy, scrWidth));
            int saveRowStart = row.start;
            for (int p = 0; p < col.postlen[j]; ++p) {
                this.screenSet(data, col.postofs[j] + p, screen, row);
                this.RepeatRow(screen, row, dupy - 1);
                row.shift(fullRowShift);
            }
            row.start = saveRowStart;
        }
    }

    default public void DrawPatchColumns(V screen, patch_t patch, int x, int y, int dupx, int dupy, boolean flip) {
        int scrWidth = this.getScreenWidth();
        IntConsumer task = i -> {
            int startPoint = this.point(x + i * dupx, y, scrWidth);
            column_t column = flip ? patch.columns[patch.width - 1 - i] : patch.columns[i];
            this.DrawColumn(screen, column, new Horizontal(startPoint, dupx), this.convertPalettedBlock(column.data), scrWidth, dupy);
        };
        if (U.COLUMN_THREADS > 0) {
            try {
                ((ForkJoinTask)U.pool.submit(() -> IntStream.range(0, patch.width).parallel().forEach(task))).get();
            }
            catch (InterruptedException | ExecutionException ex) {
                Loggers.getLogger(Columns.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (int i2 = 0; i2 < patch.width; ++i2) {
                task.accept(i2);
            }
        }
    }

    public static class U {
        static final int COLUMN_THREADS = Engine.getConfig().getValue(Settings.parallelism_patch_columns, Integer.class);
        private static final ForkJoinPool pool = COLUMN_THREADS > 0 ? new ForkJoinPool(COLUMN_THREADS) : null;

        private U() {
        }
    }
}

