/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum Direction {
    LEFT_UP,
    UP,
    RIGHT_UP,
    LEFT,
    CENTER,
    RIGHT,
    LEFT_DOWN,
    DOWN,
    RIGHT_DOWN;

    public static final List<Direction> directions;
    public final boolean hasTop = this.ordinal() < 3;
    public final boolean hasLeft = this.ordinal() % 3 == 0;
    public final boolean hasRight = this.ordinal() % 3 == 2;
    public final boolean hasBottom = this.ordinal() > 5;
    public final boolean straight = this.ordinal() % 2 != 0;

    public boolean isAdjacent(Direction dir) {
        return this.straight ^ dir.straight;
    }

    public Direction next() {
        if (this == RIGHT_DOWN) {
            return LEFT_UP;
        }
        return directions.get(this.ordinal() + 1);
    }

    public Direction opposite() {
        switch (this) {
            case LEFT_UP: {
                return RIGHT_DOWN;
            }
            case UP: {
                return DOWN;
            }
            case RIGHT_UP: {
                return LEFT_DOWN;
            }
            case LEFT: {
                return RIGHT;
            }
            default: {
                return this;
            }
            case RIGHT: {
                return LEFT;
            }
            case LEFT_DOWN: {
                return RIGHT_UP;
            }
            case DOWN: {
                return UP;
            }
            case RIGHT_DOWN: 
        }
        return LEFT_UP;
    }

    public Direction rotationHor(int sign) {
        if (sign == 0) {
            return this;
        }
        switch (this) {
            case LEFT_UP: {
                return sign > 0 ? UP : LEFT;
            }
            case UP: {
                return sign > 0 ? RIGHT_UP : LEFT_UP;
            }
            case RIGHT_UP: {
                return sign > 0 ? RIGHT : UP;
            }
            case LEFT: {
                return sign > 0 ? CENTER : this;
            }
            default: {
                return sign > 0 ? RIGHT : LEFT;
            }
            case RIGHT: {
                return sign > 0 ? CENTER : this;
            }
            case LEFT_DOWN: {
                return sign > 0 ? DOWN : LEFT;
            }
            case DOWN: {
                return sign > 0 ? RIGHT_DOWN : LEFT_DOWN;
            }
            case RIGHT_DOWN: 
        }
        return sign > 0 ? RIGHT : DOWN;
    }

    public Direction rotationVert(int sign) {
        if (sign == 0) {
            return this;
        }
        switch (this) {
            case LEFT_UP: {
                return sign > 0 ? LEFT : UP;
            }
            case UP: {
                return sign > 0 ? CENTER : this;
            }
            case RIGHT_UP: {
                return sign > 0 ? RIGHT : UP;
            }
            case LEFT: {
                return sign > 0 ? LEFT_DOWN : LEFT_UP;
            }
            default: {
                return sign > 0 ? DOWN : UP;
            }
            case RIGHT: {
                return sign > 0 ? RIGHT_DOWN : RIGHT_UP;
            }
            case LEFT_DOWN: {
                return sign > 0 ? DOWN : LEFT;
            }
            case DOWN: {
                return sign < 0 ? CENTER : this;
            }
            case RIGHT_DOWN: 
        }
        return sign > 0 ? DOWN : RIGHT;
    }

    public Direction rotation(int signX, int signY) {
        Direction rotY;
        Direction rotX = this.rotationHor(signX);
        if (rotX.isAdjacent(rotY = this.rotationHor(signY))) {
            if (signX > 0 && signY > 0) {
                return RIGHT_DOWN;
            }
            if (signX > 0 && signY < 0) {
                return RIGHT_UP;
            }
            if (signX < 0 && signY > 0) {
                return LEFT_DOWN;
            }
            if (signX < 0 && signY < 0) {
                return LEFT_UP;
            }
        }
        return rotY;
    }

    static {
        directions = Collections.unmodifiableList(Arrays.asList(Direction.values()));
    }
}

