/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import v.graphics.Colors;
import v.tables.GreyscaleFilter;

public interface Lights
extends Colors {
    public static final int COLORMAP_LIGHTS_15 = 32;
    public static final int COLORMAP_LIGHTS_24 = 256;
    public static final int COLORMAP_STD_LENGTH_15 = 33;
    public static final int COLORMAP_STD_LENGTH_24 = 257;
    public static final int COLORMAP_INVERSE = 32;
    public static final int COLORMAP_BLURRY = 6;
    public static final int COLORMAP_BULLBRIGHT = 1;
    public static final int COLORMAP_FIXED = 0;
    public static final float LIGHT_INCREMENT_RATIO_24 = 0.00390625f;

    default public int[][] BuildLights24(int[] palette, byte[][] colormap) {
        int i;
        int[][] targetColormap = new int[Math.max(colormap.length, 33) - 32 + 256][256];
        int[] color0 = new int[3];
        int[] color1 = new int[3];
        int[] color2 = new int[3];
        float[] ratio0 = new float[3];
        float weight = 0.0f;
        for (int i2 = 0; i2 < 256; ++i2) {
            targetColormap[0][i2] = palette[colormap[0][i2] & 0xFF];
            this.getRGB888(targetColormap[0][i2], color0);
            this.getRGB888(palette[i2], color1);
            this.ColorRatio(color0, color1, ratio0);
            weight += GreyscaleFilter.component(ratio0[0], ratio0[1], ratio0[2]);
        }
        float currentLightRatio = Math.min(weight / 256.0f, 1.0f);
        for (i = 1; i < 256; ++i) {
            int div = (int)Math.ceil((double)i / 8.0);
            int target = Math.min(div, 31);
            int remainder = div < 32 ? i % 8 : 0;
            float gradient = 1.0f - (float)remainder * 0.125f;
            weight = 0.0f;
            for (int j = 0; j < 256; ++j) {
                this.getRGB888(palette[colormap[target][j] & 0xFF], color0);
                this.getRGB888(targetColormap[i - 1][j], color1);
                this.ColorRatio(color0, color1, ratio0);
                weight += GreyscaleFilter.component(ratio0[0], ratio0[1], ratio0[2]);
                this.getRGB888(targetColormap[0][j], color2);
                targetColormap[i][j] = this.toRGB888(this.sigmoidGradient(color1[0], (int)((double)((float)Math.max(color2[0], color0[0]) * currentLightRatio) + 0.5), gradient), this.sigmoidGradient(color1[1], (int)((double)((float)Math.max(color2[1], color0[1]) * currentLightRatio) + 0.5), gradient), this.sigmoidGradient(color1[2], (int)((double)((float)Math.max(color2[2], color0[2]) * currentLightRatio) + 0.5), gradient));
            }
            currentLightRatio += weight > 256.0f ? 0.00390625f : -0.00390625f;
        }
        i = 256;
        for (int j = 32; j < colormap.length; ++j) {
            this.CopyMap24(targetColormap[i], palette, colormap[j]);
            ++i;
        }
        return targetColormap;
    }

    default public int[][] BuildLights24(int[] palette) {
        int[][] targetColormap = new int[257][256];
        int[] palColor = new int[3];
        for (int c = 0; c < 256; ++c) {
            this.getRGB888(palette[c], palColor);
            for (int l = 0; l < 256; ++l) {
                targetColormap[l][c] = this.toRGB888(this.AddLight8(palColor[0], l), this.AddLight8(palColor[1], l), this.AddLight8(palColor[2], l));
            }
            this.BuildSpecials24(targetColormap[256], palColor, c);
        }
        return targetColormap;
    }

    default public short[][] BuildLights15(int[] palette, byte[][] colormaps) {
        short[][] targetColormap = new short[Math.max(colormaps.length, 33)][256];
        for (int c = 0; c < colormaps.length; ++c) {
            this.CopyMap15(targetColormap[c], palette, colormaps[c]);
        }
        return targetColormap;
    }

    default public short[][] BuildLights15(int[] palette) {
        short[][] targetColormap = new short[33][256];
        int[] palColor = new int[3];
        for (int c = 0; c < 256; ++c) {
            this.getRGB888(palette[c], palColor);
            for (int l = 0; l < 32; ++l) {
                targetColormap[l][c] = this.toRGB555(this.AddLight5(palColor[0], l), this.AddLight5(palColor[1], l), this.AddLight5(palColor[2], l));
            }
            this.BuildSpecials15(targetColormap[32], palColor, c);
        }
        return targetColormap;
    }

    default public byte[][] BuildLightsI(int[] palette) {
        byte[][] targetColormap = new byte[33][256];
        int[] palColor = new int[3];
        for (int c = 0; c < 256; ++c) {
            this.getRGB888(palette[c], palColor);
            for (int l = 0; l < 32; ++l) {
                targetColormap[l][c] = (byte)this.BestColor(this.AddLightI(palColor[0], l), this.AddLightI(palColor[1], l), this.AddLightI(palColor[2], l), palette, 0, 255);
            }
            this.BuildSpecialsI(targetColormap[32], palColor, palette, c);
        }
        return targetColormap;
    }

    default public int AddLight8(int c8, int light) {
        return (int)((double)((float)c8 * (1.0f - (float)light / 256.0f)) + 0.5);
    }

    default public int AddLight5(int c8, int light) {
        return (int)((double)((float)c8 * (1.0f - (float)light / 32.0f)) + 0.5) >> 3;
    }

    default public int AddLightI(int c8, int light) {
        return (int)((double)((float)c8 * (1.0f - (float)light / 32.0f)) + 0.5);
    }

    default public int[][] AllocateColormap24(boolean hasColormap, byte[][][] colormap) {
        int targetLength = hasColormap ? 257 + Math.max(0, colormap[0].length - 33) : 257;
        int[][] targetColormap = new int[targetLength][256];
        return targetColormap;
    }

    default public short[][] AllocateColormap15(boolean hasColormap, byte[][][] colormap) {
        int targetLength = hasColormap ? Math.max(33, colormap[0].length) : 33;
        short[][] targetColormap = new short[targetLength][256];
        return targetColormap;
    }

    default public void CopyMap24(int[] targetColormap, int[] palette, byte[] map) {
        for (int c = 0; c < 256; ++c) {
            targetColormap[c] = palette[map[c] & 0xFF];
        }
    }

    default public void CopyMap15(short[] targetColormap, int[] palette, byte[] map) {
        int[] palColor = new int[3];
        for (int c = 0; c < 256; ++c) {
            this.getRGB888(palette[map[c] & 0xFF], palColor);
            targetColormap[c] = this.rgb888to555(palColor[0], palColor[1], palColor[2]);
        }
    }

    default public void BuildSpecials24(int[] targetColormap, int[] rgb, int index) {
        float luminance = GreyscaleFilter.component((float)rgb[0], (float)rgb[1], (float)rgb[2]);
        int grey = (int)(255.0 * (1.0 - (double)(luminance / 256.0f)));
        targetColormap[index] = this.toRGB888(grey, grey, grey);
    }

    default public void BuildSpecials15(short[] targetColormap, int[] rgb, int index) {
        float luminance = GreyscaleFilter.component((float)rgb[0], (float)rgb[1], (float)rgb[2]);
        int grey = (int)(255.0 * (1.0 - (double)(luminance / 256.0f)));
        targetColormap[index] = this.toRGB555(grey >> 3, grey >> 3, grey >> 3);
    }

    default public void BuildSpecialsI(byte[] targetColormap, int[] rgb, int[] palette, int index) {
        float luminance = GreyscaleFilter.component((float)rgb[0], (float)rgb[1], (float)rgb[2]);
        int grey = (int)(255.0 * (1.0 - (double)(luminance / 256.0f)));
        targetColormap[index] = (byte)this.BestColor(grey, grey, grey, palette, 0, 255);
    }
}

