/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import rr.patch_t;
import v.graphics.Screens;

public interface Points<V, E extends Enum<E>>
extends Screens<V, E> {
    default public void doRangeCheck(int x, int y, int width, int height) throws Screens.BadRangeException {
        if (x >= 0 && y >= 0) {
            int scrWidth = this.getScreenWidth();
            int scrHeight = this.getScreenHeight();
            if (x + width > scrWidth || y + height > scrWidth) {
                throw new Screens.BadRangeException(String.format("Coordinates overflow screen space: (%d, %d, %d, %d) on screen %dx%d", x, y, x + width, y + height, scrWidth, scrHeight));
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid coordinates: (%d, %d)", x, y));
        }
    }

    default public void doRangeCheck(int x, int y, patch_t patch) throws Screens.BadRangeException {
        this.doRangeCheck(x, y, patch.width, patch.height);
    }

    default public void doRangeCheck(int x, int y, patch_t patch, int dupx, int dupy) throws Screens.BadRangeException {
        this.doRangeCheck(x, y, patch.width * dupx, patch.height * dupy);
    }

    default public int point(int x, int y) {
        return y * this.getScreenWidth() + x;
    }

    default public int point(int x, int y, int width) {
        return y * width + x;
    }
}

