/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import java.awt.Rectangle;
import v.graphics.Blocks;
import v.graphics.Horizontal;
import v.graphics.Points;
import v.graphics.Relocation;

public interface Rectangles<V, E extends Enum<E>>
extends Blocks<V, E>,
Points<V, E> {
    default public Horizontal GetRectRow(Rectangle rect, int heightIndex) {
        if (heightIndex < 0 || heightIndex > rect.height) {
            throw new IndexOutOfBoundsException("Bad row index: " + heightIndex);
        }
        return new Horizontal(this.point(rect.x, rect.y) + heightIndex * this.getScreenWidth(), rect.width);
    }

    default public void CopyRect(E srcScreenType, Rectangle rectangle, E dstScreenType) {
        Object srcScreen = this.getScreen(srcScreenType);
        Object dstScreen = this.getScreen(dstScreenType);
        int screenWidth = this.getScreenWidth();
        int point = this.point(rectangle.x, rectangle.y);
        Relocation rel = new Relocation(point, point, rectangle.width);
        for (int h = rectangle.height; h > 0; --h) {
            this.screenCopy(srcScreen, dstScreen, rel);
            rel.shift(screenWidth);
        }
    }

    default public void CopyRect(E srcScreenType, Rectangle rectangle, E dstScreenType, int dstPoint) {
        Object srcScreen = this.getScreen(srcScreenType);
        Object dstScreen = this.getScreen(dstScreenType);
        int screenWidth = this.getScreenWidth();
        Relocation rel = new Relocation(this.point(rectangle.x, rectangle.y), dstPoint, rectangle.width);
        for (int h = rectangle.height; h > 0; --h) {
            this.screenCopy(srcScreen, dstScreen, rel);
            rel.shift(screenWidth);
        }
    }

    default public void FillRect(E screenType, Rectangle rectangle, V patternSrc, Horizontal pattern) {
        Object screen = this.getScreen(screenType);
        if (rectangle.height > 0) {
            Horizontal row = this.GetRectRow(rectangle, 0);
            this.screenSet(patternSrc, pattern, screen, row);
            this.RepeatRow(screen, row, rectangle.height - 1);
        }
    }

    default public void FillRect(E screenType, Rectangle rectangle, V patternSrc, int point) {
        Object screen = this.getScreen(screenType);
        if (rectangle.height > 0) {
            Horizontal row = this.GetRectRow(rectangle, 0);
            this.screenSet(patternSrc, point, screen, row);
            this.RepeatRow(screen, row, rectangle.height - 1);
        }
    }

    default public void FillRect(E screenType, Rectangle rectangle, int color) {
        this.FillRect(screenType, rectangle, (byte)color);
    }

    default public void FillRect(E screenType, Rectangle rectangle, byte color) {
        Object screen = this.getScreen(screenType);
        if (rectangle.height > 0) {
            Object filler = this.convertPalettedBlock(color);
            Horizontal row = this.GetRectRow(rectangle, 0);
            this.screenSet(filler, 0, screen, row);
            this.RepeatRow(screen, row, rectangle.height - 1);
        }
    }
}

