/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import f.Wiper;
import java.lang.reflect.Array;
import m.IRandom;
import utils.GenericCopy;
import v.graphics.Horizontal;
import v.graphics.Plotter;
import v.graphics.Relocation;
import v.renderers.DoomScreen;

public interface Screens<V, E extends Enum<E>> {
    public static final int SCREENS_COUNT = DoomScreen.values().length;

    public V getScreen(E var1);

    public int getScalingX();

    public int getScalingY();

    public int getScreenWidth();

    public int getScreenHeight();

    public Wiper createWiper(IRandom var1);

    default public void screenSet(V screen, int point, Horizontal destination) {
        GenericCopy.memset(screen, destination.start, destination.length, screen, point, 1);
    }

    default public void screenSet(V srcScreen, Horizontal pattern, V dstScreen, Horizontal destination) {
        GenericCopy.memset(dstScreen, destination.start, destination.length, srcScreen, pattern.start, pattern.length);
    }

    default public void screenSet(V srcScreen, int point, V dstScreen, Horizontal destination) {
        GenericCopy.memset(dstScreen, destination.start, destination.length, srcScreen, point, 1);
    }

    default public void screenSet(V screen, Horizontal pattern, Horizontal destination) {
        GenericCopy.memset(screen, destination.start, destination.length, screen, pattern.start, pattern.length);
    }

    default public void screenCopy(V srcScreen, V dstScreen, Relocation relocation) {
        GenericCopy.memcpy(srcScreen, relocation.source, dstScreen, relocation.destination, relocation.length);
    }

    default public void screenCopy(E srcScreen, E dstScreen) {
        V dstScreenObj = this.getScreen(dstScreen);
        GenericCopy.memcpy(this.getScreen(srcScreen), 0, dstScreenObj, 0, Array.getLength(dstScreenObj));
    }

    default public Plotter<V> createPlotter(E screen) {
        return new Plotter.Thin<V>(this.getScreen(screen), this.getScreenWidth());
    }

    public static class BadRangeException
    extends Exception {
        private static final long serialVersionUID = 2903441181162189295L;

        public BadRangeException(String m) {
            super(m);
        }

        public BadRangeException() {
        }
    }
}

