/*
 * Decompiled with CFR 0.152.
 */
package v.graphics;

import f.Wiper;
import java.lang.reflect.Array;
import m.IRandom;
import utils.GenericCopy;
import v.graphics.ColorTransform;
import v.graphics.Melt;
import v.graphics.Relocation;
import v.graphics.Screens;

public class Wipers
implements ColorTransform,
Melt {
    private static final Wipers instance = new Wipers();

    public static <V, E extends Enum<E>> Wiper createWiper(IRandom rnd, Screens<V, E> screens, E ws, E we, E ms) {
        return new WiperImpl(rnd, screens, ws, we, ms, null);
    }

    private Wipers() {
    }

    static /* synthetic */ Wipers access$000() {
        return instance;
    }

    public static interface WipeType {
        public WipeFunc getInitFunc();

        public WipeFunc getDoFunc();

        public WipeFunc getExitFunc();
    }

    protected static final class WiperImpl<V, E extends Enum<E>>
    implements Wiper {
        private final Relocation relocation = new Relocation(0, 0, 1);
        final IRandom random;
        final Screens<V, E> screens;
        final Class<?> bufferType;
        final V wipeStartScr;
        final V wipeEndScr;
        final V wipeScr;
        final int screenWidth;
        final int screenHeight;
        final int dupx;
        final int dupy;
        final int scaled_16;
        final int scaled_8;
        int[] y;
        int ticks;
        volatile boolean go = false;

        private WiperImpl(IRandom RND, Screens<V, E> screens, E wipeStartScreen, E wipeEndScreen, E mainScreen) {
            this.random = RND;
            this.wipeStartScr = screens.getScreen(wipeStartScreen);
            this.wipeEndScr = screens.getScreen(wipeEndScreen);
            this.wipeScr = screens.getScreen(mainScreen);
            this.bufferType = this.wipeScr.getClass();
            this.screens = screens;
            this.screenWidth = screens.getScreenWidth();
            this.screenHeight = screens.getScreenHeight();
            this.dupx = screens.getScalingX();
            this.dupy = screens.getScalingY();
            this.scaled_16 = this.dupy << 4;
            this.scaled_8 = this.dupy << 3;
        }

        void startToScreen(int source, int destination) {
            this.screens.screenCopy(this.wipeStartScr, this.wipeScr, this.relocation.retarget(source, destination));
        }

        void endToScreen(int source, int destination) {
            this.screens.screenCopy(this.wipeEndScr, this.wipeScr, this.relocation.retarget(source, destination));
        }

        @Override
        public boolean StartScreen(int x, int y, int width, int height) {
            GenericCopy.memcpy(this.wipeScr, 0, this.wipeStartScr, 0, Array.getLength(this.wipeStartScr));
            return false;
        }

        @Override
        public boolean EndScreen(int x, int y, int width, int height) {
            GenericCopy.memcpy(this.wipeScr, 0, this.wipeEndScr, 0, Array.getLength(this.wipeEndScr));
            GenericCopy.memcpy(this.wipeStartScr, 0, this.wipeScr, 0, Array.getLength(this.wipeScr));
            return false;
        }

        private boolean invokeCheckedFunc(WipeFunc f) {
            return f.func.invoke(this);
        }

        @Override
        public boolean ScreenWipe(WipeType type, int x, int y, int width, int height, int ticks) {
            boolean rc;
            this.ticks = ticks;
            if (!this.go) {
                this.go = true;
                this.invokeCheckedFunc(type.getInitFunc());
            }
            if (rc = this.invokeCheckedFunc(type.getDoFunc())) {
                this.go = false;
                this.invokeCheckedFunc(type.getExitFunc());
            }
            return !this.go;
        }

        /* synthetic */ WiperImpl(IRandom x0, Screens x1, Enum x2, Enum x3, Enum x4, 1 x5) {
            this(x0, x1, x2, x3, x4);
        }
    }

    public static enum WipeFunc {
        doColorXFormB(Wipers.access$000()::colorTransformB, byte[].class),
        doColorXFormS(Wipers.access$000()::colorTransformS, short[].class),
        doColorXFormI(Wipers.access$000()::colorTransformI, int[].class),
        initColorXForm(Wipers.access$000()::initTransform),
        doColorXForm(doColorXFormB, doColorXFormS, doColorXFormI),
        exitColorXForm(w -> false),
        initScaledMelt(Wipers.access$000()::initMeltScaled),
        doScaledMelt(Wipers.access$000()::doMeltScaled),
        initMelt(Wipers.access$000()::initMelt),
        doMelt(Wipers.access$000()::doMelt),
        exitMelt(Wipers.access$000()::exitMelt);

        private final Class<?> supportFor;
        private final WF<?> func;

        private WipeFunc(WF<?> func) {
            this.supportFor = null;
            this.func = func;
        }

        private <V> WipeFunc(WF<V> func, Class<V> supportFor) {
            this.supportFor = supportFor;
            this.func = func;
        }

        private WipeFunc(WipeFunc ... wf) {
            this.supportFor = null;
            this.func = WipeFunc.wipeChoice(wf);
        }

        private static <V> WF<V> wipeChoice(WipeFunc[] wf) {
            return wiper -> {
                for (int i = 0; i < wf.length; ++i) {
                    if (wiper.bufferType != wf[i].supportFor) continue;
                    WF<?> supported = wf[i].func;
                    return supported.invoke(wiper);
                }
                throw new UnsupportedOperationException("Do not have support for: " + wiper.bufferType);
            };
        }

        static interface WF<V> {
            public boolean invoke(WiperImpl<V, ?> var1);
        }
    }
}

