/*
 * Decompiled with CFR 0.152.
 */
package v.renderers;

import doom.CVarManager;
import doom.CommandVariable;
import doom.DoomMain;
import java.util.function.Function;
import m.Settings;
import mochadoom.Engine;
import rr.SceneRenderer;
import v.DoomGraphicSystem;
import v.renderers.BufferedRenderer;
import v.renderers.BufferedRenderer16;
import v.renderers.BufferedRenderer32;
import v.renderers.RendererFactory;
import v.renderers.SceneRendererMode;
import v.renderers.SoftwareGraphicsSystem;

public enum BppMode {
    Indexed(5, BufferedRenderer::new, BppMode::SceneGen_8, 1),
    HiColor(5, BufferedRenderer16::new, BppMode::SceneGen_16, 1),
    TrueColor(8, BufferedRenderer32::new, BppMode::SceneGen_32, 1),
    AlphaTrueColor(8, BufferedRenderer32::new, BppMode::SceneGen_32, 3);

    public final int transparency;
    public final int lightBits;
    final RenderGen<?, ?> renderGen;
    final ScenerGen<?, ?> scenerGen;

    private <T, V> BppMode(int lightBits, RenderGen<T, V> renderGen, ScenerGen<T, V> scenerGen, int transparency) {
        this.lightBits = lightBits;
        this.renderGen = renderGen;
        this.scenerGen = scenerGen;
        this.transparency = transparency;
    }

    public <T, V> DoomGraphicSystem<T, V> graphics(RendererFactory.WithWadLoader<T, V> rf) {
        return (DoomGraphicSystem)this.renderGen.apply(rf);
    }

    public <T, V> SceneRenderer<T, V> sceneRenderer(DoomMain<T, V> DOOM) {
        return (SceneRenderer)this.scenerGen.apply(DOOM);
    }

    public static BppMode chooseBppMode(CVarManager CVM) {
        if (CVM.bool(CommandVariable.TRUECOLOR)) {
            return TrueColor;
        }
        if (CVM.bool(CommandVariable.HICOLOR)) {
            return HiColor;
        }
        if (CVM.bool(CommandVariable.INDEXED)) {
            return Indexed;
        }
        if (CVM.bool(CommandVariable.ALPHATRUECOLOR)) {
            return AlphaTrueColor;
        }
        return Engine.getConfig().getValue(Settings.color_depth, BppMode.class);
    }

    private static <T, V> SceneRenderer<T, V> SceneGen_8(DoomMain<T, V> DOOM) {
        return (SceneRenderer)SceneRendererMode.getMode().indexedGen.apply((byte[])DOOM);
    }

    private static <T, V> SceneRenderer<T, V> SceneGen_16(DoomMain<T, V> DOOM) {
        return (SceneRenderer)SceneRendererMode.getMode().hicolorGen.apply((byte[])DOOM);
    }

    private static <T, V> SceneRenderer<T, V> SceneGen_32(DoomMain<T, V> DOOM) {
        return (SceneRenderer)SceneRendererMode.getMode().truecolorGen.apply((byte[])DOOM);
    }

    static interface RenderGen<T, V>
    extends Function<RendererFactory.WithWadLoader<T, V>, SoftwareGraphicsSystem<T, V>> {
    }

    static interface ScenerGen<T, V>
    extends Function<DoomMain<T, V>, SceneRenderer<T, V>> {
    }
}

