/*
 * Decompiled with CFR 0.152.
 */
package v.renderers;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.util.concurrent.BrokenBarrierException;
import java.util.logging.Level;
import mochadoom.Loggers;
import v.renderers.DoomScreen;
import v.renderers.RendererFactory;
import v.renderers.SoftwareParallelVideoRenderer;
import v.tables.BlurryTable;
import v.tables.ColorTint;

class BufferedRenderer32
extends SoftwareParallelVideoRenderer<byte[], int[]> {
    protected final int[] raster;
    protected VolatileImage screen;
    protected final boolean compatible = BufferedRenderer32.checkConfigurationTruecolor();
    protected final int transparency;
    protected final BlurryTable blurryTable;

    BufferedRenderer32(RendererFactory.WithWadLoader<byte[], int[]> rf) {
        super(rf, int[].class);
        this.screen = GRAPHICS_CONF.createCompatibleVolatileImage(this.width, this.height);
        this.transparency = rf.getBppMode().transparency;
        this.currentscreen = this.compatible ? GRAPHICS_CONF.createCompatibleImage(this.width, this.height, this.transparency) : new BufferedImage(this.width, this.height, this.transparency == 3 ? 2 : 1);
        this.currentscreen.setAccelerationPriority(1.0f);
        this.raster = ((DataBufferInt)((BufferedImage)this.currentscreen).getRaster().getDataBuffer()).getData();
        this.blurryTable = new BlurryTable((int[][])this.liteColorMaps);
        int len = this.raster.length;
        int chunk = len / PARALLELISM;
        for (int i = 0; i < PARALLELISM; ++i) {
            this.paletteThreads[i] = new IntPaletteThread(i * chunk, (i + 1) * chunk);
        }
    }

    @Override
    public Image getScreenImage() {
        do {
            if (this.screen.validate(GRAPHICS_CONF) == 2) {
                this.screen.flush();
                this.screen = GRAPHICS_CONF.createCompatibleVolatileImage(this.width, this.height);
            }
            this.doWriteScreen();
        } while (this.screen.contentsLost());
        return this.screen;
    }

    @Override
    void doWriteScreen() {
        for (int i = 0; i < PARALLELISM; ++i) {
            this.executor.execute(this.paletteThreads[i]);
        }
        try {
            this.updateBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            Loggers.getLogger(BufferedRenderer32.class.getName()).log(Level.SEVERE, e, null);
        }
        Graphics2D g = this.screen.createGraphics();
        g.drawImage(this.currentscreen, 0, 0, null);
        g.dispose();
    }

    @Override
    public int getBaseColor(byte color) {
        return ((int[])this.palette)[color & 0xFF];
    }

    @Override
    public BlurryTable getBlurryTable() {
        return this.blurryTable;
    }

    private class IntPaletteThread
    implements Runnable {
        private final int[] FG;
        private final int start;
        private final int stop;

        IntPaletteThread(int start, int stop) {
            this.start = start;
            this.stop = stop;
            this.FG = (int[])BufferedRenderer32.this.screens.get((Object)DoomScreen.FG);
        }

        @Override
        public void run() {
            ColorTint t = (BufferedRenderer32.this.GRAYPAL_SET ? ColorTint.GREY_TINTS : ColorTint.NORMAL_TINTS).get(BufferedRenderer32.this.usepalette);
            byte[] LUT_R = t.LUT_r8[BufferedRenderer32.this.usegamma];
            byte[] LUT_G = t.LUT_g8[BufferedRenderer32.this.usegamma];
            byte[] LUT_B = t.LUT_b8[BufferedRenderer32.this.usegamma];
            int i = this.start;
            while (i < this.stop) {
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
                BufferedRenderer32.this.raster[i] = (this.FG[i] & 0xFF000000) + ((LUT_R[this.FG[i] >> 16 & 0xFF] & 0xFF) << 16) + ((LUT_G[this.FG[i] >> 8 & 0xFF] & 0xFF) << 8) + (LUT_B[this.FG[i++] & 0xFF] & 0xFF);
            }
            try {
                BufferedRenderer32.this.updateBarrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                Loggers.getLogger(BufferedRenderer32.class.getName()).log(Level.WARNING, e, null);
            }
        }
    }
}

