/*
 * Decompiled with CFR 0.152.
 */
package v.renderers;

import java.util.Objects;
import v.DoomGraphicSystem;
import v.renderers.BppMode;
import v.scale.VideoScale;
import w.IWadLoader;

public class RendererFactory {
    private RendererFactory() {
    }

    public static <T, V> Clear<T, V> newBuilder() {
        return new Builder();
    }

    public static interface WithWadLoader<T, V> {
        public DoomGraphicSystem<T, V> build();

        public VideoScale getVideoScale();

        public BppMode getBppMode();

        public IWadLoader getWadLoader();
    }

    public static interface WithBppMode<T, V> {
        public WithWadLoader<T, V> setWadLoader(IWadLoader var1);

        public VideoScale getVideoScale();

        public BppMode getBppMode();
    }

    public static interface WithVideoScale<T, V> {
        public WithBppMode<T, V> setBppMode(BppMode var1);

        public VideoScale getVideoScale();
    }

    public static interface Clear<T, V> {
        public WithVideoScale<T, V> setVideoScale(VideoScale var1);
    }

    private static class Builder<T, V>
    implements Clear<T, V>,
    WithVideoScale<T, V>,
    WithBppMode<T, V>,
    WithWadLoader<T, V> {
        private IWadLoader wadLoader;
        private VideoScale videoScale;
        private BppMode bppMode;

        private Builder() {
        }

        @Override
        public WithVideoScale<T, V> setVideoScale(VideoScale videoScale) {
            this.videoScale = Objects.requireNonNull(videoScale);
            return this;
        }

        @Override
        public WithBppMode<T, V> setBppMode(BppMode bppMode) {
            this.bppMode = Objects.requireNonNull(bppMode);
            return this;
        }

        @Override
        public WithWadLoader<T, V> setWadLoader(IWadLoader wadLoader) {
            this.wadLoader = Objects.requireNonNull(wadLoader);
            return this;
        }

        @Override
        public DoomGraphicSystem<T, V> build() {
            return this.bppMode.graphics(this);
        }

        @Override
        public BppMode getBppMode() {
            return this.bppMode;
        }

        @Override
        public VideoScale getVideoScale() {
            return this.videoScale;
        }

        @Override
        public IWadLoader getWadLoader() {
            return this.wadLoader;
        }
    }
}

