/*
 * Decompiled with CFR 0.152.
 */
package v.renderers;

import doom.CommandVariable;
import f.Wiper;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.util.Map;
import m.IRandom;
import m.Settings;
import mochadoom.Engine;
import rr.patch_t;
import v.DoomGraphicSystem;
import v.graphics.Blocks;
import v.graphics.Horizontal;
import v.graphics.Lines;
import v.graphics.Patches;
import v.graphics.Plotter;
import v.graphics.Rectangles;
import v.graphics.Relocation;
import v.graphics.Wipers;
import v.renderers.DoomScreen;
import v.renderers.RendererFactory;
import v.scale.VideoScale;
import v.tables.GammaTables;
import v.tables.Playpal;

abstract class SoftwareGraphicsSystem<T, V>
implements DoomGraphicSystem<T, V>,
Rectangles<V, DoomScreen>,
Blocks<V, DoomScreen>,
Patches<V, DoomScreen>,
Lines {
    protected final Map<DoomScreen, V> screens;
    protected final VideoScale vs;
    protected final Class<V> bufferType;
    protected final V[] liteColorMaps;
    protected final V palette;
    protected Image currentscreen;
    protected int width;
    protected int height;
    protected int bufferLength;
    protected int usegamma = 0;
    protected int usepalette = 0;
    private byte[] playpal;

    SoftwareGraphicsSystem(RendererFactory.WithWadLoader<T, V> rf, Class<V> bufferType) {
        this.vs = rf.getVideoScale();
        this.width = this.vs.getScreenWidth();
        this.height = this.vs.getScreenHeight();
        this.bufferType = bufferType;
        this.bufferLength = this.width * this.height;
        this.screens = DoomScreen.mapScreensToBuffers(bufferType, this.bufferLength);
        this.palette = this.palette(rf);
        this.liteColorMaps = this.colormap(rf);
    }

    private V palette(RendererFactory.WithWadLoader<T, V> rf) {
        byte[] byArray = Engine.getCVM().bool(CommandVariable.GREYPAL) ? Playpal.greypal() : (this.playpal = Engine.getCVM().bool(CommandVariable.NOPLAYPAL) ? Playpal.properPlaypal(null) : rf.getWadLoader().tryLoadPlaypal());
        return (V)(this.bufferType == byte[].class ? this.playpal : (this.bufferType == short[].class ? (Object[])this.paletteHiColor(this.playpal) : (Object[])this.paletteTrueColor(this.playpal)));
    }

    private V[] colormap(RendererFactory.WithWadLoader<T, V> rf) {
        boolean colormapEnabled;
        boolean bl = colormapEnabled = !Engine.getCVM().bool(CommandVariable.NOCOLORMAP) && Engine.getConfig().equals(Settings.enable_colormap_lump, Boolean.TRUE);
        return this.bufferType == byte[].class ? (colormapEnabled ? (Object[])rf.getWadLoader().LoadColormap() : (Object[])this.BuildLightsI(this.paletteTrueColor(this.playpal))) : (this.bufferType == short[].class ? (colormapEnabled ? (Object[])this.BuildLights15(this.paletteTrueColor(this.playpal), rf.getWadLoader().LoadColormap()) : (Object[])this.BuildLights15(this.paletteTrueColor(this.playpal))) : (colormapEnabled ? (Object[])this.BuildLights24((int[])this.palette, rf.getWadLoader().LoadColormap()) : (Object[])this.BuildLights24((int[])this.palette)));
    }

    @Override
    public final int getUsegamma() {
        return this.usegamma;
    }

    @Override
    public final int getPalette() {
        return this.usepalette;
    }

    @Override
    public final int getScreenHeight() {
        return this.height;
    }

    @Override
    public final int getScreenWidth() {
        return this.width;
    }

    @Override
    public int getScalingX() {
        return this.vs.getScalingX();
    }

    @Override
    public int getScalingY() {
        return this.vs.getScalingY();
    }

    @Override
    public final V getScreen(DoomScreen screenType) {
        return this.screens.get((Object)screenType);
    }

    @Override
    public Image getScreenImage() {
        return this.currentscreen;
    }

    @Override
    public void screenCopy(V srcScreen, V dstScreen, Relocation relocation) {
        Rectangles.super.screenCopy(srcScreen, dstScreen, relocation);
    }

    @Override
    public void screenCopy(DoomScreen srcScreen, DoomScreen dstScreen) {
        Rectangles.super.screenCopy(srcScreen, dstScreen);
    }

    @Override
    public int getBaseColor(int color) {
        return Rectangles.super.getBaseColor(color);
    }

    @Override
    public int point(int x, int y) {
        return Rectangles.super.point(x, y);
    }

    @Override
    public int point(int x, int y, int width) {
        return Rectangles.super.point(x, y, width);
    }

    @Override
    public void drawLine(Plotter<?> plotter, int x1, int x2) {
        Lines.super.drawLine(plotter, x1, x2);
    }

    @Override
    public void DrawPatch(DoomScreen screen, patch_t patch, int x, int y, int ... flags) {
        Patches.super.DrawPatch(screen, patch, x, y, flags);
    }

    @Override
    public void DrawPatchCentered(DoomScreen screen, patch_t patch, int y, int ... flags) {
        Patches.super.DrawPatchCentered(screen, patch, y, flags);
    }

    @Override
    public void DrawPatchCenteredScaled(DoomScreen screen, patch_t patch, VideoScale vs, int y, int ... flags) {
        Patches.super.DrawPatchCenteredScaled(screen, patch, vs, y, flags);
    }

    @Override
    public void DrawPatchScaled(DoomScreen screen, patch_t patch, VideoScale vs, int x, int y, int ... flags) {
        Patches.super.DrawPatchScaled(screen, patch, vs, x, y, flags);
    }

    @Override
    public void DrawPatchColScaled(DoomScreen screen, patch_t patch, VideoScale vs, int x, int col) {
        Patches.super.DrawPatchColScaled(screen, patch, vs, x, col);
    }

    @Override
    public void CopyRect(DoomScreen srcScreenType, Rectangle rectangle, DoomScreen dstScreenType) {
        Rectangles.super.CopyRect(srcScreenType, rectangle, dstScreenType);
    }

    @Override
    public void CopyRect(DoomScreen srcScreenType, Rectangle rectangle, DoomScreen dstScreenType, int dstPoint) {
        Rectangles.super.CopyRect(srcScreenType, rectangle, dstScreenType, dstPoint);
    }

    @Override
    public void FillRect(DoomScreen screenType, Rectangle rectangle, V patternSrc, Horizontal pattern) {
        Rectangles.super.FillRect(screenType, rectangle, patternSrc, pattern);
    }

    @Override
    public void FillRect(DoomScreen screenType, Rectangle rectangle, V patternSrc, int point) {
        Rectangles.super.FillRect(screenType, rectangle, patternSrc, point);
    }

    @Override
    public void FillRect(DoomScreen screenType, Rectangle rectangle, int color) {
        Rectangles.super.FillRect(screenType, rectangle, color);
    }

    @Override
    public void FillRect(DoomScreen screenType, Rectangle rectangle, byte color) {
        Rectangles.super.FillRect(screenType, rectangle, color);
    }

    @Override
    public V ScaleBlock(V block, VideoScale vs, int width, int height) {
        return Rectangles.super.ScaleBlock(block, vs, width, height);
    }

    @Override
    public void TileScreen(DoomScreen dstScreen, V block, Rectangle blockArea) {
        Rectangles.super.TileScreen(dstScreen, block, blockArea);
    }

    @Override
    public void TileScreenArea(DoomScreen dstScreen, Rectangle screenArea, V block, Rectangle blockArea) {
        Rectangles.super.TileScreenArea(dstScreen, screenArea, block, blockArea);
    }

    @Override
    public void DrawBlock(DoomScreen dstScreen, V block, Rectangle sourceArea, int destinationPoint) {
        Rectangles.super.DrawBlock(dstScreen, block, sourceArea, destinationPoint);
    }

    @Override
    public Plotter<V> createPlotter(DoomScreen screen) {
        return DoomGraphicSystem.super.createPlotter(screen);
    }

    @Override
    public void setPalette(int palette) {
        this.usepalette = palette % 14;
        this.forcePalette();
    }

    @Override
    public void setUsegamma(int gamma) {
        this.usegamma = gamma % GammaTables.LUT.length;
        if (Engine.getConfig().equals(Settings.fix_gamma_palette, Boolean.FALSE)) {
            this.usepalette = 0;
        }
        this.forcePalette();
    }

    @Override
    public V[] getColorMap() {
        return this.liteColorMaps;
    }

    public DataBuffer newBuffer(DoomScreen screen) {
        V buffer = this.screens.get((Object)screen);
        if (buffer.getClass() == int[].class) {
            return new DataBufferInt((int[])buffer, ((int[])buffer).length);
        }
        if (buffer.getClass() == short[].class) {
            return new DataBufferUShort((short[])buffer, ((short[])buffer).length);
        }
        if (buffer.getClass() == byte[].class) {
            return new DataBufferByte((byte[])buffer, ((byte[])buffer).length);
        }
        throw new UnsupportedOperationException(String.format("SoftwareVideoRenderer does not support %s buffers", buffer.getClass()));
    }

    @Override
    public Wiper createWiper(IRandom random) {
        return Wipers.createWiper(random, this, DoomScreen.WS, DoomScreen.WE, DoomScreen.FG);
    }
}

