/*
 * Decompiled with CFR 0.152.
 */
package v.tables;

import java.util.TreeMap;
import m.Settings;
import mochadoom.Engine;
import v.graphics.Colors;
import v.tables.FuzzMix;
import v.tables.GreyscaleFilter;

public class BlurryTable
implements FuzzMix,
Colors {
    private final byte[] LUT_idx;
    private final byte[] LUT_r8;
    private final byte[] LUT_g8;
    private final byte[] LUT_b8;
    private final byte[] LUT_a8;
    private final byte[] LUT_r5;
    private final byte[] LUT_g5;
    private final byte[] LUT_b5;
    private final boolean semiTranslucent = Engine.getConfig().equals(Settings.semi_translucent_fuzz, Boolean.TRUE);
    private final boolean fuzzMix = Engine.getConfig().equals(Settings.fuzz_mix, Boolean.TRUE);

    public BlurryTable(byte[][] colorMap) {
        this.LUT_b5 = null;
        this.LUT_g5 = null;
        this.LUT_r5 = null;
        this.LUT_b8 = null;
        this.LUT_g8 = null;
        this.LUT_r8 = null;
        this.LUT_a8 = null;
        this.LUT_idx = colorMap[6];
    }

    public BlurryTable(short[][] liteColorMaps) {
        int i;
        this.LUT_b5 = new byte[32];
        this.LUT_g5 = new byte[32];
        this.LUT_r5 = new byte[32];
        this.LUT_b8 = null;
        this.LUT_g8 = null;
        this.LUT_r8 = null;
        this.LUT_a8 = null;
        this.LUT_idx = null;
        TreeMap<Short, Float> sortedRatios = new TreeMap<Short, Float>(this::CompareColors555);
        for (i = 0; i < 256; ++i) {
            int[] blurryColor = this.getRGB555(liteColorMaps[6][i], new int[3]);
            int[] fixedColor = this.getRGB555(liteColorMaps[0][i], new int[3]);
            short avgColor = GreyscaleFilter.grey555(blurryColor[0], blurryColor[1], blurryColor[2]);
            short avgOrig = GreyscaleFilter.grey555(fixedColor[0], fixedColor[1], fixedColor[2]);
            int[] blurryAvg = this.getRGB555(avgColor, new int[3]);
            int[] fixedAvg = this.getRGB555(avgOrig, new int[3]);
            float ratioR = fixedAvg[0] > 0 ? (float)blurryAvg[0] / (float)fixedAvg[0] : 0.0f;
            float ratioG = fixedAvg[1] > 0 ? (float)blurryAvg[1] / (float)fixedAvg[1] : 0.0f;
            float ratioB = fixedAvg[2] > 0 ? (float)blurryAvg[2] / (float)fixedAvg[2] : 0.0f;
            float bestRatio = GreyscaleFilter.component(ratioR, ratioG, ratioB);
            sortedRatios.put(avgOrig, Float.valueOf(bestRatio));
        }
        for (i = 0; i <= 31; ++i) {
            short rgb555 = this.toRGB555(i, i, i);
            float ratio = ((Float)sortedRatios.floorEntry(rgb555).getValue()).floatValue();
            this.LUT_g5[i] = this.LUT_b5[i] = (byte)((int)((float)i * ratio) & 0x1F);
            this.LUT_r5[i] = this.LUT_b5[i];
        }
    }

    public BlurryTable(int[][] liteColorMaps) {
        int i;
        this.LUT_b5 = null;
        this.LUT_g5 = null;
        this.LUT_r5 = null;
        this.LUT_a8 = new byte[256];
        this.LUT_b8 = new byte[256];
        this.LUT_g8 = new byte[256];
        this.LUT_r8 = new byte[256];
        this.LUT_idx = null;
        TreeMap<Integer, Float> sortedRatios = new TreeMap<Integer, Float>(this::CompareColors888);
        for (i = 0; i < 256; ++i) {
            int[] blurryColor = this.getRGB888(liteColorMaps[48][i], new int[3]);
            int[] fixedColor = this.getRGB888(liteColorMaps[0][i], new int[3]);
            int avgColor = GreyscaleFilter.grey888(blurryColor[0], blurryColor[1], blurryColor[2]);
            int avgOrig = GreyscaleFilter.grey888(fixedColor[0], fixedColor[1], fixedColor[2]);
            int[] blurryAvg = this.getRGB888(avgColor, new int[3]);
            int[] fixedAvg = this.getRGB888(avgOrig, new int[3]);
            float ratioR = fixedAvg[0] > 0 ? (float)blurryAvg[0] / (float)fixedAvg[0] : 0.0f;
            float ratioG = fixedAvg[1] > 0 ? (float)blurryAvg[1] / (float)fixedAvg[1] : 0.0f;
            float ratioB = fixedAvg[2] > 0 ? (float)blurryAvg[2] / (float)fixedAvg[2] : 0.0f;
            float bestRatio = GreyscaleFilter.component(ratioR, ratioG, ratioB);
            sortedRatios.put(avgOrig, Float.valueOf(bestRatio));
        }
        for (i = 0; i <= 255; ++i) {
            int rgb = this.toRGB888(i, i, i);
            float ratio = ((Float)sortedRatios.floorEntry(rgb).getValue()).floatValue();
            this.LUT_g8[i] = this.LUT_b8[i] = (byte)((int)((float)i * ratio) & 0xFF);
            this.LUT_r8[i] = this.LUT_b8[i];
            this.LUT_a8[i] = (byte)(ratio * ((float)Math.max(i, 127) / 255.0f) * 255.0f);
        }
    }

    public byte computePixel(byte pixel) {
        return this.LUT_idx[pixel & 0xFF];
    }

    public short computePixel(short pixel) {
        if (this.fuzzMix) {
            return this.fuzzMixHi(pixel);
        }
        int[] rgb = this.getRGB555(pixel, new int[4]);
        return this.toRGB555(this.LUT_r5[rgb[0]], this.LUT_g5[rgb[1]], this.LUT_b5[rgb[2]]);
    }

    public int computePixel(int pixel) {
        if (this.fuzzMix) {
            return this.fuzzMixTrue(pixel);
        }
        if (!this.semiTranslucent) {
            return this.computePixelFast(pixel);
        }
        int[] argb = this.getARGB8888(pixel, new int[4]);
        argb[0] = Math.min(argb[0], GreyscaleFilter.component(argb[1], argb[2], argb[3]));
        return this.toARGB8888(this.LUT_a8[argb[0]], this.LUT_r8[argb[1]], this.LUT_g8[argb[2]], this.LUT_b8[argb[3]]);
    }

    public int computePixelFast(int pixel) {
        if (this.fuzzMix) {
            return this.fuzzMixTrueLow(pixel);
        }
        int[] rgb = this.getRGB888(pixel, new int[3]);
        return -16777216 + (this.toRGB888(this.LUT_r8[rgb[0]], this.LUT_g8[rgb[1]], this.LUT_b8[rgb[2]]) & 0xFFFFFF);
    }
}

