/*
 * Decompiled with CFR 0.152.
 */
package w;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.List;
import m.Swap;
import w.IReadableDoomObject;
import w.IWritableDoomObject;

public class DoomIO {
    private DoomIO() {
    }

    public static void writeVector(DataOutputStream dos, float[] v) throws IOException {
        for (int n = 0; n < 3; ++n) {
            dos.writeFloat(v[n]);
        }
    }

    public static float[] readVector(DataInputStream dis) throws IOException {
        float[] res = new float[]{0.0f, 0.0f, 0.0f};
        for (int n = 0; n < 3; ++n) {
            res[n] = dis.readFloat();
        }
        return res;
    }

    public static final String readString(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        byte[] bb = new byte[len];
        dis.read(bb, 0, len);
        return new String(bb, 0, len, Charset.forName("ISO-8859-1"));
    }

    public static final String readString(DataInputStream dis, int len) throws IOException {
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        byte[] bb = new byte[len];
        dis.read(bb, 0, len);
        return new String(bb, 0, len);
    }

    public static String readString(InputStream f, int len) throws IOException {
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        byte[] bb = new byte[len];
        f.read(bb, 0, len);
        return new String(bb, 0, len, Charset.forName("ISO-8859-1"));
    }

    public static final String readNullTerminatedString(InputStream dis, int len) throws IOException {
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        byte[] bb = new byte[len];
        int terminator = len;
        dis.read(bb, 0, len);
        for (int i = 0; i < bb.length; ++i) {
            if (bb[i] != 0) continue;
            terminator = i;
            break;
        }
        return new String(bb, 0, terminator, Charset.forName("ISO-8859-1"));
    }

    public static final String[] readMultipleFixedLengthStrings(DataInputStream dis, String[] dest, int num, int len) throws IOException {
        if (num <= 0 || len < 0) {
            return null;
        }
        if (len == 0) {
            for (int i = 0; i < dest.length; ++i) {
                dest[i] = new String("");
            }
            return dest;
        }
        for (int i = 0; i < num; ++i) {
            dest[i] = DoomIO.readString(dis, len);
        }
        return dest;
    }

    public static void writeString(DataOutputStream dos, String s) {
        try {
            if (s == null) {
                dos.writeInt(-1);
                return;
            }
            dos.writeInt(s.length());
            if (s.length() != 0) {
                dos.writeBytes(s);
            }
        }
        catch (Exception e) {
            System.err.println("writeString " + s + " to DoomFile failed!");
        }
    }

    public static void writeString(DataOutputStream dos, String s, int len) throws IOException {
        if (s == null) {
            return;
        }
        if (s.length() != 0) {
            byte[] dest = s.getBytes("ISO-8859-1");
            dos.write(dest, 0, Math.min(len, dest.length));
            if (dest.length < len) {
                for (int i = 0; i < len - dest.length; ++i) {
                    dos.write(0);
                }
            }
        }
    }

    public static void readObjectArray(DataInputStream dis, IReadableDoomObject[] s, int len) throws IOException {
        if (s == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, s.length); ++i) {
            s[i].read(dis);
        }
    }

    public static void readObjectArrayWithReflection(DataInputStream dis, IReadableDoomObject[] s, int len) throws Exception {
        if (len == 0) {
            return;
        }
        Class<?> c = s.getClass().getComponentType();
        for (int i = 0; i < Math.min(len, s.length); ++i) {
            if (s[i] == null) {
                s[i] = (IReadableDoomObject)c.newInstance();
            }
            s[i].read(dis);
        }
    }

    public static void readObjectArray(DataInputStream dis, IReadableDoomObject[] s, int len, Class<?> c) throws Exception {
        if (s == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, s.length); ++i) {
            if (s[i] == null) {
                s[i] = (IReadableDoomObject)c.newInstance();
            }
            s[i].read(dis);
        }
    }

    public static final void readIntArray(DataInputStream dis, int[] s, int len, ByteOrder bo) throws IOException {
        if (s == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, s.length); ++i) {
            s[i] = dis.readInt();
            if (bo != ByteOrder.LITTLE_ENDIAN) continue;
            s[i] = Swap.LONG(s[i]);
        }
    }

    public static final void readShortArray(DataInputStream dis, short[] s, int len, ByteOrder bo) throws IOException {
        if (s == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, s.length); ++i) {
            s[i] = dis.readShort();
            if (bo != ByteOrder.LITTLE_ENDIAN) continue;
            s[i] = Swap.SHORT(s[i]);
        }
    }

    public static final void readIntArray(DataInputStream dis, int[] s, ByteOrder bo) throws IOException {
        DoomIO.readIntArray(dis, s, s.length, bo);
    }

    public static final void readShortArray(DataInputStream dis, short[] s, ByteOrder bo) throws IOException {
        DoomIO.readShortArray(dis, s, s.length, bo);
    }

    public static void readBooleanArray(DataInputStream dis, boolean[] s, int len) throws IOException {
        if (s == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, s.length); ++i) {
            s[i] = dis.readBoolean();
        }
    }

    public static final void readBooleanIntArray(DataInputStream dis, boolean[] s, int len) throws IOException {
        if (s == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, s.length); ++i) {
            s[i] = DoomIO.readIntBoolean(dis);
        }
    }

    public static final void readBooleanIntArray(DataInputStream dis, boolean[] s) throws IOException {
        DoomIO.readBooleanIntArray(dis, s, s.length);
    }

    public static final void writeBoolean(DataOutputStream dos, boolean[] s, int len) throws IOException {
        if (s == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, s.length); ++i) {
            dos.writeBoolean(s[i]);
        }
    }

    public static final void writeObjectArray(DataOutputStream dos, IWritableDoomObject[] s, int len) throws IOException {
        if (s == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, s.length); ++i) {
            s[i].write(dos);
        }
    }

    public static final void writeListOfObjects(DataOutputStream dos, List<IWritableDoomObject> s, int len) throws IOException {
        if (s == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, s.size()); ++i) {
            s.get(i).write(dos);
        }
    }

    public static final void readBooleanArray(DataInputStream dis, boolean[] s) throws IOException {
        DoomIO.readBooleanArray(dis, s, s.length);
    }

    public static final void readIntBooleanArray(DataInputStream dis, boolean[] s) throws IOException {
        DoomIO.readBooleanIntArray(dis, s, s.length);
    }

    public static final void writeCharArray(DataOutputStream dos, char[] charr, int len) throws IOException {
        if (charr == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, charr.length); ++i) {
            dos.writeChar(charr[i]);
        }
    }

    public static final void readCharArray(DataInputStream dis, char[] charr, int len) throws IOException {
        if (charr == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, charr.length); ++i) {
            charr[i] = dis.readChar();
        }
    }

    public static final void readNonUnicodeCharArray(DataInputStream dis, char[] charr, int len) throws IOException {
        if (charr == null || len == 0) {
            return;
        }
        for (int i = 0; i < Math.min(len, charr.length); ++i) {
            charr[i] = (char)dis.readUnsignedByte();
        }
    }

    public static final long readUnsignedLEInt(DataInputStream dis) throws IOException {
        int tmp = dis.readInt();
        return 0xFFFFFFFFL & (long)Swap.LONG(tmp);
    }

    public static final int readLEInt(DataInputStream dis) throws IOException {
        int tmp = dis.readInt();
        return Swap.LONG(tmp);
    }

    public static final int readLEInt(InputStream dis) throws IOException {
        int tmp = new DataInputStream(dis).readInt();
        return Swap.LONG(tmp);
    }

    public static final void writeLEInt(DataOutputStream dos, int value) throws IOException {
        dos.writeInt(Swap.LONG(value));
    }

    public static int SHORT_little_endian_TO_big_endian(int i) {
        return (i >> 8 & 0xFF) + (i << 8 & 0xFF00);
    }

    public static int INT_little_endian_TO_big_endian(int i) {
        return ((i & 0xFF) << 24) + ((i & 0xFF00) << 8) + ((i & 0xFF0000) >> 8) + (i >> 24 & 0xFF);
    }

    public static final short readLEShort(DataInputStream dis) throws IOException {
        short tmp = dis.readShort();
        return Swap.SHORT(tmp);
    }

    public static final boolean readIntBoolean(DataInputStream dis) throws IOException {
        return dis.readInt() != 0;
    }
}

