/*
 * Decompiled with CFR 0.152.
 */
package w;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import utils.C2JUtils;

public class InputStreamSugar {
    public static final int UNKNOWN_TYPE = 0;
    public static final int FILE = 1;
    public static final int NETWORK_FILE = 2;
    public static final int ZIP_FILE = 4;
    public static final int BAD_URI = -1;

    public static final InputStream createInputStreamFromURI(String resource, ZipEntry entry, int type) {
        InputStream is = null;
        if (entry == null || !C2JUtils.flags(type, 4)) {
            is = InputStreamSugar.getDirectInputStream(resource);
        } else if (entry != null && C2JUtils.flags(type, 4)) {
            ZipInputStream zis;
            try {
                URL u = new URL(resource);
                zis = new ZipInputStream(u.openStream());
            }
            catch (Exception e) {
                try {
                    zis = new ZipInputStream(new FileInputStream(resource));
                }
                catch (Exception e1) {
                    is = InputStreamSugar.getDirectInputStream(resource);
                    return is;
                }
            }
            is = InputStreamSugar.getZipEntryStream(zis, entry.getName());
            if (is != null) {
                return is;
            }
        }
        return InputStreamSugar.getDirectInputStream(resource);
    }

    private static InputStream getZipEntryStream(ZipInputStream zis, String entryname) {
        ZipEntry ze = null;
        try {
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.isDirectory() || !ze.getName().equals(entryname)) continue;
                return zis;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    private static final InputStream getDirectInputStream(String resource) {
        InputStream is = null;
        try {
            URL u = new URL(resource);
            is = u.openStream();
        }
        catch (Exception e) {
            try {
                is = new FileInputStream(resource);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return is;
    }

    public static final InputStream streamSeek(InputStream is, long pos, long size, String URI2, ZipEntry entry, int type) throws IOException {
        if (is == null) {
            return is;
        }
        if (size > 0L) {
            try {
                long available = is.available();
                long guesspos = size - available;
                if (guesspos > 0L && guesspos <= pos) {
                    long mustskip = pos - guesspos;
                    for (long skipped = 0L; skipped < mustskip; skipped += is.skip(mustskip - skipped)) {
                    }
                    return is;
                }
            }
            catch (Exception available) {
                // empty catch block
            }
        }
        if (is instanceof FileInputStream) {
            try {
                ((FileInputStream)is).getChannel().position(pos);
                return is;
            }
            catch (IOException e) {
                is.close();
                is = InputStreamSugar.createInputStreamFromURI(URI2, null, 1);
                is.skip(pos);
                return is;
            }
        }
        if (is instanceof ZipInputStream) {
            is.close();
            is = InputStreamSugar.createInputStreamFromURI(URI2, entry, type);
            is.skip(pos);
            return is;
        }
        try {
            URL u = new URL(URI2);
            InputStream nis = u.openStream();
            nis.skip(pos);
            is.close();
            return nis;
        }
        catch (Exception exception) {
            return is;
        }
    }

    public static List<ZipEntry> getAllEntries(ZipInputStream zis) throws IOException {
        ZipEntry z;
        ArrayList<ZipEntry> zes = new ArrayList<ZipEntry>();
        while ((z = zis.getNextEntry()) != null) {
            zes.add(z);
        }
        return zes;
    }

    public static long getSizeEstimate(InputStream is, ZipEntry z) {
        if (is instanceof FileInputStream) {
            try {
                return ((FileInputStream)is).getChannel().size();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (is instanceof FileInputStream && z != null) {
            return z.getSize();
        }
        try {
            return is.available();
        }
        catch (IOException e) {
            try {
                return is.available();
            }
            catch (IOException e1) {
                return -1L;
            }
        }
    }
}

