/*
 * Decompiled with CFR 0.152.
 */
package w;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import w.DoomIO;
import w.IReadableDoomObject;
import w.IWritableDoomObject;

public class filelump_t
implements IReadableDoomObject,
IWritableDoomObject {
    public long filepos;
    public long size;
    public String name;
    public String actualname;
    public boolean big_endian = false;
    public boolean compressed = false;

    @Override
    public void read(DataInputStream f) throws IOException {
        if (!this.big_endian) {
            this.filepos = DoomIO.readUnsignedLEInt(f);
            this.size = DoomIO.readUnsignedLEInt(f);
        } else {
            this.filepos = f.readInt();
            this.size = f.readInt();
        }
        this.name = DoomIO.readNullTerminatedString(f, 8);
        char[] stuff = this.name.toCharArray();
        if (stuff[0] > '\u007f') {
            this.compressed = true;
            stuff[0] = (char)(stuff[0] & 0x7F);
        }
        this.actualname = new String(stuff).toUpperCase();
    }

    public static int sizeof() {
        return 16;
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        if (!this.big_endian) {
            DoomIO.writeLEInt(dos, (int)this.filepos);
            DoomIO.writeLEInt(dos, (int)this.size);
        } else {
            dos.writeInt((int)this.filepos);
            dos.writeInt((int)this.size);
        }
        DoomIO.writeString(dos, this.name, 8);
    }
}

