/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import net.sf.snmpadaptor4j.SnmpAdaptorMBean;
import net.sf.snmpadaptor4j.SnmpAppContext;
import net.sf.snmpadaptor4j.SnmpConfiguration;
import net.sf.snmpadaptor4j.SnmpManagerConfiguration;
import net.sf.snmpadaptor4j.api.SnmpDaemon;
import net.sf.snmpadaptor4j.api.opennms.OpennmsSnmpApiFactory;
import net.sf.snmpadaptor4j.config.XmlConfigParser;
import net.sf.snmpadaptor4j.core.JmxListener;
import net.sf.snmpadaptor4j.core.JmxNotificationManager;
import net.sf.snmpadaptor4j.core.JmxSnmpMib;
import net.sf.snmpadaptor4j.core.JvmSnmpMib;
import net.sf.snmpadaptor4j.core.SystemSnmpMib;
import net.sf.snmpadaptor4j.core.trap.SnmpManagers;
import net.sf.snmpadaptor4j.mbean.SystemInfo;
import org.apache.log4j.Logger;

public class SnmpAdaptor
extends StandardMBean
implements SnmpConfiguration,
SnmpAppContext,
SnmpAdaptorMBean {
    private final Logger logger = Logger.getLogger(SnmpAdaptor.class);
    private final SnmpDaemon daemon;
    private final SystemInfo systemInfo;
    private String listenerAddress = null;
    private Integer listenerPort = null;
    private Integer listenerSnmpVersion = null;
    private String listenerReadCommunity = null;
    private String listenerWriteCommunity = null;
    private final List<SnmpManagerConfiguration> managerList = new ArrayList<SnmpManagerConfiguration>();
    private final String defaultRootOid;
    private final Map<String, String> rootOidMap;
    private final Map<ObjectName, String> mBeanOidMap;
    protected final Map<ClassLoader, SnmpAppContext> appContextMap = new HashMap<ClassLoader, SnmpAppContext>();
    private final SnmpManagers snmpManagers;
    private final SystemSnmpMib systemMib;
    private final JvmSnmpMib jvmMib;
    private final JmxNotificationManager jmxNotificationManager;
    private final JmxListener jmxListener;

    public SnmpAdaptor(boolean classLoaderScope) throws Exception {
        this(null, null, null, classLoaderScope);
    }

    public SnmpAdaptor(SnmpAppContext appContext, boolean classLoaderScope) throws Exception {
        this(null, appContext, null, classLoaderScope);
    }

    public SnmpAdaptor(URL url, boolean classLoaderScope) throws Exception {
        this(url, (SystemInfo)null, classLoaderScope);
    }

    public SnmpAdaptor(URL url, SystemInfo systemInfo, boolean classLoaderScope) throws Exception {
        this(XmlConfigParser.newInstance(url), systemInfo, classLoaderScope);
    }

    private SnmpAdaptor(XmlConfigParser xmlConfigParser, SystemInfo systemInfo, boolean classLoaderScope) throws Exception {
        this(xmlConfigParser, xmlConfigParser, systemInfo, classLoaderScope);
    }

    public SnmpAdaptor(SnmpConfiguration configuration, SnmpAppContext appContext, SystemInfo systemInfo, boolean classLoaderScope) throws Exception {
        super(SnmpAdaptorMBean.class);
        this.initializeMBeanDescriptions();
        this.defaultRootOid = appContext != null && appContext.getDefaultRootOid() != null ? appContext.getDefaultRootOid() : "1.3.6.1.4.1.99.12.8.1";
        this.rootOidMap = Collections.unmodifiableMap(appContext != null ? appContext.getRootOidMap() : new HashMap());
        this.mBeanOidMap = Collections.unmodifiableMap(appContext != null ? appContext.getMBeanOidMap() : new HashMap());
        this.systemInfo = systemInfo != null ? systemInfo : new SystemInfo();
        this.systemMib = new SystemSnmpMib(this, this.appContextMap, this.systemInfo);
        this.jvmMib = new JvmSnmpMib(this.systemMib);
        JmxSnmpMib jmxSnmpMib = new JmxSnmpMib(this.jvmMib);
        OpennmsSnmpApiFactory apiFactory = new OpennmsSnmpApiFactory();
        this.snmpManagers = new SnmpManagers(apiFactory);
        this.jmxNotificationManager = new JmxNotificationManager(this.snmpManagers, this.systemInfo);
        this.jmxListener = new JmxListener(jmxSnmpMib, this.jmxNotificationManager, this, this.appContextMap, classLoaderScope);
        this.daemon = apiFactory.newSnmpDaemon(this, jmxSnmpMib);
        this.setListenerAddress(configuration != null ? configuration.getListenerAddress() : null);
        this.setListenerPort(configuration != null ? configuration.getListenerPort() : null);
        this.setListenerSnmpVersion(configuration != null ? configuration.getListenerSnmpVersion() : null);
        this.setListenerReadCommunity(configuration != null ? configuration.getListenerReadCommunity() : null);
        this.setListenerWriteCommunity(configuration != null ? configuration.getListenerWriteCommunity() : null);
        if (configuration != null && configuration.getManagerList() != null) {
            this.managerList.addAll(configuration.getManagerList());
            this.snmpManagers.initialize(this.managerList);
        }
    }

    protected SnmpAdaptor(String defaultRootOid, SnmpConfiguration configuration, boolean classLoaderScope, SystemSnmpMib systemMib, JvmSnmpMib jvmMib, JmxListener jmxListener, JmxNotificationManager jmxNotificationManager, SnmpDaemon daemon) throws Exception {
        super(SnmpAdaptorMBean.class);
        this.initializeMBeanDescriptions();
        this.defaultRootOid = defaultRootOid;
        this.rootOidMap = Collections.unmodifiableMap(new HashMap());
        this.mBeanOidMap = Collections.unmodifiableMap(new HashMap());
        this.systemInfo = new SystemInfo();
        this.systemMib = systemMib;
        this.jvmMib = jvmMib;
        this.snmpManagers = null;
        this.jmxNotificationManager = jmxNotificationManager;
        this.jmxListener = jmxListener;
        this.daemon = daemon;
        this.setListenerAddress(configuration != null ? configuration.getListenerAddress() : null);
        this.setListenerPort(configuration != null ? configuration.getListenerPort() : null);
        this.setListenerSnmpVersion(configuration != null ? configuration.getListenerSnmpVersion() : null);
        this.setListenerReadCommunity(configuration != null ? configuration.getListenerReadCommunity() : null);
        this.setListenerWriteCommunity(configuration != null ? configuration.getListenerWriteCommunity() : null);
        if (configuration != null && configuration.getManagerList() != null) {
            this.managerList.addAll(configuration.getManagerList());
        }
    }

    private void initializeMBeanDescriptions() {
        String classDescription = "JMX adaptor for SNMP protocol";
        String listenerAddressAttributeDescription = "Listening IP address of SNMP daemon";
        String listenerPortAttributeDescription = "Listening UDP port of SNMP daemon";
        String listenerSnmpVersionAttributeDescription = "Protocol version of SNMP daemon (1 or 2)";
        String listenerReadCommunityAttributeDescription = "Read community of SNMP daemon";
        String listenerWriteCommunityAttributeDescription = "Write community of SNMP daemon";
        String managerListAttributeDescription = "List of managers where to send all notifications (SNMP traps)";
        String startedAttributeDescription = "TRUE if the SNMP daemon is started";
        String addAppContextDescription = "Adds a new application context";
        String removeAppContextDescription = "Removes an application context";
        String startDescription = "Starts the SNMP daemon";
        String stopDescription = "Stops the SNMP daemon";
        String classLoaderParameterDescription = "Class loader of application";
        String appContextParameterDescription = "Application context (any class that implements the interface " + SnmpAppContext.class.getName() + ")";
        String urlParameterDescription = "URL of SNMP configuration file (XML)";
        String configurationParameterDescription = "SNMP configuration settings (any class that implements the interface " + SnmpConfiguration.class.getName() + ")";
        String systemInfoParameterDescription = "Informations on the Java application";
        String classLoaderScopeParameterDescription = "TRUE for handle only MBeans created by the same ClassLoader that the SNMP adapter - FALSE for handle all MBeans of the JVM (set TRUE to classLoaderScope for web applications: this avoids to publish MBeans of other applications of application server)";
        MBeanParameterInfo classLoaderParameter = new MBeanParameterInfo("classLoader", ClassLoader.class.getName(), "Class loader of application");
        MBeanParameterInfo appContextParameter = new MBeanParameterInfo("appContext", SnmpAppContext.class.getName(), appContextParameterDescription);
        MBeanParameterInfo urlParameter = new MBeanParameterInfo("url", URL.class.getName(), "URL of SNMP configuration file (XML)");
        MBeanParameterInfo configurationParameter = new MBeanParameterInfo("configuration", SnmpConfiguration.class.getName(), configurationParameterDescription);
        MBeanParameterInfo systemInfoParameter = new MBeanParameterInfo("systemInfo", SystemInfo.class.getName(), "Informations on the Java application");
        MBeanParameterInfo classLoaderScopeParameter = new MBeanParameterInfo("classLoaderScope", Boolean.TYPE.getName(), "TRUE for handle only MBeans created by the same ClassLoader that the SNMP adapter - FALSE for handle all MBeans of the JVM (set TRUE to classLoaderScope for web applications: this avoids to publish MBeans of other applications of application server)");
        MBeanOperationInfo addAppContextOperation = new MBeanOperationInfo("addAppContext", "Adds a new application context", new MBeanParameterInfo[]{classLoaderParameter, appContextParameter}, Void.TYPE.getName(), 1);
        MBeanOperationInfo removeAppContextOperation = new MBeanOperationInfo("removeAppContext", "Removes an application context", new MBeanParameterInfo[]{classLoaderParameter}, Void.TYPE.getName(), 1);
        MBeanOperationInfo startOperation = new MBeanOperationInfo("start", "Starts the SNMP daemon", new MBeanParameterInfo[0], Void.TYPE.getName(), 1);
        MBeanOperationInfo stopOperation = new MBeanOperationInfo("stop", "Stops the SNMP daemon", new MBeanParameterInfo[0], Void.TYPE.getName(), 1);
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{addAppContextOperation, removeAppContextOperation, startOperation, stopOperation};
        MBeanConstructorInfo constructor1 = new MBeanConstructorInfo(this.getClass().getName(), "Constructor with only classLoaderScope parameter", new MBeanParameterInfo[]{classLoaderScopeParameter});
        MBeanConstructorInfo constructor2 = new MBeanConstructorInfo(this.getClass().getName(), "Constructor with only appContext and classLoaderScope parameters", new MBeanParameterInfo[]{appContextParameter, classLoaderScopeParameter});
        MBeanConstructorInfo constructor3 = new MBeanConstructorInfo(this.getClass().getName(), "Constructor with only url and classLoaderScope parameters", new MBeanParameterInfo[]{urlParameter, classLoaderScopeParameter});
        MBeanConstructorInfo constructor4 = new MBeanConstructorInfo(this.getClass().getName(), "Constructor with only url, systemInfo and classLoaderScope parameters", new MBeanParameterInfo[]{urlParameter, systemInfoParameter, classLoaderScopeParameter});
        MBeanConstructorInfo constructor5 = new MBeanConstructorInfo(this.getClass().getName(), "Constructor with configuration, appContext, systemInfo and classLoaderScope parameters", new MBeanParameterInfo[]{configurationParameter, appContextParameter, systemInfoParameter, classLoaderScopeParameter});
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{constructor1, constructor2, constructor3, constructor4, constructor5};
        MBeanAttributeInfo listenerAddressAttribute = new MBeanAttributeInfo("ListenerAddress", String.class.getName(), "Listening IP address of SNMP daemon", true, true, false);
        MBeanAttributeInfo listenerPortAttribute = new MBeanAttributeInfo("ListenerPort", Integer.class.getName(), "Listening UDP port of SNMP daemon", true, true, false);
        MBeanAttributeInfo listenerSnmpVersionAttribute = new MBeanAttributeInfo("ListenerSnmpVersion", Integer.class.getName(), "Protocol version of SNMP daemon (1 or 2)", true, true, false);
        MBeanAttributeInfo listenerReadCommunityAttribute = new MBeanAttributeInfo("ListenerReadCommunity", String.class.getName(), "Read community of SNMP daemon", true, true, false);
        MBeanAttributeInfo listenerWriteCommunityAttribute = new MBeanAttributeInfo("ListenerWriteCommunity", String.class.getName(), "Write community of SNMP daemon", true, true, false);
        MBeanAttributeInfo managerListAttribute = new MBeanAttributeInfo("ManagerList", List.class.getName(), "List of managers where to send all notifications (SNMP traps)", true, true, false);
        MBeanAttributeInfo startedAttribute = new MBeanAttributeInfo("Started", Boolean.TYPE.getName(), "TRUE if the SNMP daemon is started", true, false, true);
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{listenerAddressAttribute, listenerPortAttribute, listenerSnmpVersionAttribute, listenerReadCommunityAttribute, listenerWriteCommunityAttribute, managerListAttribute, startedAttribute};
        MBeanInfo mBeanInfo = new MBeanInfo(this.getClass().getName(), "JMX adaptor for SNMP protocol", attributes, constructors, operations, new MBeanNotificationInfo[0], this.getMBeanInfo().getDescriptor());
        this.cacheMBeanInfo(mBeanInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppContext(ClassLoader classLoader, SnmpAppContext appContext) {
        Map<ClassLoader, SnmpAppContext> map = this.appContextMap;
        synchronized (map) {
            this.appContextMap.put(classLoader, appContext);
            this.systemMib.initSysObjectIDSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAppContext(ClassLoader classLoader) {
        Map<ClassLoader, SnmpAppContext> map = this.appContextMap;
        synchronized (map) {
            this.appContextMap.remove(classLoader);
            this.systemMib.initSysObjectIDSet();
        }
    }

    @Override
    public final String getListenerAddress() {
        return this.listenerAddress;
    }

    @Override
    public final void setListenerAddress(String listenerAddress) {
        String newListenerAddress = SnmpAdaptor.formatAttribute(listenerAddress);
        if (newListenerAddress == null) {
            newListenerAddress = "localhost";
        }
        if (this.listenerAddress == null || !this.listenerAddress.equals(newListenerAddress)) {
            try {
                this.daemon.stop();
                this.jmxNotificationManager.setEnabled(false);
                this.listenerAddress = newListenerAddress;
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        }
    }

    @Override
    public final Integer getListenerPort() {
        return this.listenerPort;
    }

    @Override
    public final void setListenerPort(Integer listenerPort) {
        Integer newListenerPort;
        Integer n = newListenerPort = listenerPort != null ? listenerPort : new Integer(161);
        if (this.listenerPort == null || !this.listenerPort.equals(newListenerPort)) {
            try {
                this.daemon.stop();
                this.jmxNotificationManager.setEnabled(false);
                this.listenerPort = newListenerPort;
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        }
    }

    @Override
    public final Integer getListenerSnmpVersion() {
        return this.listenerSnmpVersion;
    }

    @Override
    public final void setListenerSnmpVersion(Integer listenerSnmpVersion) {
        Integer newListenerSnmpVersion = listenerSnmpVersion == null || listenerSnmpVersion < 1 || listenerSnmpVersion > 2 ? new Integer(2) : listenerSnmpVersion;
        if (this.listenerSnmpVersion == null || !this.listenerSnmpVersion.equals(newListenerSnmpVersion)) {
            try {
                this.daemon.stop();
                this.jmxNotificationManager.setEnabled(false);
                this.listenerSnmpVersion = newListenerSnmpVersion;
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        }
    }

    @Override
    public final String getListenerReadCommunity() {
        return this.listenerReadCommunity;
    }

    @Override
    public final void setListenerReadCommunity(String listenerReadCommunity) {
        String newListenerReadCommunity = SnmpAdaptor.formatAttribute(listenerReadCommunity);
        if (newListenerReadCommunity == null) {
            newListenerReadCommunity = "public";
        }
        if (this.listenerReadCommunity == null || !this.listenerReadCommunity.equals(newListenerReadCommunity)) {
            try {
                this.daemon.stop();
                this.jmxNotificationManager.setEnabled(false);
                this.listenerReadCommunity = newListenerReadCommunity;
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        }
    }

    @Override
    public final String getListenerWriteCommunity() {
        return this.listenerWriteCommunity;
    }

    @Override
    public final void setListenerWriteCommunity(String listenerWriteCommunity) {
        String newListenerWriteCommunity = SnmpAdaptor.formatAttribute(listenerWriteCommunity);
        if (newListenerWriteCommunity == null) {
            newListenerWriteCommunity = "private";
        }
        if (this.listenerWriteCommunity == null || !this.listenerWriteCommunity.equals(newListenerWriteCommunity)) {
            try {
                this.daemon.stop();
                this.jmxNotificationManager.setEnabled(false);
                this.listenerWriteCommunity = newListenerWriteCommunity;
            }
            catch (Throwable e) {
                this.logger.error((Object)e);
            }
        }
    }

    @Override
    public final List<SnmpManagerConfiguration> getManagerList() {
        return Collections.unmodifiableList(this.managerList);
    }

    @Override
    public final String getDefaultRootOid() {
        return this.defaultRootOid;
    }

    @Override
    public final Map<String, String> getRootOidMap() {
        return this.rootOidMap;
    }

    @Override
    public final Map<ObjectName, String> getMBeanOidMap() {
        return this.mBeanOidMap;
    }

    @Override
    public void start() throws Exception {
        this.daemon.start();
        if (!this.daemon.isStarted()) {
            throw new Exception("The SNMP daemon did not start");
        }
        this.jmxNotificationManager.setEnabled(true);
    }

    @Override
    public void stop() throws Exception {
        this.daemon.stop();
        if (this.daemon.isStarted()) {
            throw new Exception("The SNMP daemon has not been stopped");
        }
        this.jmxNotificationManager.setEnabled(false);
    }

    @Override
    public final boolean isStarted() {
        return this.daemon.isStarted();
    }

    public final SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    protected static final String formatAttribute(String value) {
        String result = value;
        if (result != null && (result = result.trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        ObjectName result = super.preRegister(server, name);
        this.jmxListener.open(server);
        this.jvmMib.open(server);
        return result;
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        this.jmxListener.close();
        this.jvmMib.close();
    }

    public String toString() {
        return "SnmpAdaptor[" + this.listenerAddress + ":" + this.listenerPort + "]";
    }
}

