/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core.trap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import net.sf.snmpadaptor4j.core.mapping.DataMapTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.GenericSnmpTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.MapDataMapTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.SimpleDataMapTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.SnmpTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.SpecificSnmpTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.UserDataEntryDataMapTrapMapping;
import net.sf.snmpadaptor4j.mbean.SystemInfo;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;
import net.sf.snmpadaptor4j.object.SnmpTrap;
import net.sf.snmpadaptor4j.object.SnmpTrapData;

public class SnmpTrapBuilder
implements Serializable {
    private static final long serialVersionUID = -4410423782282390100L;
    private final Map<String, SnmpTrapMapping> mappingMap;
    private final SystemInfo systemInfo;

    public SnmpTrapBuilder(Map<String, SnmpTrapMapping> mappingMap, SystemInfo systemInfo) {
        this.mappingMap = mappingMap;
        this.systemInfo = systemInfo;
    }

    public Map<String, SnmpTrapMapping> getMappingMap() {
        return this.mappingMap;
    }

    public SnmpTrap newTrap(Notification notification) {
        SnmpTrap trap = null;
        SnmpTrapMapping mapping = this.mappingMap.get(notification.getType());
        if (mapping instanceof GenericSnmpTrapMapping) {
            Map<SnmpOid, SnmpTrapData> dataMap = this.newDataMap(mapping.getDataMap(), notification);
            trap = SnmpTrap.newInstance(notification.getTimeStamp() / 10L, mapping.getSource(), ((GenericSnmpTrapMapping)mapping).getType(), dataMap);
        } else if (mapping instanceof SpecificSnmpTrapMapping) {
            Map<SnmpOid, SnmpTrapData> dataMap = this.newDataMap(mapping.getDataMap(), notification);
            trap = SnmpTrap.newInstance(notification.getTimeStamp() / 10L, mapping.getSource(), ((SpecificSnmpTrapMapping)mapping).getType(), dataMap);
        }
        return trap;
    }

    protected final Map<SnmpOid, SnmpTrapData> newDataMap(DataMapTrapMapping mapping, Notification notification) {
        HashMap<SnmpOid, SnmpTrapData> dataMap = new HashMap<SnmpOid, SnmpTrapData>();
        if (mapping.getSequenceNumberOid() != null) {
            dataMap.put(mapping.getSequenceNumberOid(), new SnmpTrapData(SnmpDataType.unsigned32, new Long(notification.getSequenceNumber())));
        }
        if (mapping.getMessageOid() != null) {
            dataMap.put(mapping.getMessageOid(), new SnmpTrapData(SnmpDataType.octetString, notification.getMessage()));
        }
        if (mapping.isHasSystemInfo() && this.systemInfo != null) {
            dataMap.put(SnmpOid.SYSNAME_OID, new SnmpTrapData(SnmpDataType.octetString, this.systemInfo.getSysName()));
            dataMap.put(SnmpOid.SYSDESCR_OID, new SnmpTrapData(SnmpDataType.octetString, this.systemInfo.getSysDescr()));
            dataMap.put(SnmpOid.SYSLOCATION_OID, new SnmpTrapData(SnmpDataType.octetString, this.systemInfo.getSysLocation()));
            dataMap.put(SnmpOid.SYSCONTACT_OID, new SnmpTrapData(SnmpDataType.octetString, this.systemInfo.getSysContact()));
        }
        if (mapping instanceof SimpleDataMapTrapMapping) {
            SimpleDataMapTrapMapping simpleMapping = (SimpleDataMapTrapMapping)mapping;
            if (notification.getUserData() instanceof Map) {
                throw new RuntimeException("UserData field of notification \"" + notification.getType() + "\" contains map - see mapping file of MBean");
            }
            dataMap.put(simpleMapping.getUserDataOid(), new SnmpTrapData(simpleMapping.getUserDataType(), notification.getUserData()));
        } else if (mapping instanceof MapDataMapTrapMapping && notification.getUserData() != null) {
            MapDataMapTrapMapping mapMapping = (MapDataMapTrapMapping)mapping;
            if (!(notification.getUserData() instanceof Map)) {
                throw new RuntimeException("UserData field of notification \"" + notification.getType() + "\" doesn't contain map - see mapping file of MBean");
            }
            Map userDataMap = (Map)notification.getUserData();
            for (UserDataEntryDataMapTrapMapping userDataEntry : mapMapping.getUserDataEntryList()) {
                if (!userDataMap.containsKey(userDataEntry.getKey())) continue;
                dataMap.put(userDataEntry.getOid(), new SnmpTrapData(userDataEntry.getType(), userDataMap.get(userDataEntry.getKey())));
            }
        }
        return dataMap;
    }

    public final String toString() {
        return "SnmpTrapBuilder:" + this.mappingMap;
    }
}

