/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.object;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.snmpadaptor4j.object.GenericSnmpTrap;
import net.sf.snmpadaptor4j.object.GenericSnmpTrapType;
import net.sf.snmpadaptor4j.object.SnmpOid;
import net.sf.snmpadaptor4j.object.SnmpTrapData;
import net.sf.snmpadaptor4j.object.SpecificSnmpTrap;
import org.apache.log4j.Logger;

public abstract class SnmpTrap
implements Serializable {
    private static final long serialVersionUID = -2950288105650647983L;
    private final long timeStamp;
    private final SnmpOid source;
    private final Map<SnmpOid, SnmpTrapData> dataMap;

    public static SpecificSnmpTrap newInstance(long timeStamp, SnmpOid source, int type, Map<SnmpOid, SnmpTrapData> dataMap) {
        return new SpecificSnmpTrap(timeStamp, source, type, dataMap);
    }

    public static GenericSnmpTrap newInstance(long timeStamp, SnmpOid source, GenericSnmpTrapType type, Map<SnmpOid, SnmpTrapData> dataMap) {
        return new GenericSnmpTrap(timeStamp, source, type, dataMap);
    }

    protected SnmpTrap(long timeStamp, SnmpOid source, Map<SnmpOid, SnmpTrapData> dataMap) {
        this.timeStamp = timeStamp;
        this.source = source;
        this.dataMap = Collections.unmodifiableMap(dataMap != null ? dataMap : new HashMap());
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    public final SnmpOid getSource() {
        return this.source;
    }

    public final Map<SnmpOid, SnmpTrapData> getDataMap() {
        return this.dataMap;
    }

    public abstract void traceTo(Logger var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dataMap.hashCode();
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && this.getClass().equals(obj.getClass())) {
            SnmpTrap other = (SnmpTrap)obj;
            boolean bl = result = this.timeStamp == other.timeStamp;
            if (result) {
                boolean bl2 = this.source != null ? this.source.equals(other.source) : (result = other.source == null);
            }
            if (result) {
                result = this.dataMap.equals(other.dataMap);
            }
        }
        return result;
    }
}

