/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.api;

import org.apache.log4j.Level;

public final class SnmpException
extends RuntimeException {
    private static final long serialVersionUID = -5077386573357989009L;
    private final int errorStatus;
    private final Level loggerLevel;

    public SnmpException(int errorStatus) {
        this(null, errorStatus, (Level)null);
    }

    public SnmpException(String message, int errorStatus, Throwable cause) {
        super("error " + errorStatus + " (" + message + ")", cause);
        this.errorStatus = errorStatus;
        this.loggerLevel = Level.ERROR;
    }

    public SnmpException(String message, int errorStatus) {
        this(message, errorStatus, (Level)null);
    }

    public SnmpException(String message, int errorStatus, Level loggerLevel) {
        super("error " + errorStatus + (message != null ? " (" + message + ")" : ""));
        this.errorStatus = errorStatus;
        this.loggerLevel = loggerLevel != null ? loggerLevel : Level.ERROR;
    }

    public int getErrorStatus() {
        return this.errorStatus;
    }

    public Level getLoggerLevel() {
        return this.loggerLevel;
    }
}

