/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.api.opennms;

import java.net.InetAddress;
import java.util.Map;
import net.sf.snmpadaptor4j.api.SnmpTrapSender;
import net.sf.snmpadaptor4j.api.opennms.OpennmsSupport;
import net.sf.snmpadaptor4j.object.GenericSnmpTrap;
import net.sf.snmpadaptor4j.object.GenericSnmpTrapType;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;
import net.sf.snmpadaptor4j.object.SnmpTrap;
import net.sf.snmpadaptor4j.object.SnmpTrapData;
import net.sf.snmpadaptor4j.object.SpecificSnmpTrap;
import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public final class OpennmsSnmpTrapSender
extends OpennmsSupport
implements SnmpTrapSender {
    private static final SnmpObjectId TIME_STAMP_OID = new SnmpObjectId("1.3.6.1.2.1.1.3.0");
    private static final SnmpObjectId TYPE_OID = new SnmpObjectId("1.3.6.1.6.3.1.1.4.1.0");
    private static final SnmpObjectId AGENT_ADDRESS_OID = new SnmpObjectId("1.3.6.1.6.3.18.1.3.0");
    private static final SnmpObjectId COMMUNITY_OID = new SnmpObjectId("1.3.6.1.6.3.18.1.4.0");
    private static final SnmpObjectId ENTERPRISE_OID = new SnmpObjectId("1.3.6.1.6.3.1.1.4.3.0");
    private static final SnmpOid GENERIC_COLD_START_TYPE_VALUE = SnmpOid.newInstance("1.3.6.1.6.3.1.1.5.1");
    private static final SnmpOid GENERIC_WARM_START_TYPE_VALUE = SnmpOid.newInstance("1.3.6.1.6.3.1.1.5.2");
    private static final SnmpOid GENERIC_LINK_DOWN_TYPE_VALUE = SnmpOid.newInstance("1.3.6.1.6.3.1.1.5.3");
    private static final SnmpOid GENERIC_LINK_UP_TYPE_VALUE = SnmpOid.newInstance("1.3.6.1.6.3.1.1.5.4");
    private static final SnmpOid GENERIC_AUTHENTICATION_FAILURE_TYPE_VALUE = SnmpOid.newInstance("1.3.6.1.6.3.1.1.5.5");
    private static final SnmpOid GENERIC_EGP_NEIGHBOR_LOSS_TYPE_VALUE = SnmpOid.newInstance("1.3.6.1.6.3.1.1.5.6");
    private final SnmpIPAddress agentAddress;
    private final String managerAddress;
    private final int managerPort;
    private final int managerVersion;
    private final String managerCommunity;
    private SnmpSession snmpSession;

    OpennmsSnmpTrapSender(InetAddress agentAddress, String managerAddress, int managerPort, int managerVersion, String managerCommunity) {
        this.agentAddress = new SnmpIPAddress(agentAddress);
        this.managerAddress = managerAddress;
        this.managerPort = managerPort;
        this.managerVersion = managerVersion;
        this.managerCommunity = managerCommunity;
    }

    @Override
    public String getName() {
        return this.managerAddress + ":" + this.managerPort + "/" + this.managerCommunity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws Exception {
        OpennmsSnmpTrapSender opennmsSnmpTrapSender = this;
        synchronized (opennmsSnmpTrapSender) {
            if (this.snmpSession == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Connecting to " + this.managerAddress + ":" + this.managerPort + "..."));
                }
                SnmpPeer peer = new SnmpPeer(InetAddress.getByName(this.managerAddress));
                peer.setPort(this.managerPort);
                SnmpParameters params = peer.getParameters();
                params.setReadCommunity(this.managerCommunity);
                switch (this.managerVersion) {
                    case 1: {
                        params.setVersion(0);
                        break;
                    }
                    default: {
                        params.setVersion(1);
                    }
                }
                this.snmpSession = new SnmpSession(peer);
                this.snmpSession.setDefaultHandler((SnmpHandler)new NullHandler());
                Thread.sleep(100L);
                this.logger.trace((Object)"Connected");
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this.managerAddress + ":" + this.managerPort + " already connected"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        OpennmsSnmpTrapSender opennmsSnmpTrapSender = this;
        synchronized (opennmsSnmpTrapSender) {
            if (this.snmpSession != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Disconnecting from " + this.managerAddress + ":" + this.managerPort + "..."));
                }
                this.snmpSession.close();
                this.snmpSession = null;
                this.logger.trace((Object)"Disconnected");
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this.managerAddress + ":" + this.managerPort + " already disconnected"));
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.snmpSession != null;
    }

    @Override
    public void send(SnmpTrap trap) throws Exception {
        switch (this.managerVersion) {
            case 1: {
                this.sendV1(trap);
                break;
            }
            default: {
                this.sendV2(trap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendV1(SnmpTrap trap) throws Exception {
        SnmpPduTrap trapPdu = new SnmpPduTrap();
        trapPdu.setTimeStamp(trap.getTimeStamp());
        if (trap.getSource() == null) {
            throw new Exception("The source of trap is missing");
        }
        trapPdu.setEnterprise(new SnmpObjectId(trap.getSource().getOid()));
        trapPdu.setAgentAddress(this.agentAddress);
        if (trap instanceof SpecificSnmpTrap) {
            trapPdu.setGeneric(6);
            trapPdu.setSpecific(((SpecificSnmpTrap)trap).getType());
        } else if (trap instanceof GenericSnmpTrap) {
            GenericSnmpTrap genericTrap = (GenericSnmpTrap)trap;
            if (genericTrap.getType() == GenericSnmpTrapType.coldStart) {
                trapPdu.setGeneric(0);
            } else if (genericTrap.getType() == GenericSnmpTrapType.warmStart) {
                trapPdu.setGeneric(1);
            } else if (genericTrap.getType() == GenericSnmpTrapType.linkDown) {
                trapPdu.setGeneric(2);
            } else if (genericTrap.getType() == GenericSnmpTrapType.linkUp) {
                trapPdu.setGeneric(3);
            } else if (genericTrap.getType() == GenericSnmpTrapType.authenticationFailure) {
                trapPdu.setGeneric(4);
            } else if (genericTrap.getType() == GenericSnmpTrapType.egpNeighborLoss) {
                trapPdu.setGeneric(5);
            } else {
                throw new Exception("Generic trap type unknown");
            }
            trapPdu.setSpecific(0);
        } else {
            throw new Exception("Trap type unknown");
        }
        for (Map.Entry<SnmpOid, SnmpTrapData> entry : trap.getDataMap().entrySet()) {
            trapPdu.addVarBind(new SnmpVarBind(new SnmpObjectId(entry.getKey().getOid()), OpennmsSnmpTrapSender.newSnmpValue(entry.getValue().getType(), entry.getValue().getValue())));
        }
        OpennmsSnmpTrapSender opennmsSnmpTrapSender = this;
        synchronized (opennmsSnmpTrapSender) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(trap + " sending to " + this.managerAddress + ":" + this.managerPort + "..."));
            }
            if (this.snmpSession == null) {
                throw new Exception("The connection to the SNMP manager is closed");
            }
            this.snmpSession.send(trapPdu);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(trap + " sent"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendV2(SnmpTrap trap) throws Exception {
        SnmpOid typeValue;
        SnmpPduRequest trapPdu = new SnmpPduRequest(167);
        trapPdu.addVarBind(new SnmpVarBind(TIME_STAMP_OID, OpennmsSnmpTrapSender.newSnmpValue(SnmpDataType.timeTicks, new Long(trap.getTimeStamp()))));
        if (trap.getSource() == null) {
            throw new Exception("The source of trap is missing");
        }
        if (trap instanceof SpecificSnmpTrap) {
            typeValue = SnmpOid.newInstance(trap.getSource(), 0, ((SpecificSnmpTrap)trap).getType() + 1);
        } else {
            if (!(trap instanceof GenericSnmpTrap)) throw new Exception("Trap type unknown");
            GenericSnmpTrap genericTrap = (GenericSnmpTrap)trap;
            if (genericTrap.getType() == GenericSnmpTrapType.coldStart) {
                typeValue = GENERIC_COLD_START_TYPE_VALUE;
            } else if (genericTrap.getType() == GenericSnmpTrapType.warmStart) {
                typeValue = GENERIC_WARM_START_TYPE_VALUE;
            } else if (genericTrap.getType() == GenericSnmpTrapType.linkDown) {
                typeValue = GENERIC_LINK_DOWN_TYPE_VALUE;
            } else if (genericTrap.getType() == GenericSnmpTrapType.linkUp) {
                typeValue = GENERIC_LINK_UP_TYPE_VALUE;
            } else if (genericTrap.getType() == GenericSnmpTrapType.authenticationFailure) {
                typeValue = GENERIC_AUTHENTICATION_FAILURE_TYPE_VALUE;
            } else {
                if (genericTrap.getType() != GenericSnmpTrapType.egpNeighborLoss) throw new Exception("Generic trap type unknown");
                typeValue = GENERIC_EGP_NEIGHBOR_LOSS_TYPE_VALUE;
            }
        }
        trapPdu.addVarBind(new SnmpVarBind(TYPE_OID, OpennmsSnmpTrapSender.newSnmpValue(SnmpDataType.objectIdentifier, typeValue)));
        trapPdu.addVarBind(new SnmpVarBind(AGENT_ADDRESS_OID, OpennmsSnmpTrapSender.newSnmpValue(SnmpDataType.ipAddress, this.agentAddress.convertToIpAddress())));
        trapPdu.addVarBind(new SnmpVarBind(COMMUNITY_OID, OpennmsSnmpTrapSender.newSnmpValue(SnmpDataType.octetString, this.managerCommunity)));
        trapPdu.addVarBind(new SnmpVarBind(ENTERPRISE_OID, OpennmsSnmpTrapSender.newSnmpValue(SnmpDataType.objectIdentifier, trap.getSource())));
        for (Map.Entry<SnmpOid, SnmpTrapData> entry : trap.getDataMap().entrySet()) {
            trapPdu.addVarBind(new SnmpVarBind(new SnmpObjectId(entry.getKey().getOid()), OpennmsSnmpTrapSender.newSnmpValue(entry.getValue().getType(), entry.getValue().getValue())));
        }
        OpennmsSnmpTrapSender opennmsSnmpTrapSender = this;
        synchronized (opennmsSnmpTrapSender) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(trap + " sending to " + this.managerAddress + ":" + this.managerPort + "..."));
            }
            if (this.snmpSession == null) {
                throw new Exception("The connection to the SNMP manager is closed");
            }
            this.snmpSession.send((SnmpPduPacket)trapPdu);
            if (!this.logger.isTraceEnabled()) return;
            this.logger.trace((Object)(trap + " sent"));
            return;
        }
    }

    public String toString() {
        return "SnmpTrapSender:opennms[" + this.getName() + "]";
    }

    protected final class NullHandler
    implements SnmpHandler {
        protected NullHandler() {
        }

        public void snmpReceivedPdu(SnmpSession session, int command, SnmpPduPacket pdu) {
        }

        public void snmpInternalError(SnmpSession session, int err, SnmpSyntax pdu) {
        }

        public void snmpTimeoutError(SnmpSession session, SnmpSyntax pdu) {
        }
    }
}

