/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.api.opennms;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.sf.snmpadaptor4j.api.SnmpException;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;
import org.apache.log4j.Logger;
import org.opennms.protocols.snmp.SnmpCounter32;
import org.opennms.protocols.snmp.SnmpCounter64;
import org.opennms.protocols.snmp.SnmpGauge32;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpNull;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpOpaque;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTimeTicks;
import org.opennms.protocols.snmp.SnmpUInt32;

public abstract class OpennmsSupport {
    protected final Logger logger = Logger.getLogger(this.getClass());

    protected OpennmsSupport() {
    }

    protected static final SnmpSyntax newSnmpValue(SnmpDataType snmpDataType, Object value) throws Exception {
        SnmpInt32 snmpValue;
        if (snmpDataType == SnmpDataType.integer32) {
            snmpValue = new SnmpInt32(OpennmsSupport.toInteger32(value));
        } else if (snmpDataType == SnmpDataType.unsigned32) {
            snmpValue = new SnmpUInt32(OpennmsSupport.toUnsigned32(value));
        } else if (snmpDataType == SnmpDataType.gauge32) {
            snmpValue = new SnmpGauge32(OpennmsSupport.toUnsigned32(value));
        } else if (snmpDataType == SnmpDataType.counter32) {
            snmpValue = new SnmpCounter32(OpennmsSupport.toUnsigned32(value));
        } else if (snmpDataType == SnmpDataType.counter64) {
            snmpValue = new SnmpCounter64(OpennmsSupport.toUnsigned64(value));
        } else if (snmpDataType == SnmpDataType.timeTicks) {
            snmpValue = new SnmpTimeTicks(OpennmsSupport.toTimeTicks(value));
        } else if (snmpDataType == SnmpDataType.octetString) {
            snmpValue = new SnmpOctetString(OpennmsSupport.toOctetString(value));
        } else if (snmpDataType == SnmpDataType.ipAddress) {
            snmpValue = new SnmpIPAddress(OpennmsSupport.toIpAddress(value));
        } else if (snmpDataType == SnmpDataType.objectIdentifier) {
            snmpValue = new SnmpObjectId(OpennmsSupport.toObjectIdentifier(value));
        } else if (snmpDataType == SnmpDataType.opaque) {
            snmpValue = new SnmpOpaque(OpennmsSupport.toOctetString(value));
        } else {
            throw new SnmpException((Object)((Object)snmpDataType) + " unhandled", 7);
        }
        return snmpValue;
    }

    protected static Object newJmxValue(Class<?> jmxDataType, SnmpDataType snmpDataType, SnmpSyntax newValue) throws Exception {
        Object value;
        if (newValue instanceof SnmpNull) {
            value = null;
        } else if (snmpDataType == SnmpDataType.integer32) {
            if (!(newValue instanceof SnmpInt32)) {
                throw new SnmpException("New value is not an integer32", 3);
            }
            value = OpennmsSupport.fromInteger32(jmxDataType, ((SnmpInt32)newValue).getValue());
        } else if (snmpDataType == SnmpDataType.unsigned32) {
            if (!(newValue instanceof SnmpUInt32) || newValue instanceof SnmpCounter32 || newValue instanceof SnmpGauge32 || newValue instanceof SnmpTimeTicks) {
                throw new SnmpException("New value is not an unsigned32", 3);
            }
            value = OpennmsSupport.fromUnsigned32("unsigned32", jmxDataType, ((SnmpUInt32)newValue).getValue());
        } else if (snmpDataType == SnmpDataType.gauge32) {
            if (!(newValue instanceof SnmpGauge32)) {
                throw new SnmpException("New value is not a gauge32", 3);
            }
            value = OpennmsSupport.fromUnsigned32("gauge32", jmxDataType, ((SnmpGauge32)newValue).getValue());
        } else {
            if (snmpDataType == SnmpDataType.counter32) {
                throw new SnmpException("counter32 are not writable", 17);
            }
            if (snmpDataType == SnmpDataType.counter64) {
                throw new SnmpException("counter64 are not writable", 17);
            }
            if (snmpDataType == SnmpDataType.timeTicks) {
                if (!(newValue instanceof SnmpTimeTicks)) {
                    throw new SnmpException("New value is not a timeTicks", 3);
                }
                value = OpennmsSupport.fromTimeTicks(jmxDataType, ((SnmpTimeTicks)newValue).getValue());
            } else if (snmpDataType == SnmpDataType.octetString) {
                if (!(newValue instanceof SnmpOctetString) || newValue instanceof SnmpIPAddress || newValue instanceof SnmpOpaque) {
                    throw new SnmpException("New value is not an octetString", 3);
                }
                value = OpennmsSupport.fromOctetString("octetString", jmxDataType, ((SnmpOctetString)newValue).getString());
            } else if (snmpDataType == SnmpDataType.ipAddress) {
                if (!(newValue instanceof SnmpIPAddress)) {
                    throw new SnmpException("New value is not an ipAddress", 3);
                }
                value = OpennmsSupport.fromIpAddress(jmxDataType, ((SnmpIPAddress)newValue).convertToIpAddress());
            } else if (snmpDataType == SnmpDataType.objectIdentifier) {
                if (!(newValue instanceof SnmpObjectId)) {
                    throw new SnmpException("New value is not an objectIdentifier", 3);
                }
                value = OpennmsSupport.fromObjectIdentifier(jmxDataType, ((SnmpObjectId)newValue).getIdentifiers());
            } else if (snmpDataType == SnmpDataType.opaque) {
                if (!(newValue instanceof SnmpOpaque)) {
                    throw new SnmpException("New value is not an opaque", 3);
                }
                value = OpennmsSupport.fromOctetString("opaque", jmxDataType, ((SnmpOpaque)newValue).getString());
            } else {
                throw new SnmpException((Object)((Object)snmpDataType) + " unhandled", 7);
            }
        }
        return value;
    }

    private static Integer toInteger32(Object value) {
        Integer result;
        if (value instanceof Integer) {
            result = (Integer)value;
        } else if (value instanceof Byte) {
            result = new Integer(((Byte)value).intValue());
        } else if (value instanceof Short) {
            result = new Integer(((Short)value).intValue());
        } else if (value instanceof Boolean) {
            result = new Integer((Boolean)value != false ? 1 : 2);
        } else if (value == null) {
            result = new Integer(0);
        } else {
            throw new SnmpException(value.getClass() + " is inconsistent with integer32", 7);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object fromInteger32(Class<?> type, int value) {
        void var2_7;
        if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            Integer n = new Integer(value);
            return var2_7;
        } else if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            if (value < -128 || value > 127) {
                throw new SnmpException("the value must be between -128 and 127", 3);
            }
            Byte by = new Byte((byte)value);
            return var2_7;
        } else if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw new SnmpException("the value must be between -32768 and 32767", 3);
            }
            Short s = new Short((short)value);
            return var2_7;
        } else {
            if (!Boolean.class.equals(type) && !Boolean.TYPE.equals(type)) throw new SnmpException(type + " is inconsistent with integer32", 7);
            if (value == 1) {
                Boolean bl = Boolean.TRUE;
                return var2_7;
            } else {
                if (value != 2) throw new SnmpException("the value must be between true(1) and false(2)", 3);
                Boolean bl = Boolean.FALSE;
            }
        }
        return var2_7;
    }

    private static Long toUnsigned32(Object value) {
        Long result;
        if (value instanceof Long) {
            result = (Long)value;
        } else if (value instanceof Integer) {
            result = new Long(((Integer)value).longValue());
        } else if (value instanceof Byte) {
            result = new Long(((Byte)value).longValue());
        } else if (value instanceof Short) {
            result = new Long(((Short)value).longValue());
        } else if (value == null) {
            result = new Long(0L);
        } else {
            throw new SnmpException(value.getClass() + " is inconsistent with unsigned32", 7);
        }
        long maxValue = 0xFFFFFFFFL;
        if (result < 0L || result > 0xFFFFFFFFL) {
            throw new SnmpException("the value must be between 0 and 4294967295", 7);
        }
        return result;
    }

    private static Object fromUnsigned32(String snmpDataTypeName, Class<?> type, long value) {
        Number result;
        if (Long.class.equals(type) || Long.TYPE.equals(type)) {
            result = new Long(value);
        } else if (Integer.class.equals(type) || Integer.TYPE.equals(type)) {
            if (value > Integer.MAX_VALUE) {
                throw new SnmpException("the value must be between 0 and 2147483647", 3);
            }
            result = new Integer((int)value);
        } else if (Byte.class.equals(type) || Byte.TYPE.equals(type)) {
            if (value > 127L) {
                throw new SnmpException("the value must be between 0 and 127", 3);
            }
            result = new Byte((byte)value);
        } else if (Short.class.equals(type) || Short.TYPE.equals(type)) {
            if (value > 32767L) {
                throw new SnmpException("the value must be between 0 and 32767", 3);
            }
            result = new Short((short)value);
        } else {
            throw new SnmpException(type + " is inconsistent with " + snmpDataTypeName, 7);
        }
        return result;
    }

    private static BigInteger toUnsigned64(Object value) {
        BigInteger result;
        if (value instanceof BigInteger) {
            result = (BigInteger)value;
        } else if (value instanceof Long) {
            result = BigInteger.valueOf((Long)value);
        } else if (value == null) {
            result = BigInteger.valueOf(0L);
        } else {
            throw new SnmpException(value.getClass() + " is inconsistent with unsigned64", 7);
        }
        BigInteger minValue = BigInteger.valueOf(0L);
        BigInteger maxValue = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.valueOf(1L));
        if (result.compareTo(minValue) < 0 || result.compareTo(maxValue) > 0) {
            throw new SnmpException("the value must be between " + minValue + " and " + maxValue, 7);
        }
        return result;
    }

    private static Long toTimeTicks(Object value) {
        Long result;
        if (value instanceof Long) {
            result = new Long((Long)value / 10L);
        } else if (value == null) {
            result = new Long(0L);
        } else {
            throw new SnmpException(value.getClass() + " is inconsistent with timeTicks", 7);
        }
        long maxValue = 0xFFFFFFFFL;
        if (result < 0L || result > 0xFFFFFFFFL) {
            throw new SnmpException("the value must be between 0 and 4294967295", 7);
        }
        return result;
    }

    private static Object fromTimeTicks(Class<?> type, long value) {
        if (!Long.class.equals(type) && !Long.TYPE.equals(type)) {
            throw new SnmpException(type + " is inconsistent with timeTicks", 7);
        }
        Long result = new Long(10L * value);
        return result;
    }

    private static byte[] toOctetString(Object value) {
        byte[] result = value instanceof String ? ((String)value).getBytes() : (value instanceof byte[] ? (byte[])value : (value == null ? "".getBytes() : value.toString().getBytes()));
        return result;
    }

    private static Object fromOctetString(String snmpDataTypeName, Class<?> type, byte[] value) {
        Object result;
        if (String.class.equals(type)) {
            result = new String(value);
        } else if (byte[].class.equals(type)) {
            result = value;
        } else {
            throw new SnmpException(type + " is inconsistent with " + snmpDataTypeName, 7);
        }
        return result;
    }

    private static InetAddress toIpAddress(Object value) throws Exception {
        InetAddress result;
        if (value instanceof InetAddress) {
            result = (InetAddress)value;
        } else if (value instanceof String) {
            try {
                result = InetAddress.getByName((String)value);
            }
            catch (UnknownHostException e) {
                throw new SnmpException("IP address is malformed", 10);
            }
        } else if (value == null) {
            result = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        } else {
            throw new SnmpException(value.getClass() + " is inconsistent with ipAddress", 7);
        }
        return result;
    }

    private static Object fromIpAddress(Class<?> type, InetAddress value) {
        Object result;
        if (InetAddress.class.equals(type)) {
            result = value;
        } else if (String.class.equals(type)) {
            result = value.getHostAddress();
        } else {
            throw new SnmpException(type + " is inconsistent with ipAddress", 7);
        }
        return result;
    }

    private static int[] toObjectIdentifier(Object value) {
        int[] result;
        if (value instanceof SnmpOid) {
            result = ((SnmpOid)value).getOid();
        } else if (value instanceof String) {
            result = SnmpOid.newInstance((String)value).getOid();
        } else if (value == null) {
            result = new int[]{1};
        } else {
            throw new SnmpException(value.getClass() + " is inconsistent with objectIdentifier", 7);
        }
        return result;
    }

    private static Object fromObjectIdentifier(Class<?> type, int[] value) {
        Object result;
        if (SnmpOid.class.equals(type)) {
            result = SnmpOid.newInstance(value);
        } else if (String.class.equals(type)) {
            result = SnmpOid.newInstance(value).toString();
        } else {
            throw new SnmpException(type + " is inconsistent with objectIdentifier", 7);
        }
        return result;
    }
}

