/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import net.sf.snmpadaptor4j.SnmpAppContext;
import net.sf.snmpadaptor4j.SnmpConfiguration;
import net.sf.snmpadaptor4j.SnmpManagerConfiguration;
import net.sf.snmpadaptor4j.config.jaxb.Config;
import net.sf.snmpadaptor4j.config.jaxb.Daemon;
import net.sf.snmpadaptor4j.config.jaxb.MBean;
import net.sf.snmpadaptor4j.config.jaxb.Manager;
import net.sf.snmpadaptor4j.config.jaxb.Root;
import net.sf.snmpadaptor4j.config.jaxb.Roots;

public final class XmlConfigParser
implements SnmpConfiguration,
SnmpAppContext {
    private final URL url;
    private final Daemon daemon;
    private final List<SnmpManagerConfiguration> managerList;
    private final Roots roots;
    private final Map<String, String> rootOidMap;
    private final Map<ObjectName, String> mBeanOidMap;

    public static XmlConfigParser newInstance(URL url) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)Config.class.getPackage().getName());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement jaxbElement = (JAXBElement)unmarshaller.unmarshal(url);
        Config config = (Config)jaxbElement.getValue();
        ArrayList<SnmpManagerConfiguration> managerList = new ArrayList<SnmpManagerConfiguration>();
        if (config.getManagers() != null) {
            for (Manager manager : config.getManagers().getManager()) {
                managerList.add(new SnmpManagerConfiguration(manager.getAddress(), manager.getPort(), manager.getVersion(), manager.getCommunity()));
            }
        }
        HashMap<String, String> rootOidMap = new HashMap<String, String>();
        for (Root root : config.getRoots().getRoot()) {
            if (root.getOid().trim().length() <= 0) continue;
            rootOidMap.put(root.getId(), root.getOid());
        }
        HashMap<ObjectName, String> hashMap = new HashMap<ObjectName, String>();
        if (config.getMbeans() != null) {
            for (MBean mBean : config.getMbeans().getMbean()) {
                String oid = null;
                if (mBean.getRoot() != null) {
                    oid = (String)rootOidMap.get(mBean.getRoot());
                }
                if (oid == null) {
                    oid = config.getRoots().getDefault();
                }
                oid = oid + "." + mBean.getOid();
                hashMap.put(new ObjectName(mBean.getName()), oid);
            }
        }
        return new XmlConfigParser(url, config.getDaemon(), managerList, config.getRoots(), rootOidMap, hashMap);
    }

    private XmlConfigParser(URL url, Daemon daemon, List<SnmpManagerConfiguration> managerList, Roots roots, Map<String, String> rootOidMap, Map<ObjectName, String> mBeanOidMap) {
        this.url = url;
        this.daemon = daemon;
        this.managerList = Collections.unmodifiableList(managerList);
        this.roots = roots;
        this.rootOidMap = Collections.unmodifiableMap(rootOidMap);
        this.mBeanOidMap = Collections.unmodifiableMap(mBeanOidMap);
    }

    @Override
    public String getListenerAddress() {
        return this.daemon.getAddress();
    }

    @Override
    public Integer getListenerPort() {
        return new Integer(this.daemon.getPort());
    }

    @Override
    public Integer getListenerSnmpVersion() {
        return new Integer(this.daemon.getVersion());
    }

    @Override
    public String getListenerReadCommunity() {
        return this.daemon.getReadCommunity();
    }

    @Override
    public String getListenerWriteCommunity() {
        return this.daemon.getWriteCommunity();
    }

    @Override
    public List<SnmpManagerConfiguration> getManagerList() {
        return this.managerList;
    }

    @Override
    public String getDefaultRootOid() {
        return this.roots.getDefault();
    }

    @Override
    public Map<String, String> getRootOidMap() {
        return this.rootOidMap;
    }

    @Override
    public Map<ObjectName, String> getMBeanOidMap() {
        return this.mBeanOidMap;
    }

    public String toString() {
        return "XmlConfigParser[" + this.url + "]";
    }
}

