/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import net.sf.snmpadaptor4j.SnmpAppContext;
import net.sf.snmpadaptor4j.core.JmxNotificationManager;
import net.sf.snmpadaptor4j.core.JmxSnmpMib;
import net.sf.snmpadaptor4j.core.mapping.MBeanAttributeMapping;
import net.sf.snmpadaptor4j.core.mapping.SnmpTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.XmlMappingParser;
import org.apache.log4j.Logger;

public class JmxListener
implements NotificationListener {
    protected final Logger logger = Logger.getLogger(JmxListener.class);
    private final JmxSnmpMib jmxSnmpMib;
    private final JmxNotificationManager jmxNotificationManager;
    private final SnmpAppContext mainAppContext;
    private final Map<ClassLoader, SnmpAppContext> appContextMap;
    private final boolean classLoaderScope;
    private MBeanServer jmxServer;

    public JmxListener(JmxSnmpMib jmxSnmpMib, JmxNotificationManager jmxNotificationManager, SnmpAppContext mainAppContext, Map<ClassLoader, SnmpAppContext> appContextMap, boolean classLoaderScope) {
        this(jmxSnmpMib, jmxNotificationManager, mainAppContext, appContextMap, classLoaderScope, null);
    }

    protected JmxListener(JmxSnmpMib jmxSnmpMib, JmxNotificationManager jmxNotificationManager, SnmpAppContext mainAppContext, Map<ClassLoader, SnmpAppContext> appContextMap, boolean classLoaderScope, MBeanServer jmxServer) {
        this.mainAppContext = mainAppContext;
        this.appContextMap = appContextMap;
        this.classLoaderScope = classLoaderScope;
        this.jmxSnmpMib = jmxSnmpMib;
        this.jmxNotificationManager = jmxNotificationManager;
        this.jmxServer = jmxServer;
    }

    protected final MBeanServer getJmxServer() {
        return this.jmxServer;
    }

    public synchronized void open(MBeanServer server) throws Exception {
        this.logger.trace((Object)"JMX opening...");
        if (this.jmxServer != null) {
            throw new Exception("Already connected to a JMX agent");
        }
        MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
        filter.enableAllObjectNames();
        server.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, (NotificationFilter)filter, (Object)server);
        Set<ObjectName> mBeanNameList = server.queryNames(null, null);
        for (ObjectName mBeanName : mBeanNameList) {
            this.register(server, mBeanName);
        }
        this.jmxServer = server;
        this.logger.trace((Object)"JMX opened");
    }

    public synchronized void close() throws Exception {
        this.logger.trace((Object)"JMX closing...");
        if (this.jmxServer == null) {
            throw new Exception("Not connected to a JMX agent");
        }
        this.jmxServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this);
        this.jmxNotificationManager.unregisterAll(this.jmxServer);
        this.jmxSnmpMib.unregisterAllAttributes();
        this.jmxServer = null;
        this.logger.trace((Object)"JMX closed");
    }

    @Override
    public final synchronized void handleNotification(Notification notification, Object handback) {
        if (handback instanceof MBeanServer && this.jmxServer == (MBeanServer)handback && notification instanceof MBeanServerNotification) {
            MBeanServerNotification serverNotification = (MBeanServerNotification)notification;
            if ("JMX.mbean.registered".equals(serverNotification.getType())) {
                try {
                    this.register((MBeanServer)handback, serverNotification.getMBeanName());
                }
                catch (Throwable e) {
                    this.logger.error((Object)(serverNotification.getMBeanName() + ": MBean not loaded in SNMP adapter"), e);
                }
            } else if ("JMX.mbean.unregistered".equals(serverNotification.getType())) {
                try {
                    this.unregister((MBeanServer)handback, serverNotification.getMBeanName());
                }
                catch (Throwable e) {
                    this.logger.error((Object)(serverNotification.getMBeanName() + ": MBean not unloaded in SNMP adapter"), e);
                }
            }
        }
    }

    private void register(MBeanServer server, ObjectName mBeanName) throws Exception {
        if (server.isRegistered(mBeanName)) {
            ClassLoader classLoader = server.getClassLoaderFor(mBeanName);
            if (classLoader != null) {
                if (!this.classLoaderScope || this.getClass().getClassLoader().equals(classLoader)) {
                    Class<?> mBeanClass = classLoader.loadClass(server.getObjectInstance(mBeanName).getClassName());
                    URL url = mBeanClass.getResource(mBeanClass.getSimpleName() + ".snmp.xml");
                    if (url != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("SNMP mapping found at " + url));
                        }
                        XmlMappingParser parser = XmlMappingParser.newInstance(url);
                        SnmpAppContext ctx = this.findAppContext(classLoader);
                        String baseOid = ctx.getMBeanOidMap().get(mBeanName);
                        if (baseOid == null) {
                            baseOid = parser.findBaseOid(mBeanName, ctx.getRootOidMap(), ctx.getDefaultRootOid(), this.mainAppContext.getDefaultRootOid());
                        }
                        if (baseOid == null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("None OID found for [" + mBeanName + "]"));
                            }
                        } else {
                            HashMap<String, MBeanAttributeInfo> mBeanAttributeInfoMap = new HashMap<String, MBeanAttributeInfo>();
                            for (MBeanAttributeInfo mBeanAttributeInfo : server.getMBeanInfo(mBeanName).getAttributes()) {
                                mBeanAttributeInfoMap.put(mBeanAttributeInfo.getName(), mBeanAttributeInfo);
                            }
                            List<MBeanAttributeMapping> mBeanAttributeMappingList = parser.newMBeanAttributeMappingList(mBeanAttributeInfoMap, classLoader, baseOid);
                            this.jmxSnmpMib.registerAttributes(server, mBeanName, mBeanAttributeMappingList);
                            Map<String, SnmpTrapMapping> trapMappingMap = parser.newSnmpTrapMappingMap(baseOid);
                            this.jmxNotificationManager.register(server, mBeanName, trapMappingMap);
                        }
                    } else if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("SNMP mapping missing for [" + mBeanName + "]"));
                    }
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("SNMP mapping ignored because classLoaderScope = TRUE for [" + mBeanName + "]"));
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("SNMP mapping ignored because the MBean is not accessible for [" + mBeanName + "]"));
            }
        }
    }

    private SnmpAppContext findAppContext(ClassLoader classLoader) {
        SnmpAppContext ctx = null;
        for (ClassLoader cl = classLoader; ctx == null && cl != null; cl = cl.getParent()) {
            ctx = this.appContextMap.get(cl);
        }
        if (ctx == null) {
            ctx = this.mainAppContext;
        }
        return ctx;
    }

    private void unregister(MBeanServer server, ObjectName mBeanName) {
        this.jmxSnmpMib.unregisterAttributes(server, mBeanName);
        this.jmxNotificationManager.unregister(server, mBeanName);
    }

    public final String toString() {
        return "JmxListener[jmxSnmpMib=" + this.jmxSnmpMib + "; jmxNotificationManager=" + this.jmxNotificationManager + "; mainAppContext=" + this.mainAppContext + "; appContextMap=" + this.appContextMap + "; classLoaderScope=" + this.classLoaderScope + "]";
    }
}

