/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import net.sf.snmpadaptor4j.core.mapping.SnmpTrapMapping;
import net.sf.snmpadaptor4j.core.trap.SnmpManagers;
import net.sf.snmpadaptor4j.core.trap.SnmpTrapBuilder;
import net.sf.snmpadaptor4j.mbean.SystemInfo;
import net.sf.snmpadaptor4j.object.SnmpTrap;
import org.apache.log4j.Logger;

public class JmxNotificationManager {
    protected final Logger logger = Logger.getLogger(JmxNotificationManager.class);
    private final SnmpManagers managers;
    private final SystemInfo systemInfo;
    protected final Map<ObjectName, Listener> listenerMap = new HashMap<ObjectName, Listener>();
    private boolean enabled = false;

    public JmxNotificationManager(SnmpManagers managers, SystemInfo systemInfo) {
        this.managers = managers;
        this.systemInfo = systemInfo;
    }

    synchronized void register(MBeanServer server, ObjectName mBeanName, Map<String, SnmpTrapMapping> trapMappingMap) {
        if (trapMappingMap.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("None SNMP trap mapped for [" + mBeanName + "]"));
            }
        } else {
            if (this.logger.isInfoEnabled()) {
                for (Map.Entry<String, SnmpTrapMapping> trapMappingEntry : trapMappingMap.entrySet()) {
                    this.logger.info((Object)("MBean notification registered at [" + mBeanName + "].[" + trapMappingEntry.getKey() + "] = " + trapMappingEntry.getValue()));
                }
            }
            Listener listener = new Listener(new SnmpTrapBuilder(trapMappingMap, this.systemInfo));
            try {
                server.addNotificationListener(mBeanName, listener, null, null);
                this.listenerMap.put(mBeanName, listener);
            }
            catch (Throwable e) {
                this.logger.warn((Object)("Notifications issued in on [" + mBeanName + "] will not cause any SNMP trap sending"), e);
            }
        }
    }

    synchronized void unregisterAll(MBeanServer server) {
        ArrayList<ObjectName> mBeanNameList = new ArrayList<ObjectName>(this.listenerMap.keySet());
        for (ObjectName mBeanName : mBeanNameList) {
            this.unregister(server, mBeanName);
        }
    }

    synchronized void unregister(MBeanServer server, ObjectName mBeanName) {
        Listener listener = this.listenerMap.get(mBeanName);
        if (listener != null) {
            if (this.logger.isInfoEnabled()) {
                for (String notificationType : listener.trapBuilder.getMappingMap().keySet()) {
                    this.logger.info((Object)("MBean notification unregistered at [" + mBeanName + "].[" + notificationType + "]"));
                }
            }
            try {
                if (server.isRegistered(mBeanName)) {
                    server.removeNotificationListener(mBeanName, listener);
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("[" + mBeanName + "] already unregistered from JMX"));
                }
                this.listenerMap.remove(mBeanName);
            }
            catch (Throwable e) {
                this.logger.warn((Object)("An error occurred when unloading of [" + mBeanName + "] to support notifications"), e);
            }
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected final void handleNotification(SnmpTrapBuilder trapBuilder, Notification notification) {
        if (this.enabled) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("JMX notification [" + notification.getSource() + "].[" + notification.getType() + "] received"));
                this.logger.trace((Object)("source           = " + notification.getSource()));
                this.logger.trace((Object)("sequenceNumber   = " + notification.getSequenceNumber()));
                this.logger.trace((Object)("timeStamp        = " + notification.getTimeStamp()));
                this.logger.trace((Object)("type             = " + notification.getType()));
                this.logger.trace((Object)("message          = " + notification.getMessage()));
                if (notification.getUserData() instanceof Map) {
                    for (Map.Entry entry : ((Map)notification.getUserData()).entrySet()) {
                        this.logger.trace((Object)("userData:        " + entry.getKey() + " = " + entry.getValue()));
                    }
                } else {
                    this.logger.trace((Object)("userData         = " + (notification.getUserData() != null ? "(" + notification.getUserData().getClass().getName() + ")" : "") + notification.getUserData()));
                }
            }
            try {
                SnmpTrap trap = trapBuilder.newTrap(notification);
                if (trap == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("None SNMP trap to send for the JMX notification [" + notification.getSource() + "].[" + notification.getType() + "]"));
                    }
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Notification [" + notification.getSource() + "].[" + notification.getType() + "] = " + trap));
                    }
                    this.managers.send(trap);
                }
            }
            catch (Throwable e) {
                this.logger.error((Object)("Unable to handle the notification " + notification + " for send a SNMP trap"), e);
            }
        }
    }

    public final String toString() {
        return "JmxNotificationManager[managers=" + this.managers + "; systemInfo=" + this.systemInfo + "; listenerMap=" + this.listenerMap + "]";
    }

    protected final class Listener
    implements NotificationListener {
        protected final SnmpTrapBuilder trapBuilder;

        protected Listener(SnmpTrapBuilder trapBuilder) {
            this.trapBuilder = trapBuilder;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            JmxNotificationManager.this.handleNotification(this.trapBuilder, notification);
        }

        public String toString() {
            return "Listener[trapBuilder=" + this.trapBuilder + "]";
        }
    }
}

