/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core;

import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.api.SnmpMib;
import net.sf.snmpadaptor4j.core.accessor.MBeanAttributeAccessor;
import net.sf.snmpadaptor4j.core.mapping.MBeanAttributeMapping;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;
import org.apache.log4j.Logger;

public class JmxSnmpMib
implements SnmpMib {
    protected final Logger logger = Logger.getLogger(JmxSnmpMib.class);
    private final SnmpMib other;
    private final SortedMap<SnmpOid, AttributeAccessor> mib = new TreeMap<SnmpOid, AttributeAccessor>();

    public JmxSnmpMib(SnmpMib other) {
        this.other = other;
    }

    protected final SortedMap<SnmpOid, AttributeAccessor> getMib() {
        return this.mib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterAllAttributes() {
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            while (!this.mib.isEmpty()) {
                MBeanAttributeAccessor accessor = (MBeanAttributeAccessor)this.mib.get(this.mib.firstKey());
                this.unregisterAttributes(accessor.getMBeanName(), accessor.getOid());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAttributes(MBeanServer server, ObjectName mBeanName, List<MBeanAttributeMapping> mBeanAttributeMappingList) throws Exception {
        for (MBeanAttributeMapping mapping : mBeanAttributeMappingList) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("SNMP attribute registering at " + mapping.getOid() + " (" + (Object)((Object)mapping.getSnmpDataType()) + ") = [" + mBeanName + "]." + mapping.getAttributeName() + " (" + mapping.getJmxDataType().getSimpleName() + ")"));
            }
            JmxSnmpMib.checkDataType(mapping.getSnmpDataType(), mapping.getJmxDataType());
            SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
            synchronized (sortedMap) {
                this.mib.put(mapping.getOid(), new MBeanAttributeAccessor(server, mBeanName, mapping));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterAttributes(MBeanServer server, ObjectName mBeanName) {
        TreeSet<SnmpOid> oidSet = new TreeSet<SnmpOid>();
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            for (AttributeAccessor node : this.mib.values()) {
                if (!mBeanName.equals(((MBeanAttributeAccessor)node).getMBeanName())) continue;
                oidSet.add(node.getOid());
            }
            for (SnmpOid oid : oidSet) {
                this.unregisterAttributes(mBeanName, oid);
            }
        }
    }

    private void unregisterAttributes(ObjectName mBeanName, SnmpOid oid) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("SNMP attribute unregistering at " + oid + " for [" + mBeanName + "]"));
        }
        this.mib.remove(oid);
    }

    protected static final void checkDataType(SnmpDataType snmpDataType, Class<?> jmxDataType) throws Exception {
        if (snmpDataType == SnmpDataType.integer32 ? !Integer.TYPE.equals(jmxDataType) && !Integer.class.equals(jmxDataType) && !Byte.TYPE.equals(jmxDataType) && !Byte.class.equals(jmxDataType) && !Short.TYPE.equals(jmxDataType) && !Short.class.equals(jmxDataType) && !Boolean.TYPE.equals(jmxDataType) && !Boolean.class.equals(jmxDataType) : (snmpDataType == SnmpDataType.unsigned32 || snmpDataType == SnmpDataType.gauge32 || snmpDataType == SnmpDataType.counter32 ? !Long.TYPE.equals(jmxDataType) && !Long.class.equals(jmxDataType) && !Integer.TYPE.equals(jmxDataType) && !Integer.class.equals(jmxDataType) && !Byte.TYPE.equals(jmxDataType) && !Byte.class.equals(jmxDataType) && !Short.TYPE.equals(jmxDataType) && !Short.class.equals(jmxDataType) : (snmpDataType == SnmpDataType.counter64 ? !BigInteger.class.equals(jmxDataType) && !Long.TYPE.equals(jmxDataType) && !Long.class.equals(jmxDataType) : (snmpDataType == SnmpDataType.timeTicks ? !Long.TYPE.equals(jmxDataType) && !Long.class.equals(jmxDataType) : (snmpDataType == SnmpDataType.ipAddress ? !String.class.equals(jmxDataType) && !InetAddress.class.equals(jmxDataType) : snmpDataType == SnmpDataType.objectIdentifier && !String.class.equals(jmxDataType) && !SnmpOid.class.equals(jmxDataType)))))) {
            throw new Exception((Object)((Object)snmpDataType) + " is inconsistent with " + jmxDataType.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AttributeAccessor find(SnmpOid oid) {
        AttributeAccessor node;
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            node = (AttributeAccessor)this.mib.get(oid);
        }
        if (node == null) {
            node = this.other.find(oid);
        }
        return node;
    }

    @Override
    public final AttributeAccessor next(SnmpOid oid) {
        Iterator<Map.Entry<SnmpOid, AttributeAccessor>> entryIterator = this.nextSet(oid).entrySet().iterator();
        AttributeAccessor node = entryIterator.hasNext() ? entryIterator.next().getValue() : null;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SortedMap<SnmpOid, AttributeAccessor> nextSet(SnmpOid oid) {
        TreeMap<SnmpOid, AttributeAccessor> nodeMap = new TreeMap<SnmpOid, AttributeAccessor>();
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            nodeMap.putAll(this.mib.tailMap(SnmpOid.newInstance(oid.getOid(), 0)));
        }
        nodeMap.putAll(this.other.nextSet(oid));
        return nodeMap;
    }

    public final String toString() {
        return "JmxSnmpMib" + this.mib.values();
    }
}

