/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.api.SnmpMib;
import net.sf.snmpadaptor4j.core.accessor.CompositeDataAttributeAccessor;
import net.sf.snmpadaptor4j.core.accessor.JvmAttributeAccessor;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class JvmSnmpMib
implements SnmpMib {
    private final SnmpMib other;
    private final SortedMap<SnmpOid, AttributeAccessor> mib = new TreeMap<SnmpOid, AttributeAccessor>();
    private static final String jvmMgtMIB = "1.3.6.1.4.1.42.2.145.3.163.1";
    private static final String jvmMgtMIBObjects = "1.3.6.1.4.1.42.2.145.3.163.1.1";
    private static final String jvmMgtMIBNotifications = "1.3.6.1.4.1.42.2.145.3.163.1.2";
    private static final String jvmMgtMIBConformance = "1.3.6.1.4.1.42.2.145.3.163.1.3";
    private static final String jvmClassLoading = "1.3.6.1.4.1.42.2.145.3.163.1.1.1";
    private static final String jvmMemory = "1.3.6.1.4.1.42.2.145.3.163.1.1.2";
    private static final String jvmThreading = "1.3.6.1.4.1.42.2.145.3.163.1.1.3";
    private static final String jvmRuntime = "1.3.6.1.4.1.42.2.145.3.163.1.1.4";
    private static final String jvmOS = "1.3.6.1.4.1.42.2.145.3.163.1.1.5";

    public JvmSnmpMib(SnmpMib other) {
        this.other = other;
    }

    public synchronized void open(MBeanServer server) throws Exception {
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.1.1.0", SnmpDataType.gauge32, "java.lang:type=ClassLoading", "LoadedClassCount", Integer.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.1.2.0", SnmpDataType.counter64, "java.lang:type=ClassLoading", "TotalLoadedClassCount", Long.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.1.3.0", SnmpDataType.counter64, "java.lang:type=ClassLoading", "UnloadedClassCount", Long.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.2.1.0", SnmpDataType.gauge32, "java.lang:type=Memory", "ObjectPendingFinalizationCount", Integer.TYPE, true);
        this.putCompositeDataAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.2.10.0", "java.lang:type=Memory", "HeapMemoryUsage", "init", SnmpDataType.counter64, Long.TYPE);
        this.putCompositeDataAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.2.11.0", "java.lang:type=Memory", "HeapMemoryUsage", "used", SnmpDataType.counter64, Long.TYPE);
        this.putCompositeDataAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.2.12.0", "java.lang:type=Memory", "HeapMemoryUsage", "committed", SnmpDataType.counter64, Long.TYPE);
        this.putCompositeDataAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.2.13.0", "java.lang:type=Memory", "HeapMemoryUsage", "max", SnmpDataType.counter64, Long.TYPE);
        this.putCompositeDataAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.2.20.0", "java.lang:type=Memory", "NonHeapMemoryUsage", "init", SnmpDataType.counter64, Long.TYPE);
        this.putCompositeDataAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.2.21.0", "java.lang:type=Memory", "NonHeapMemoryUsage", "used", SnmpDataType.counter64, Long.TYPE);
        this.putCompositeDataAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.2.22.0", "java.lang:type=Memory", "NonHeapMemoryUsage", "committed", SnmpDataType.counter64, Long.TYPE);
        this.putCompositeDataAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.2.23.0", "java.lang:type=Memory", "NonHeapMemoryUsage", "max", SnmpDataType.counter64, Long.TYPE);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.3.1.0", SnmpDataType.gauge32, "java.lang:type=Threading", "ThreadCount", Integer.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.3.2.0", SnmpDataType.gauge32, "java.lang:type=Threading", "DaemonThreadCount", Integer.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.3.3.0", SnmpDataType.counter32, "java.lang:type=Threading", "PeakThreadCount", Integer.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.3.4.0", SnmpDataType.counter64, "java.lang:type=Threading", "TotalStartedThreadCount", Long.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.3.5.0", SnmpDataType.counter64, "java.lang:type=Threading", "TotalStartedThreadCount", Long.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.1.0", SnmpDataType.octetString, "java.lang:type=Runtime", "Name", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.2.0", SnmpDataType.octetString, "java.lang:type=Runtime", "VmName", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.3.0", SnmpDataType.octetString, "java.lang:type=Runtime", "VmVendor", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.4.0", SnmpDataType.octetString, "java.lang:type=Runtime", "VmVersion", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.5.0", SnmpDataType.octetString, "java.lang:type=Runtime", "SpecName", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.6.0", SnmpDataType.octetString, "java.lang:type=Runtime", "SpecVendor", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.7.0", SnmpDataType.octetString, "java.lang:type=Runtime", "SpecVersion", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.8.0", SnmpDataType.octetString, "java.lang:type=Runtime", "ManagementSpecVersion", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.11.0", SnmpDataType.counter64, "java.lang:type=Runtime", "Uptime", Long.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.4.12.0", SnmpDataType.counter64, "java.lang:type=Runtime", "StartTime", Long.TYPE, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.5.1.0", SnmpDataType.octetString, "java.lang:type=OperatingSystem", "Name", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.5.2.0", SnmpDataType.octetString, "java.lang:type=OperatingSystem", "Arch", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.5.3.0", SnmpDataType.octetString, "java.lang:type=OperatingSystem", "Version", String.class, true);
        this.putAttribute(server, "1.3.6.1.4.1.42.2.145.3.163.1.1.5.4.0", SnmpDataType.integer32, "java.lang:type=OperatingSystem", "AvailableProcessors", Integer.TYPE, true);
    }

    public synchronized void close() {
        this.mib.clear();
    }

    public final void putAttribute(MBeanServer server, String oidAsStr, SnmpDataType snmpDataType, String mBeanName, String attributeName, Class<?> jmxDataType, boolean readonly) throws Exception {
        SnmpOid oid = SnmpOid.newInstance(oidAsStr);
        this.mib.put(oid, new JvmAttributeAccessor(server, new ObjectName(mBeanName), oid, attributeName, snmpDataType, jmxDataType, !readonly));
    }

    public final void putCompositeDataAttribute(MBeanServer server, String oidAsStr, String mBeanName, String attributeName, String attributeKey, SnmpDataType snmpDataType, Class<?> jmxDataType) throws Exception {
        SnmpOid oid = SnmpOid.newInstance(oidAsStr);
        this.mib.put(oid, new CompositeDataAttributeAccessor(oid, server, new ObjectName(mBeanName), attributeName, attributeKey, snmpDataType, jmxDataType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AttributeAccessor find(SnmpOid oid) {
        AttributeAccessor node;
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            node = (AttributeAccessor)this.mib.get(oid);
        }
        if (node == null) {
            node = this.other.find(oid);
        }
        return node;
    }

    @Override
    public final AttributeAccessor next(SnmpOid oid) {
        Iterator<Map.Entry<SnmpOid, AttributeAccessor>> entryIterator = this.nextSet(oid).entrySet().iterator();
        AttributeAccessor node = entryIterator.hasNext() ? entryIterator.next().getValue() : null;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SortedMap<SnmpOid, AttributeAccessor> nextSet(SnmpOid oid) {
        TreeMap<SnmpOid, AttributeAccessor> nodeMap = new TreeMap<SnmpOid, AttributeAccessor>();
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            nodeMap.putAll(this.mib.tailMap(SnmpOid.newInstance(oid.getOid(), 0)));
        }
        nodeMap.putAll(this.other.nextSet(oid));
        return nodeMap;
    }

    public final String toString() {
        return "JvmSnmpMib[" + this.mib.values() + "]";
    }
}

