/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.snmpadaptor4j.SnmpAppContext;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.api.SnmpMib;
import net.sf.snmpadaptor4j.mbean.SystemInfo;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;

public class SystemSnmpMib
implements SnmpMib {
    private final SnmpAppContext mainAppContext;
    private final Map<ClassLoader, SnmpAppContext> appContextMap;
    private final SystemInfo systemInfo;
    private final SortedMap<SnmpOid, AttributeAccessor> mib = new TreeMap<SnmpOid, AttributeAccessor>();

    protected SystemSnmpMib(SystemInfo systemInfo) {
        this.mainAppContext = null;
        this.appContextMap = null;
        this.systemInfo = systemInfo;
    }

    public SystemSnmpMib(SnmpAppContext mainAppContext, Map<ClassLoader, SnmpAppContext> appContextMap, SystemInfo systemInfo) {
        this.mainAppContext = mainAppContext;
        this.appContextMap = appContextMap;
        this.systemInfo = systemInfo;
        this.initSysObjectIDSet();
    }

    protected final SortedMap<SnmpOid, AttributeAccessor> getMib() {
        return this.mib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSysObjectIDSet() {
        SnmpOid oid;
        TreeSet<SnmpOid> sysObjectIDSet = new TreeSet<SnmpOid>();
        if (this.mainAppContext.getDefaultRootOid() != null) {
            sysObjectIDSet.add(SnmpOid.newInstance(this.mainAppContext.getDefaultRootOid()));
        }
        for (String rootOid : this.mainAppContext.getRootOidMap().values()) {
            oid = SnmpOid.newInstance(rootOid);
            if (sysObjectIDSet.contains(oid)) continue;
            sysObjectIDSet.add(oid);
        }
        for (SnmpAppContext appContext : this.appContextMap.values()) {
            if (appContext.getDefaultRootOid() != null && !sysObjectIDSet.contains(oid = SnmpOid.newInstance(appContext.getDefaultRootOid()))) {
                sysObjectIDSet.add(oid);
            }
            for (String rootOid : appContext.getRootOidMap().values()) {
                oid = SnmpOid.newInstance(rootOid);
                if (sysObjectIDSet.contains(oid)) continue;
                sysObjectIDSet.add(oid);
            }
        }
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            this.mib.clear();
            oid = SnmpOid.SYSNAME_OID;
            this.putExternalNode(0, oid);
            oid = SnmpOid.SYSDESCR_OID;
            this.putExternalNode(1, oid);
            oid = SnmpOid.SYSLOCATION_OID;
            this.putExternalNode(2, oid);
            oid = SnmpOid.SYSCONTACT_OID;
            this.putExternalNode(3, oid);
            oid = SnmpOid.SYSUPTIME_OID;
            this.putExternalNode(4, oid);
            int index = 1;
            for (SnmpOid value : sysObjectIDSet) {
                if (sysObjectIDSet.size() == 1) {
                    oid = SnmpOid.newInstance(new int[]{1, 3, 6, 1, 2, 1, 1, 2, 0});
                    this.putExternalNode(oid, value);
                } else {
                    oid = SnmpOid.newInstance(new int[]{1, 3, 6, 1, 2, 1, 1, 2, index});
                    this.putExternalNode(oid, value);
                }
                ++index;
            }
        }
    }

    protected final void putExternalNode(int index, SnmpOid oid) {
        this.mib.put(oid, new ExternalNode(index, oid));
    }

    protected final void putExternalNode(SnmpOid oid, SnmpOid value) {
        this.mib.put(oid, new SysObjectIDExternalNode(oid, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AttributeAccessor find(SnmpOid oid) {
        AttributeAccessor node;
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            node = (AttributeAccessor)this.mib.get(oid);
        }
        return node;
    }

    @Override
    public final AttributeAccessor next(SnmpOid oid) {
        Iterator<Map.Entry<SnmpOid, AttributeAccessor>> entryIterator = this.nextSet(oid).entrySet().iterator();
        AttributeAccessor node = entryIterator.hasNext() ? entryIterator.next().getValue() : null;
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SortedMap<SnmpOid, AttributeAccessor> nextSet(SnmpOid oid) {
        SortedMap<SnmpOid, AttributeAccessor> nodeMap;
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            nodeMap = this.mib.tailMap(SnmpOid.newInstance(oid.getOid(), 0));
        }
        return nodeMap;
    }

    protected final SnmpDataType getSnmpDataType(int index) {
        SnmpDataType type;
        switch (index) {
            case 0: {
                type = SnmpDataType.octetString;
                break;
            }
            case 1: {
                type = SnmpDataType.octetString;
                break;
            }
            case 2: {
                type = SnmpDataType.octetString;
                break;
            }
            case 3: {
                type = SnmpDataType.octetString;
                break;
            }
            case 4: {
                type = SnmpDataType.timeTicks;
                break;
            }
            default: {
                type = null;
            }
        }
        return type;
    }

    protected final Class<?> getJmxDataType(int index) {
        Class type;
        switch (index) {
            case 0: {
                type = String.class;
                break;
            }
            case 1: {
                type = String.class;
                break;
            }
            case 2: {
                type = String.class;
                break;
            }
            case 3: {
                type = String.class;
                break;
            }
            case 4: {
                type = Long.class;
                break;
            }
            default: {
                type = null;
            }
        }
        return type;
    }

    public final Object getValue(int index) {
        Object value;
        switch (index) {
            case 0: {
                value = this.systemInfo.getSysName();
                break;
            }
            case 1: {
                value = this.systemInfo.getSysDescr();
                break;
            }
            case 2: {
                value = this.systemInfo.getSysLocation();
                break;
            }
            case 3: {
                value = this.systemInfo.getSysContact();
                break;
            }
            case 4: {
                value = new Long(this.systemInfo.getSysUpTime());
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        String values;
        SortedMap<SnmpOid, AttributeAccessor> sortedMap = this.mib;
        synchronized (sortedMap) {
            values = this.mib.values().toString();
        }
        return "SystemSnmpMib" + values;
    }

    protected final class SysObjectIDExternalNode
    implements AttributeAccessor {
        private final SnmpOid oid;
        private final SnmpOid value;

        protected SysObjectIDExternalNode(SnmpOid oid, SnmpOid value) {
            this.oid = oid;
            this.value = value;
        }

        @Override
        public SnmpOid getOid() {
            return this.oid;
        }

        @Override
        public SnmpDataType getSnmpDataType() {
            return SnmpDataType.objectIdentifier;
        }

        @Override
        public Class<?> getJmxDataType() {
            return SnmpOid.class;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        public String toString() {
            return this.getOid() + ": (" + (Object)((Object)this.getSnmpDataType()) + ") " + this.getValue();
        }
    }

    protected final class ExternalNode
    implements AttributeAccessor {
        private final int index;
        private final SnmpOid oid;

        protected ExternalNode(int index, SnmpOid oid) {
            this.index = index;
            this.oid = oid;
        }

        @Override
        public SnmpOid getOid() {
            return this.oid;
        }

        @Override
        public SnmpDataType getSnmpDataType() {
            return SystemSnmpMib.this.getSnmpDataType(this.index);
        }

        @Override
        public Class<?> getJmxDataType() {
            return SystemSnmpMib.this.getJmxDataType(this.index);
        }

        @Override
        public Object getValue() {
            return SystemSnmpMib.this.getValue(this.index);
        }

        @Override
        public void setValue(Object value) {
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        public String toString() {
            return this.getOid() + ": (" + (Object)((Object)this.getSnmpDataType()) + ") " + this.getValue();
        }
    }
}

