/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core.accessor;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;

public final class CompositeDataAttributeAccessor
implements AttributeAccessor {
    private final SnmpOid oid;
    private final MBeanServer server;
    private final ObjectName mBeanName;
    private final String attributeName;
    private final String attributeKey;
    private final SnmpDataType snmpDataType;
    private final Class<?> jmxDataType;

    public CompositeDataAttributeAccessor(SnmpOid oid, MBeanServer server, ObjectName mBeanName, String attributeName, String attributeKey, SnmpDataType snmpDataType, Class<?> jmxDataType) {
        this.oid = oid;
        this.server = server;
        this.mBeanName = mBeanName;
        this.attributeName = attributeName;
        this.attributeKey = attributeKey;
        this.snmpDataType = snmpDataType;
        this.jmxDataType = jmxDataType;
    }

    @Override
    public SnmpOid getOid() {
        return this.oid;
    }

    @Override
    public SnmpDataType getSnmpDataType() {
        return this.snmpDataType;
    }

    @Override
    public Class<?> getJmxDataType() {
        return this.jmxDataType;
    }

    @Override
    public Object getValue() throws Exception {
        Object value = null;
        CompositeData compositeData = (CompositeData)this.server.getAttribute(this.mBeanName, this.attributeName);
        if (compositeData != null) {
            value = compositeData.get(this.attributeKey);
        }
        return value;
    }

    @Override
    public void setValue(Object value) {
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    public String toString() {
        Object value;
        try {
            value = this.getValue();
        }
        catch (Throwable e) {
            value = "ERROR: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getName());
        }
        return this.oid + ": (" + (Object)((Object)this.getSnmpDataType()) + ") " + value;
    }
}

