/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core.accessor;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;

public final class JvmAttributeAccessor
implements AttributeAccessor {
    private final MBeanServer server;
    private final ObjectName mBeanName;
    private final SnmpOid oid;
    private final String attributeName;
    private final SnmpDataType snmpDataType;
    private final Class<?> jmxDataType;
    private final boolean writable;

    public JvmAttributeAccessor(MBeanServer server, ObjectName mBeanName, SnmpOid oid, String attributeName, SnmpDataType snmpDataType, Class<?> jmxDataType, boolean writable) {
        this.server = server;
        this.mBeanName = mBeanName;
        this.oid = oid;
        this.attributeName = attributeName;
        this.snmpDataType = snmpDataType;
        this.jmxDataType = jmxDataType;
        this.writable = writable;
    }

    @Override
    public SnmpOid getOid() {
        return this.oid;
    }

    @Override
    public SnmpDataType getSnmpDataType() {
        return this.snmpDataType;
    }

    @Override
    public Class<?> getJmxDataType() {
        return this.jmxDataType;
    }

    @Override
    public Object getValue() throws Exception {
        return this.server.getAttribute(this.mBeanName, this.attributeName);
    }

    @Override
    public void setValue(Object value) throws Exception {
        this.server.setAttribute(this.mBeanName, new Attribute(this.attributeName, value));
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    public String toString() {
        return "JvmAttributeAccessor[oid=" + this.oid + "; attributeName=" + this.attributeName + "; snmpDataType=" + (Object)((Object)this.snmpDataType) + "; jmxDataType=" + this.jmxDataType + "; readable=" + this.isReadable() + "; writable=" + this.writable + "]";
    }
}

