/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core.accessor;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.snmpadaptor4j.api.AttributeAccessor;
import net.sf.snmpadaptor4j.core.mapping.MBeanAttributeMapping;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;

public final class MBeanAttributeAccessor
implements AttributeAccessor {
    private final MBeanServer server;
    private final ObjectName mBeanName;
    private final MBeanAttributeMapping mapping;

    public MBeanAttributeAccessor(MBeanServer server, ObjectName mBeanName, MBeanAttributeMapping mapping) {
        this.server = server;
        this.mBeanName = mBeanName;
        this.mapping = mapping;
    }

    public ObjectName getMBeanName() {
        return this.mBeanName;
    }

    @Override
    public SnmpOid getOid() {
        return this.mapping.getOid();
    }

    @Override
    public SnmpDataType getSnmpDataType() {
        return this.mapping.getSnmpDataType();
    }

    @Override
    public Class<?> getJmxDataType() {
        return this.mapping.getJmxDataType();
    }

    @Override
    public Object getValue() throws Exception {
        return this.server.getAttribute(this.mBeanName, this.mapping.getAttributeName());
    }

    @Override
    public void setValue(Object value) throws Exception {
        this.server.setAttribute(this.mBeanName, new Attribute(this.mapping.getAttributeName(), value));
    }

    @Override
    public boolean isReadable() {
        return this.mapping.isReadable();
    }

    @Override
    public boolean isWritable() {
        return this.mapping.isWritable();
    }

    public String toString() {
        Object value;
        try {
            value = this.getValue();
        }
        catch (Throwable e) {
            value = "ERROR: " + (e.getMessage() != null ? e.getMessage() : e.getClass().getName());
        }
        return this.mapping.getOid() + ": (" + (Object)((Object)this.mapping.getSnmpDataType()) + ") " + value;
    }
}

