/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.core.mapping;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import net.sf.snmpadaptor4j.core.mapping.DataMapTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.DefaultDataMapTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.GenericSnmpTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.MBeanAttributeMapping;
import net.sf.snmpadaptor4j.core.mapping.MapDataMapTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.SimpleDataMapTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.SnmpTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.SpecificSnmpTrapMapping;
import net.sf.snmpadaptor4j.core.mapping.jaxb.GenericTrap;
import net.sf.snmpadaptor4j.core.mapping.jaxb.MBean;
import net.sf.snmpadaptor4j.core.mapping.jaxb.MBeanAttribute;
import net.sf.snmpadaptor4j.core.mapping.jaxb.MBeanNotifications;
import net.sf.snmpadaptor4j.core.mapping.jaxb.Mapping;
import net.sf.snmpadaptor4j.core.mapping.jaxb.SpecificTrap;
import net.sf.snmpadaptor4j.core.mapping.jaxb.TrapEnterprise;
import net.sf.snmpadaptor4j.core.mapping.jaxb.TrapUserData;
import net.sf.snmpadaptor4j.core.mapping.jaxb.TrapUserDataEntry;
import net.sf.snmpadaptor4j.core.mapping.jaxb.TrapUserDataMap;
import net.sf.snmpadaptor4j.core.mapping.jaxb.TrapVariableBindings;
import net.sf.snmpadaptor4j.object.GenericSnmpTrapType;
import net.sf.snmpadaptor4j.object.SnmpDataType;
import net.sf.snmpadaptor4j.object.SnmpOid;

public final class XmlMappingParser {
    private final URL url;
    private final JAXBElement<Mapping> jaxbElement;

    public static XmlMappingParser newInstance(URL url) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)Mapping.class.getPackage().getName());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement jaxbElement = (JAXBElement)unmarshaller.unmarshal(url);
        return new XmlMappingParser(url, (JAXBElement<Mapping>)jaxbElement);
    }

    private XmlMappingParser(URL url, JAXBElement<Mapping> jaxbElement) {
        this.url = url;
        this.jaxbElement = jaxbElement;
    }

    public String findBaseOid(ObjectName mBeanName, Map<String, String> rootOidMap, String defaultRootOid, String mainDefaultRootOid) {
        String baseOid = null;
        Mapping mapping = (Mapping)this.jaxbElement.getValue();
        if (mapping.getMbeans() != null) {
            Iterator<MBean> mBeanIterator = mapping.getMbeans().getMbean().iterator();
            String desiredName = mBeanName.toString();
            while (mBeanIterator.hasNext() && baseOid == null) {
                MBean mBean = mBeanIterator.next();
                if (!mBean.getName().equals(desiredName)) continue;
                if (mBean.getRoot() != null) {
                    baseOid = rootOidMap.get(mBean.getRoot());
                }
                if (baseOid == null) {
                    baseOid = defaultRootOid;
                }
                if (baseOid == null) {
                    baseOid = mainDefaultRootOid;
                }
                baseOid = baseOid + "." + mBean.getOid();
            }
        }
        return baseOid;
    }

    public List<MBeanAttributeMapping> newMBeanAttributeMappingList(Map<String, MBeanAttributeInfo> mBeanAttributeInfoMap, ClassLoader classLoader, String baseOid) throws Exception {
        ArrayList<MBeanAttributeMapping> mappingList = new ArrayList<MBeanAttributeMapping>();
        for (MBeanAttribute attribute : ((Mapping)this.jaxbElement.getValue()).getAttributes().getAttribute()) {
            String attributeName = attribute.getName().substring(0, 1).toUpperCase() + attribute.getName().substring(1);
            MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoMap.get(attributeName);
            SnmpOid oid = SnmpOid.newInstance(baseOid, attribute.getNode(), 0);
            SnmpDataType snmpDataType = SnmpDataType.valueOf(attribute.getType().value());
            Class<?> jmxDataType = this.toClass(classLoader, mBeanAttributeInfo.getType());
            boolean readable = mBeanAttributeInfo.isReadable() && !attribute.isDisabled();
            boolean writable = readable && mBeanAttributeInfo.isWritable() && attribute.isWritable();
            mappingList.add(new MBeanAttributeMapping(oid, attributeName, snmpDataType, jmxDataType, readable, writable));
        }
        return mappingList;
    }

    private Class<?> toClass(ClassLoader classLoader, String className) throws Exception {
        Class<Comparable<Byte>> result = Byte.TYPE.getName().equals(className) ? Byte.TYPE : (Short.TYPE.getName().equals(className) ? Short.TYPE : (Integer.TYPE.getName().equals(className) ? Integer.TYPE : (Boolean.TYPE.getName().equals(className) ? Boolean.TYPE : (Long.TYPE.getName().equals(className) ? Long.TYPE : (byte[].class.getName().equals(className) ? byte[].class : (short[].class.getName().equals(className) ? short[].class : (int[].class.getName().equals(className) ? int[].class : (long[].class.getName().equals(className) ? long[].class : classLoader.loadClass(className)))))))));
        return result;
    }

    public Map<String, SnmpTrapMapping> newSnmpTrapMappingMap(String baseOid) {
        HashMap<String, SnmpTrapMapping> trapMapping = new HashMap<String, SnmpTrapMapping>();
        MBeanNotifications notifications = ((Mapping)this.jaxbElement.getValue()).getNotifications();
        if (notifications != null) {
            Map<String, DataMapTrapMapping> dataMapMappingMap = this.newDataMapTrapMappingMap(baseOid, notifications.getVariableBindings());
            DefaultDataMapTrapMapping defaultDataMapMapping = this.newDefaultDataMapTrapMapping(baseOid, notifications.getVariableBindings());
            for (TrapEnterprise enterprise : notifications.getEnterprise()) {
                SnmpOid source;
                DataMapTrapMapping dataMapMapping;
                for (GenericTrap genericTrap : enterprise.getGenericTrap()) {
                    dataMapMapping = this.findDataMapTrapMapping(dataMapMappingMap, defaultDataMapMapping, enterprise, genericTrap.getUserdata());
                    source = SnmpOid.newInstance(baseOid, enterprise.getNode(), 0);
                    GenericSnmpTrapType genericType = GenericSnmpTrapType.valueOf(genericTrap.getCode().value());
                    trapMapping.put(genericTrap.getNotifType(), new GenericSnmpTrapMapping(source, dataMapMapping, genericType));
                }
                for (SpecificTrap specificTrap : enterprise.getSpecificTrap()) {
                    dataMapMapping = this.findDataMapTrapMapping(dataMapMappingMap, defaultDataMapMapping, enterprise, specificTrap.getUserdata());
                    source = SnmpOid.newInstance(baseOid, enterprise.getNode(), 0);
                    trapMapping.put(specificTrap.getNotifType(), new SpecificSnmpTrapMapping(source, dataMapMapping, specificTrap.getCode()));
                }
            }
        }
        return trapMapping;
    }

    private DataMapTrapMapping findDataMapTrapMapping(Map<String, DataMapTrapMapping> dataMapMappingMap, DataMapTrapMapping defaultDataMapMapping, TrapEnterprise enterprise, String userDataName) {
        String dataMapMappingName;
        DataMapTrapMapping dataMapMapping = null;
        String string = dataMapMappingName = userDataName != null ? userDataName : enterprise.getUserdata();
        if (dataMapMappingName != null) {
            dataMapMapping = dataMapMappingMap.get(dataMapMappingName);
        }
        if (dataMapMapping == null) {
            dataMapMapping = defaultDataMapMapping;
        }
        return dataMapMapping;
    }

    private Map<String, DataMapTrapMapping> newDataMapTrapMappingMap(String baseOid, TrapVariableBindings variableBindings) {
        HashMap<String, DataMapTrapMapping> dataMapMappingMap = new HashMap<String, DataMapTrapMapping>();
        if (variableBindings != null) {
            SnmpOid userDataOid;
            SnmpDataType userDataType;
            SnmpOid sequenceNumberOid = variableBindings.getSequenceNumber() != null ? SnmpOid.newInstance(baseOid, variableBindings.getSequenceNumber().getNode(), 0) : null;
            SnmpOid messageOid = variableBindings.getMessage() != null ? SnmpOid.newInstance(baseOid, variableBindings.getMessage().getNode(), 0) : null;
            boolean hasSystemInfo = variableBindings.isSystemInfo();
            for (TrapUserData userData : variableBindings.getUserdata()) {
                userDataType = SnmpDataType.valueOf(userData.getType().value());
                userDataOid = SnmpOid.newInstance(baseOid, userData.getNode(), 0);
                SimpleDataMapTrapMapping dataMapMapping = new SimpleDataMapTrapMapping(sequenceNumberOid, messageOid, hasSystemInfo, userDataType, userDataOid);
                dataMapMappingMap.put(userData.getName(), dataMapMapping);
            }
            for (TrapUserDataMap userDataMap : variableBindings.getUserdataMap()) {
                MapDataMapTrapMapping mapDataMapMapping = new MapDataMapTrapMapping(sequenceNumberOid, messageOid, hasSystemInfo);
                for (TrapUserDataEntry entry : userDataMap.getEntry()) {
                    userDataType = SnmpDataType.valueOf(entry.getType().value());
                    userDataOid = SnmpOid.newInstance(baseOid, entry.getNode(), 0);
                    mapDataMapMapping.addUserDataEntry(entry.getKey(), userDataType, userDataOid);
                }
                dataMapMappingMap.put(userDataMap.getName(), mapDataMapMapping);
            }
        }
        return dataMapMappingMap;
    }

    private DefaultDataMapTrapMapping newDefaultDataMapTrapMapping(String baseOid, TrapVariableBindings variableBindings) {
        DefaultDataMapTrapMapping defaultDataMapMapping;
        if (variableBindings != null) {
            SnmpOid sequenceNumberOid = variableBindings.getSequenceNumber() != null ? SnmpOid.newInstance(baseOid, variableBindings.getSequenceNumber().getNode(), 0) : null;
            SnmpOid messageOid = variableBindings.getMessage() != null ? SnmpOid.newInstance(baseOid, variableBindings.getMessage().getNode(), 0) : null;
            boolean hasSystemInfo = variableBindings.isSystemInfo();
            defaultDataMapMapping = new DefaultDataMapTrapMapping(sequenceNumberOid, messageOid, hasSystemInfo);
        } else {
            defaultDataMapMapping = new DefaultDataMapTrapMapping(null, null, false);
        }
        return defaultDataMapMapping;
    }

    public String toString() {
        return "XmlMappingParser[" + this.url + "]";
    }
}

