/*
 * Decompiled with CFR 0.152.
 */
package net.sf.snmpadaptor4j.mbean;

import java.io.Serializable;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import net.sf.snmpadaptor4j.mbean.SystemInfoMBean;

public final class SystemInfo
extends StandardMBean
implements SystemInfoMBean,
Serializable {
    private static final long serialVersionUID = -6965962577731511748L;
    private String sysName;
    private String sysDescr;
    private String sysLocation;
    private String sysContact;
    private final long lastBootTime;

    public SystemInfo() throws NotCompliantMBeanException {
        this(null, null, null, null);
    }

    public SystemInfo(String sysName, String sysDescr) throws NotCompliantMBeanException {
        this(sysName, sysDescr, null, null);
    }

    public SystemInfo(String sysName, String sysDescr, String sysLocation, String sysContact) throws NotCompliantMBeanException {
        super(SystemInfoMBean.class);
        String sysNameDescription = "Name given to the Java application (corresponds to SNMP attribute system.sysName.0)";
        String sysDescrDescription = "Description on the Java application (corresponds to SNMP attribute system.sysDescr.0)";
        String sysLocationDescription = "Location of the computer hosting the Java application (corresponds to SNMP attribute system.sysLocation.0)";
        String sysContactDescription = "Administrator contact of the Java application (corresponds to SNMP attribute system.sysContact.0)";
        String sysUpTimeDescription = "Elapsed time in milliseconds since the last boot of the Java application (corresponds to SNMP attribute system.sysUpTime.0)";
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("SysName", String.class.getName(), "Name given to the Java application (corresponds to SNMP attribute system.sysName.0)", true, true, false), new MBeanAttributeInfo("SysDescr", String.class.getName(), "Description on the Java application (corresponds to SNMP attribute system.sysDescr.0)", true, true, false), new MBeanAttributeInfo("SysLocation", String.class.getName(), "Location of the computer hosting the Java application (corresponds to SNMP attribute system.sysLocation.0)", true, true, false), new MBeanAttributeInfo("SysContact", String.class.getName(), "Administrator contact of the Java application (corresponds to SNMP attribute system.sysContact.0)", true, true, false), new MBeanAttributeInfo("SysUpTime", Long.TYPE.getName(), "Elapsed time in milliseconds since the last boot of the Java application (corresponds to SNMP attribute system.sysUpTime.0)", true, false, false)};
        MBeanConstructorInfo constructor1 = new MBeanConstructorInfo(this.getClass().getName(), "Constructor without parameter", new MBeanParameterInfo[0]);
        MBeanConstructorInfo constructor2 = new MBeanConstructorInfo(this.getClass().getName(), "Constructor with only sysName and sysDescr parameters", new MBeanParameterInfo[]{new MBeanParameterInfo("sysName", String.class.getName(), "Name given to the Java application (corresponds to SNMP attribute system.sysName.0)"), new MBeanParameterInfo("sysDescr", String.class.getName(), "Description on the Java application (corresponds to SNMP attribute system.sysDescr.0)")});
        MBeanConstructorInfo constructor3 = new MBeanConstructorInfo(this.getClass().getName(), "Constructor with all parameters", new MBeanParameterInfo[]{new MBeanParameterInfo("sysName", String.class.getName(), "Name given to the Java application (corresponds to SNMP attribute system.sysName.0)"), new MBeanParameterInfo("sysDescr", String.class.getName(), "Description on the Java application (corresponds to SNMP attribute system.sysDescr.0)"), new MBeanParameterInfo("sysLocation", String.class.getName(), "Location of the computer hosting the Java application (corresponds to SNMP attribute system.sysLocation.0)"), new MBeanParameterInfo("sysContact", String.class.getName(), "Administrator contact of the Java application (corresponds to SNMP attribute system.sysContact.0)")});
        MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[]{constructor1, constructor2, constructor3};
        this.cacheMBeanInfo(new MBeanInfo(this.getClass().getName(), "Informations on the Java application (used by SNMP)", attributes, constructors, new MBeanOperationInfo[0], new MBeanNotificationInfo[0]));
        String string = sysName != null ? (sysName.trim().length() > 0 ? sysName : "javaApp") : (this.sysName = "javaApp");
        String string2 = sysDescr != null ? (sysDescr.trim().length() > 0 ? sysDescr : "Java application") : (this.sysDescr = "Java application");
        String string3 = sysLocation != null ? (sysLocation.trim().length() > 0 ? sysLocation : null) : (this.sysLocation = null);
        this.sysContact = sysContact != null ? (sysContact.trim().length() > 0 ? sysContact : null) : null;
        this.lastBootTime = System.currentTimeMillis();
    }

    @Override
    public String getSysName() {
        return this.sysName;
    }

    @Override
    public void setSysName(String sysName) {
        this.sysName = sysName != null ? (sysName.trim().length() > 0 ? sysName : null) : null;
    }

    @Override
    public String getSysDescr() {
        return this.sysDescr;
    }

    @Override
    public void setSysDescr(String sysDescr) {
        this.sysDescr = sysDescr != null ? (sysDescr.trim().length() > 0 ? sysDescr : null) : null;
    }

    @Override
    public String getSysLocation() {
        return this.sysLocation;
    }

    @Override
    public void setSysLocation(String sysLocation) {
        this.sysLocation = sysLocation != null ? (sysLocation.trim().length() > 0 ? sysLocation : null) : null;
    }

    @Override
    public String getSysContact() {
        return this.sysContact;
    }

    @Override
    public void setSysContact(String sysContact) {
        this.sysContact = sysContact != null ? (sysContact.trim().length() > 0 ? sysContact : null) : null;
    }

    @Override
    public long getSysUpTime() {
        return System.currentTimeMillis() - this.lastBootTime;
    }

    public String toString() {
        return this.sysName + " (" + this.sysDescr + ") - location: " + this.sysLocation + " - contact: " + this.sysContact;
    }
}

